/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.schema.SchemaMergeException;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOUnion
extends RelationalOperator {
    private static final long serialVersionUID = 2L;
    private static Log log = LogFactory.getLog(LOUnion.class);
    private boolean isOnSchema = false;

    public LOUnion(LogicalPlan plan, OperatorKey k) {
        super(plan, k);
    }

    public List<LogicalOperator> getInputs() {
        return this.mPlan.getPredecessors(this);
    }

    @Override
    public Schema getSchema() throws FrontendException {
        if (!this.mIsSchemaComputed) {
            List<LOUnion> s = this.mPlan.getPredecessors(this);
            log.debug((Object)("Number of predecessors in the graph: " + s.size()));
            try {
                Iterator<LogicalOperator> iter = s.iterator();
                if (this.isOnSchema) {
                    this.mSchema = this.createMergedSchemaOnAlias(iter);
                } else {
                    LogicalOperator op = (LogicalOperator)iter.next();
                    if (null == op) {
                        int errCode = 1006;
                        String string = "Could not find operator in plan";
                        throw new FrontendException(string, errCode, 2, false, null);
                    }
                    this.mSchema = op.getSchema() != null ? new Schema(op.getSchema()) : null;
                    while (iter.hasNext()) {
                        op = iter.next();
                        if (null != this.mSchema) {
                            this.mSchema = this.mSchema.merge(op.getSchema(), false);
                            continue;
                        }
                        this.mSchema = null;
                        break;
                    }
                }
                if (null != this.mSchema) {
                    for (Schema.FieldSchema fs : this.mSchema.getFields()) {
                        for (LogicalOperator logicalOperator : s) {
                            Schema opSchema = logicalOperator.getSchema();
                            if (null != opSchema) {
                                for (Schema.FieldSchema opFs : opSchema.getFields()) {
                                    fs.setParent(opFs.canonicalName, logicalOperator);
                                }
                                continue;
                            }
                            fs.setParent(null, logicalOperator);
                        }
                    }
                }
                this.mIsSchemaComputed = true;
            }
            catch (FrontendException fe) {
                this.mSchema = null;
                this.mIsSchemaComputed = false;
                throw fe;
            }
        }
        return this.mSchema;
    }

    private Schema createMergedSchemaOnAlias(Iterator<LogicalOperator> iter) throws FrontendException {
        Schema mergedSchema;
        String msg;
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        while (iter.hasNext()) {
            LogicalOperator lop = iter.next();
            Schema sch = lop.getSchema();
            if (sch == null) {
                msg = "Schema of relation " + lop.getAlias() + " is null." + " UNION ONSCHEMA cannot be used with relations that" + " have null schema.";
                throw new FrontendException(msg, 1116, 2);
            }
            for (Schema.FieldSchema fs : sch.getFields()) {
                if (fs.alias != null) continue;
                String msg2 = "Schema of relation " + lop.getAlias() + " has a null fieldschema for column(s). Schema :" + sch;
                throw new FrontendException(msg2, 1116, 2);
            }
            schemas.add(sch);
        }
        try {
            mergedSchema = Schema.mergeSchemasByAlias(schemas);
        }
        catch (SchemaMergeException e) {
            msg = "Error merging schemas for union operator : " + e.getMessage();
            throw new FrontendException(msg, 1116, 2, e);
        }
        return mergedSchema;
    }

    @Override
    public String name() {
        return this.getAliasString() + "Union " + this.mKey.scope + "-" + this.mKey.id;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    public byte getType() {
        return 120;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        LOUnion unionClone = (LOUnion)super.clone();
        return unionClone;
    }

    @Override
    public ProjectionMap getProjectionMap() {
        Schema outputSchema;
        if (this.mIsProjectionMapComputed) {
            return this.mProjectionMap;
        }
        this.mIsProjectionMapComputed = true;
        try {
            outputSchema = this.getSchema();
        }
        catch (FrontendException fee) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        if (outputSchema == null) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        MultiMap<Integer, ProjectionMap.Column> mapFields = new MultiMap<Integer, ProjectionMap.Column>();
        for (int inputNum = 0; inputNum < predecessors.size(); ++inputNum) {
            LogicalOperator predecessor = (LogicalOperator)predecessors.get(inputNum);
            Schema inputSchema = null;
            try {
                inputSchema = predecessor.getSchema();
            }
            catch (FrontendException fee) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
            if (inputSchema == null) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
            for (int inputColumn = 0; inputColumn < inputSchema.size(); ++inputColumn) {
                mapFields.put((Integer)inputColumn, new ProjectionMap.Column(new Pair<Integer, Integer>(inputNum, inputColumn)));
            }
        }
        this.mProjectionMap = new ProjectionMap(mapFields, null, null);
        return this.mProjectionMap;
    }

    @Override
    public List<RequiredFields> getRequiredFields() {
        List<LOUnion> predecessors = this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            return null;
        }
        ArrayList<RequiredFields> requiredFields = new ArrayList<RequiredFields>();
        for (int inputNum = 0; inputNum < predecessors.size(); ++inputNum) {
            requiredFields.add(new RequiredFields(true));
        }
        return requiredFields.size() == 0 ? null : requiredFields;
    }

    @Override
    public List<RequiredFields> getRelevantInputs(int output, int column) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (output != 0) {
            return null;
        }
        if (column < 0) {
            return null;
        }
        if (this.mSchema != null && column >= this.mSchema.size()) {
            return null;
        }
        List<LOUnion> predecessors = this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            return null;
        }
        ArrayList<RequiredFields> result = new ArrayList<RequiredFields>();
        for (int i = 0; i < predecessors.size(); ++i) {
            ArrayList<Pair<Integer, Integer>> inputList = new ArrayList<Pair<Integer, Integer>>();
            inputList.add(new Pair<Integer, Integer>(i, column));
            result.add(new RequiredFields(inputList));
        }
        return result;
    }

    @Override
    public boolean pruneColumns(List<Pair<Integer, Integer>> columns) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (this.mSchema == null) {
            log.warn((Object)"Cannot prune columns in union, no schema information found");
            return false;
        }
        boolean[] maximumPruned = new boolean[this.mSchema.size()];
        for (Pair<Integer, Integer> pair : columns) {
            maximumPruned[((Integer)pair.second).intValue()] = true;
        }
        int maximumNumPruned = 0;
        for (int i = 0; i < maximumPruned.length; ++i) {
            if (!maximumPruned[i]) continue;
            ++maximumNumPruned;
        }
        List<LogicalOperator> preds = this.getInputs();
        for (int i = 0; i < preds.size(); ++i) {
            boolean[] actualPruned = new boolean[this.mSchema.size()];
            for (Pair<Integer, Integer> pair : columns) {
                if ((Integer)pair.first != i) continue;
                actualPruned[((Integer)pair.second).intValue()] = true;
            }
            int actualNumPruned = 0;
            for (int j = 0; j < actualPruned.length; ++j) {
                if (!actualPruned[j]) continue;
                ++actualNumPruned;
            }
            if (actualNumPruned == maximumNumPruned) continue;
            ArrayList<Integer> columnsToProject = new ArrayList<Integer>();
            int index = 0;
            for (int j = 0; j < actualPruned.length; ++j) {
                if (!maximumPruned[j]) {
                    columnsToProject.add(index);
                    ++index;
                    continue;
                }
                if (actualPruned[j]) continue;
                ++index;
            }
            ((RelationalOperator)preds.get(i)).insertPlainForEachAfter(columnsToProject);
        }
        super.pruneColumns(columns);
        return true;
    }

    public void setOnSchema(boolean isOnSchema) {
        this.isOnSchema = isOnSchema;
    }

    public boolean isOnSchema() {
        return this.isOnSchema;
    }
}

