/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.expression;

import java.util.List;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.ColumnExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class MapLookupExpression
extends ColumnExpression {
    private String mMapKey;
    private LogicalSchema.LogicalFieldSchema mValueSchema;

    public MapLookupExpression(OperatorPlan plan, String mapKey, LogicalSchema.LogicalFieldSchema valueSchema) {
        super("Map", plan);
        this.mMapKey = mapKey;
        this.mValueSchema = valueSchema;
        plan.add(this);
    }

    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalExpressionVisitor)) {
            throw new FrontendException("Expected LogicalExpressionVisitor", 2222);
        }
        ((LogicalExpressionVisitor)v).visit(this);
    }

    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof MapLookupExpression) {
            MapLookupExpression po = (MapLookupExpression)other;
            if (po.mMapKey.compareTo(this.mMapKey) != 0 || !po.mValueSchema.isEqual(this.mValueSchema)) {
                return false;
            }
            if (this.plan.getSuccessors(this) != null) {
                if (other.getPlan().getSuccessors(other) == null) {
                    return false;
                }
                return this.plan.getSuccessors(this).get(0).isEqual(other.getPlan().getSuccessors(other).get(0));
            }
            return other.getPlan().getSuccessors(other) == null;
        }
        return false;
    }

    public LogicalExpression getMap() throws FrontendException {
        List<Operator> preds = this.plan.getSuccessors(this);
        if (preds == null) {
            return null;
        }
        return (LogicalExpression)preds.get(0);
    }

    public String getLookupKey() {
        return this.mMapKey;
    }

    public LogicalSchema.LogicalFieldSchema getFieldSchema() throws FrontendException {
        if (this.fieldSchema != null) {
            return this.fieldSchema;
        }
        this.fieldSchema = this.mValueSchema != null ? this.mValueSchema : new LogicalSchema.LogicalFieldSchema(null, null, 0);
        this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
        return this.fieldSchema;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("(Name: " + this.name + " Type: ");
        if (this.fieldSchema != null) {
            msg.append(DataType.findTypeName(this.fieldSchema.type));
        } else {
            msg.append("null");
        }
        msg.append(" Uid: ");
        if (this.fieldSchema != null) {
            msg.append(this.fieldSchema.uid);
        } else {
            msg.append("null");
        }
        msg.append(" Key: " + this.mMapKey);
        msg.append(")");
        return msg.toString();
    }

    public LogicalExpression deepCopy(LogicalExpressionPlan lgExpPlan) throws FrontendException {
        MapLookupExpression copy = null;
        copy = new MapLookupExpression(lgExpPlan, this.getLookupKey(), this.getFieldSchema().deepCopy());
        LogicalExpression input = (LogicalExpression)this.plan.getSuccessors(this).get(0);
        LogicalExpression inputCopy = input.deepCopy(lgExpPlan);
        lgExpPlan.add(inputCopy);
        lgExpPlan.connect(copy, inputCopy);
        return copy;
    }
}

