/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.IdentityHashSet;
import org.apache.pig.pen.util.MetricEvaluation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayExamples {
    public static final int MAX_DATAATOM_LENGTH = 25;

    static void printMetrics(LogicalOperator op, Map<LogicalOperator, DataBag> derivedData, Map<LogicalOperator, Collection<IdentityHashSet<Tuple>>> OperatorToEqClasses) {
        System.out.println("Realness : " + MetricEvaluation.getRealness(op, derivedData, true) + "\n" + "Conciseness : " + MetricEvaluation.getConciseness(op, derivedData, OperatorToEqClasses, true) + "\n" + "Completeness : " + MetricEvaluation.getCompleteness(op, derivedData, OperatorToEqClasses, true) + "\n");
    }

    public static String printTabular(LogicalPlan lp, Map<LogicalOperator, DataBag> exampleData) {
        StringBuffer output = new StringBuffer();
        LogicalOperator currentOp = (LogicalOperator)lp.getLeaves().get(0);
        DisplayExamples.printTabular(currentOp, exampleData, output);
        return output.toString();
    }

    static void printTabular(LogicalOperator op, Map<LogicalOperator, DataBag> exampleData, StringBuffer output) {
        DataBag bag = exampleData.get(op);
        List<LogicalOperator> inputs = op.getPlan().getPredecessors(op);
        if (inputs != null) {
            for (LogicalOperator Op : inputs) {
                DisplayExamples.printTabular(Op, exampleData, output);
            }
        }
        if (op.getAlias() != null) {
            try {
                DisplayExamples.DisplayTable(DisplayExamples.MakeArray(op, bag), op, bag, output);
            }
            catch (FrontendException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void printSimple(LogicalOperator op, Map<LogicalOperator, DataBag> exampleData) {
        DataBag bag = exampleData.get(op);
        List<LogicalOperator> inputs = op.getPlan().getPredecessors(op);
        if (inputs != null) {
            for (LogicalOperator lOp : inputs) {
                DisplayExamples.printSimple(lOp, exampleData);
            }
        }
        if (op.getAlias() != null) {
            System.out.println(op.getAlias() + " : " + bag);
        }
    }

    static String AddSpaces(int n, boolean printSpace) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (printSpace) {
                str.append(" ");
                continue;
            }
            str.append("-");
        }
        return str.toString();
    }

    static void DisplayTable(String[][] table, LogicalOperator op, DataBag bag, StringBuffer output) throws FrontendException {
        int i;
        int cols = op.getSchema().getFields().size();
        List<Schema.FieldSchema> fields = op.getSchema().getFields();
        int rows = (int)bag.size();
        int[] maxColSizes = new int[cols];
        for (int i2 = 0; i2 < cols; ++i2) {
            maxColSizes[i2] = fields.get(i2).toString().length();
            if (maxColSizes[i2] >= 5) continue;
            maxColSizes[i2] = 5;
        }
        int total = 0;
        int aliasLength = op.getAlias().length() + 4;
        for (int j = 0; j < cols; ++j) {
            for (int i3 = 0; i3 < rows; ++i3) {
                int length = table[i3][j].length();
                if (length <= maxColSizes[j]) continue;
                maxColSizes[j] = length;
            }
            total += maxColSizes[j];
        }
        output.append(DisplayExamples.AddSpaces(total + 3 * (cols + 1) + aliasLength + 1, false) + "\n");
        output.append("| " + op.getAlias() + DisplayExamples.AddSpaces(4, true) + " | ");
        for (i = 0; i < cols; ++i) {
            String field = fields.get(i).toString();
            output.append(field + DisplayExamples.AddSpaces(maxColSizes[i] - field.length(), true) + " | ");
        }
        output.append("\n" + DisplayExamples.AddSpaces(total + 3 * (cols + 1) + aliasLength + 1, false) + "\n");
        for (i = 0; i < rows; ++i) {
            output.append("| " + DisplayExamples.AddSpaces(aliasLength, true) + " | ");
            for (int j = 0; j < cols; ++j) {
                String str = table[i][j];
                output.append(str + DisplayExamples.AddSpaces(maxColSizes[j] - str.length(), true) + " | ");
            }
            output.append("\n");
        }
        output.append(DisplayExamples.AddSpaces(total + 3 * (cols + 1) + aliasLength + 1, false) + "\n");
    }

    static String[][] MakeArray(LogicalOperator op, DataBag bag) throws Exception {
        int rows = (int)bag.size();
        int cols = op.getSchema().getFields().size();
        String[][] table = new String[rows][cols];
        Iterator<Tuple> it = bag.iterator();
        for (int i = 0; i < rows; ++i) {
            Tuple t = it.next();
            for (int j = 0; j < cols; ++j) {
                table[i][j] = DisplayExamples.ShortenField(t.get(j));
            }
        }
        return table;
    }

    static String ShortenField(Object d) throws ExecException {
        if (d instanceof Tuple) {
            return DisplayExamples.ShortenField((Tuple)d);
        }
        if (d instanceof DataBag) {
            return DisplayExamples.ShortenField((DataBag)d);
        }
        if (DataType.findTypeName(d) != null) {
            return d.toString();
        }
        System.out.println("Unrecognized data-type received!!!");
        return null;
    }

    static String ShortenField(DataBag bag) throws ExecException {
        StringBuffer str = new StringBuffer();
        long size = bag.size();
        str.append("{");
        if (size > 3L) {
            Iterator<Tuple> it = bag.iterator();
            str.append(DisplayExamples.ShortenField(it.next()));
            while (it.hasNext()) {
                Tuple t = it.next();
                if (it.hasNext()) continue;
                str.append(", ..., " + DisplayExamples.ShortenField(t));
            }
        } else {
            Iterator<Tuple> it = bag.iterator();
            while (it.hasNext()) {
                Tuple t = it.next();
                if (it.hasNext()) {
                    str.append(DisplayExamples.ShortenField(t) + ", ");
                    continue;
                }
                str.append(DisplayExamples.ShortenField(t));
            }
        }
        str.append("}");
        return str.toString();
    }

    static String ShortenField(Tuple t) throws ExecException {
        StringBuffer str = new StringBuffer();
        int noFields = t.size();
        str.append("(");
        if (noFields > 3) {
            Object d = t.get(0);
            str.append(DisplayExamples.ShortenField(d) + ", ..., ");
            d = t.get(noFields - 1);
            str.append(DisplayExamples.ShortenField(d));
        } else {
            for (int i = 0; i < noFields; ++i) {
                Object d = t.get(i);
                if (i != noFields - 1) {
                    str.append(DisplayExamples.ShortenField(d) + ", ");
                    continue;
                }
                str.append(DisplayExamples.ShortenField(d));
            }
        }
        str.append(")");
        return str.toString();
    }
}

