/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.orm;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.sqoop.orm.ClassWriter;

public class AvroSchemaGenerator {
    private final SqoopOptions options;
    private final ConnManager connManager;
    private final String tableName;

    public AvroSchemaGenerator(SqoopOptions opts, ConnManager connMgr, String table) {
        this.options = opts;
        this.connManager = connMgr;
        this.tableName = table;
    }

    public Schema generate() throws IOException {
        ClassWriter classWriter = new ClassWriter(this.options, this.connManager, this.tableName, null);
        Map<String, Integer> columnTypes = classWriter.getColumnTypes();
        String[] columnNames = classWriter.getColumnNames(columnTypes);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (String columnName : columnNames) {
            String cleanedCol = ClassWriter.toIdentifier(columnName);
            int sqlType = columnTypes.get(cleanedCol);
            Schema avroSchema = this.toAvroSchema(sqlType, columnName);
            Schema.Field field = new Schema.Field(cleanedCol, avroSchema, null, null);
            field.addProp("columnName", columnName);
            field.addProp("sqlType", Integer.toString(sqlType));
            fields.add(field);
        }
        String avroTableName = this.tableName == null ? "QueryResult" : this.tableName;
        String doc = "Sqoop import of " + avroTableName;
        Schema schema = Schema.createRecord((String)avroTableName, (String)doc, null, (boolean)false);
        schema.setFields(fields);
        schema.addProp("tableName", avroTableName);
        return schema;
    }

    private Schema.Type toAvroType(int sqlType) {
        switch (sqlType) {
            case -6: 
            case 4: 
            case 5: {
                return Schema.Type.INT;
            }
            case -5: {
                return Schema.Type.LONG;
            }
            case -7: 
            case 16: {
                return Schema.Type.BOOLEAN;
            }
            case 7: {
                return Schema.Type.FLOAT;
            }
            case 6: 
            case 8: {
                return Schema.Type.DOUBLE;
            }
            case 2: 
            case 3: {
                return Schema.Type.STRING;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return Schema.Type.STRING;
            }
            case 91: 
            case 92: 
            case 93: {
                return Schema.Type.LONG;
            }
            case -3: 
            case -2: {
                return Schema.Type.BYTES;
            }
        }
        throw new IllegalArgumentException("Cannot convert SQL type " + sqlType);
    }

    private Schema.Type toAvroType(String type) {
        if (type.equalsIgnoreCase("INTEGER")) {
            return Schema.Type.INT;
        }
        if (type.equalsIgnoreCase("LONG")) {
            return Schema.Type.LONG;
        }
        if (type.equalsIgnoreCase("BOOLEAN")) {
            return Schema.Type.BOOLEAN;
        }
        if (type.equalsIgnoreCase("FLOAT")) {
            return Schema.Type.FLOAT;
        }
        if (type.equalsIgnoreCase("DOUBLE")) {
            return Schema.Type.DOUBLE;
        }
        if (type.equalsIgnoreCase("STRING")) {
            return Schema.Type.STRING;
        }
        if (type.equalsIgnoreCase("BYTES")) {
            return Schema.Type.BYTES;
        }
        throw new IllegalArgumentException("Cannot convert to AVRO type " + type);
    }

    public Schema toAvroSchema(int sqlType, String columnName) {
        Properties mappingJava = this.options.getMapColumnJava();
        Schema.Type targetType = columnName != null && mappingJava.containsKey(columnName) ? this.toAvroType((String)mappingJava.get(columnName)) : this.toAvroType(sqlType);
        ArrayList<Schema> childSchemas = new ArrayList<Schema>();
        childSchemas.add(Schema.create((Schema.Type)targetType));
        childSchemas.add(Schema.create((Schema.Type)Schema.Type.NULL));
        return Schema.createUnion(childSchemas);
    }

    public Schema toAvroSchema(int sqlType) {
        return this.toAvroSchema(sqlType, null);
    }
}

