/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi;

import java.io.Serializable;
import java.util.SortedSet;
import mondrian.olap.Util;
import mondrian.util.ArraySortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentColumn
implements Serializable {
    private static final long serialVersionUID = -5227838916517784720L;
    public final String columnExpression;
    public final int valueCount;
    public final SortedSet<Comparable> values;
    private final int hashCode;

    public SegmentColumn(String columnExpression, int valueCount, SortedSet<Comparable> valueList) {
        this.columnExpression = columnExpression;
        this.valueCount = valueCount;
        this.values = valueList;
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        return Util.hash(this.columnExpression.hashCode(), this.values);
    }

    public SegmentColumn merge(SegmentColumn col) {
        assert (col != null);
        assert (col.columnExpression.equals(this.columnExpression));
        if (this.values == null || col.values == null) {
            return new SegmentColumn(this.columnExpression, this.valueCount, null);
        }
        return new SegmentColumn(this.columnExpression, this.valueCount, ((ArraySortedSet)this.values).merge((ArraySortedSet)col.values));
    }

    public String getColumnExpression() {
        return this.columnExpression;
    }

    public SortedSet<Comparable> getValues() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SegmentColumn)) {
            return false;
        }
        SegmentColumn that = (SegmentColumn)obj;
        if (this.values == null && that.values == null) {
            return true;
        }
        return this.columnExpression.equals(that.columnExpression) && Util.equals(this.values, that.values);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int getValueCount() {
        return this.valueCount;
    }
}

