/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.ReversedScannerCallable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ReversedClientScanner
extends ClientScanner {
    private static final Log LOG = LogFactory.getLog(ReversedClientScanner.class);
    static byte[] MAX_BYTE_ARRAY = Bytes.createMaxByteArray((int)9);

    public ReversedClientScanner(Configuration conf, Scan scan, TableName tableName, HConnection connection) throws IOException {
        super(conf, scan, tableName, connection);
    }

    @Override
    protected boolean nextScanner(int nbRows, boolean done) throws IOException {
        byte[] localStartKey;
        if (this.callable != null) {
            this.callable.setClose();
            this.caller.callWithRetries(this.callable);
            this.callable = null;
        }
        boolean locateTheClosestFrontRow = true;
        if (this.currentRegion != null) {
            byte[] startKey = this.currentRegion.getStartKey();
            if (startKey == null || Bytes.equals((byte[])startKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(startKey) || done) {
                this.close();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Finished " + this.currentRegion));
                }
                return false;
            }
            localStartKey = startKey;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Finished " + this.currentRegion));
            }
        } else {
            localStartKey = this.scan.getStartRow();
            if (!Bytes.equals((byte[])localStartKey, (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
                locateTheClosestFrontRow = false;
            }
        }
        if (LOG.isDebugEnabled() && this.currentRegion != null) {
            LOG.debug((Object)("Advancing internal scanner to startKey at '" + Bytes.toStringBinary((byte[])localStartKey) + "'"));
        }
        try {
            byte[] locateStartRow = locateTheClosestFrontRow ? this.createClosestRowBefore(localStartKey) : null;
            this.callable = this.getScannerCallable(localStartKey, nbRows, locateStartRow);
            this.caller.callWithRetries(this.callable);
            this.currentRegion = this.callable.getHRegionInfo();
            if (this.scanMetrics != null) {
                this.scanMetrics.countOfRegions.incrementAndGet();
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        return true;
    }

    protected ScannerCallable getScannerCallable(byte[] localStartKey, int nbRows, byte[] locateStartRow) {
        this.scan.setStartRow(localStartKey);
        ReversedScannerCallable s = new ReversedScannerCallable(this.getConnection(), this.getTable(), this.scan, this.scanMetrics, locateStartRow);
        s.setCaching(nbRows);
        return s;
    }

    @Override
    protected boolean checkScanStopRow(byte[] startKey) {
        byte[] stopRow;
        int cmp;
        return this.scan.getStopRow().length > 0 && (cmp = Bytes.compareTo((byte[])(stopRow = this.scan.getStopRow()), (int)0, (int)stopRow.length, (byte[])startKey, (int)0, (int)startKey.length)) >= 0;
    }

    private byte[] createClosestRowBefore(byte[] row) {
        if (row == null) {
            throw new IllegalArgumentException("The passed row is empty");
        }
        if (Bytes.equals((byte[])row, (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
            return MAX_BYTE_ARRAY;
        }
        if (row[row.length - 1] == 0) {
            return Arrays.copyOf(row, row.length - 1);
        }
        byte[] closestFrontRow = Arrays.copyOf(row, row.length);
        closestFrontRow[row.length - 1] = (byte)((closestFrontRow[row.length - 1] & 0xFF) - 1);
        closestFrontRow = Bytes.add((byte[])closestFrontRow, (byte[])MAX_BYTE_ARRAY);
        return closestFrontRow;
    }
}

