/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MemberDeclaration;
import net.hydromatic.linq4j.expressions.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDeclaration
extends MemberDeclaration {
    public final int modifier;
    public final String classClass = "class";
    public final String name;
    public final List<MemberDeclaration> memberDeclarations;
    private final Type extended;
    private final List<Type> implemented;

    public ClassDeclaration(int modifier, String name, Type extended, List<Type> implemented, List<MemberDeclaration> memberDeclarations) {
        this.modifier = modifier;
        this.name = name;
        this.memberDeclarations = memberDeclarations;
        this.extended = extended;
        this.implemented = implemented;
    }

    @Override
    public void accept(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifier);
        writer.append(modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(' ');
        }
        writer.append("class").append(' ').append(this.name);
        if (this.extended != null) {
            writer.append(" extends ").append(this.extended);
        }
        if (!this.implemented.isEmpty()) {
            writer.list(" implements ", ", ", "", this.implemented);
        }
        writer.list(" {\n", "", "}", this.memberDeclarations);
        writer.newlineAndIndent();
    }

    @Override
    public ClassDeclaration accept(Visitor visitor) {
        List<MemberDeclaration> members1 = Expressions.acceptMemberDeclarations(this.memberDeclarations, visitor);
        return visitor.visit(this, members1);
    }
}

