/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Modifier;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.MemberDeclaration;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Visitor;

public class FieldDeclaration
extends MemberDeclaration {
    public final int modifier;
    public final ParameterExpression parameter;
    public final Expression initializer;

    public FieldDeclaration(int modifier, ParameterExpression parameter, Expression initializer) {
        this.modifier = modifier;
        this.parameter = parameter;
        this.initializer = initializer;
    }

    public MemberDeclaration accept(Visitor visitor) {
        Expression initializer = this.initializer == null ? null : this.initializer.accept(visitor);
        return visitor.visit(this, this.parameter, initializer);
    }

    public void accept(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifier);
        writer.append(modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(' ');
        }
        writer.append(this.parameter.type).append(' ').append(this.parameter.name);
        if (this.initializer != null) {
            writer.append(" = ").append(this.initializer);
        }
        writer.append(';');
        writer.newlineAndIndent();
    }
}

