/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.util.List;
import net.hydromatic.linq4j.expressions.Blocks;
import net.hydromatic.linq4j.expressions.CatchBlock;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TryStatement
extends Statement {
    public final Statement body;
    public final List<CatchBlock> catchBlocks;
    public final Statement finally_;

    public TryStatement(Statement body, List<CatchBlock> catchBlocks, Statement finally_) {
        super(ExpressionType.Try, body.getType());
        this.body = body;
        this.catchBlocks = catchBlocks;
        this.finally_ = finally_;
    }

    @Override
    public Statement accept(Visitor visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        writer.append("try ").append(Blocks.toBlock(this.body));
        for (CatchBlock catchBlock : this.catchBlocks) {
            writer.backUp();
            writer.append(" catch (").append(catchBlock.parameter.declString()).append(") ").append(Blocks.toBlock(catchBlock.body));
        }
        if (this.finally_ != null) {
            writer.backUp();
            writer.append(" finally ").append(Blocks.toBlock(this.finally_));
        }
    }
}

