/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.util.List;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.expressions.BinaryExpression;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.ClassDeclaration;
import net.hydromatic.linq4j.expressions.ConstantExpression;
import net.hydromatic.linq4j.expressions.ConstructorDeclaration;
import net.hydromatic.linq4j.expressions.DeclarationStatement;
import net.hydromatic.linq4j.expressions.DefaultExpression;
import net.hydromatic.linq4j.expressions.DynamicExpression;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.FieldDeclaration;
import net.hydromatic.linq4j.expressions.ForStatement;
import net.hydromatic.linq4j.expressions.FunctionExpression;
import net.hydromatic.linq4j.expressions.GotoStatement;
import net.hydromatic.linq4j.expressions.IndexExpression;
import net.hydromatic.linq4j.expressions.InvocationExpression;
import net.hydromatic.linq4j.expressions.LabelStatement;
import net.hydromatic.linq4j.expressions.LambdaExpression;
import net.hydromatic.linq4j.expressions.ListInitExpression;
import net.hydromatic.linq4j.expressions.MemberDeclaration;
import net.hydromatic.linq4j.expressions.MemberExpression;
import net.hydromatic.linq4j.expressions.MemberInitExpression;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.MethodDeclaration;
import net.hydromatic.linq4j.expressions.NewArrayExpression;
import net.hydromatic.linq4j.expressions.NewExpression;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.SwitchStatement;
import net.hydromatic.linq4j.expressions.TernaryExpression;
import net.hydromatic.linq4j.expressions.ThrowStatement;
import net.hydromatic.linq4j.expressions.TryStatement;
import net.hydromatic.linq4j.expressions.TypeBinaryExpression;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.UnaryExpression;
import net.hydromatic.linq4j.expressions.WhileStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Visitor {
    public Statement visit(WhileStatement whileStatement, Expression condition, Statement body) {
        return condition == whileStatement.condition && body == whileStatement.body ? whileStatement : Expressions.while_(condition, body);
    }

    public BlockStatement visit(BlockStatement blockStatement, List<Statement> statements) {
        return statements.equals(blockStatement.statements) ? blockStatement : Expressions.block(statements);
    }

    public Statement visit(GotoStatement gotoStatement, Expression expression) {
        return expression == gotoStatement.expression ? gotoStatement : Expressions.makeGoto(gotoStatement.kind, gotoStatement.labelTarget, expression);
    }

    public LabelStatement visit(LabelStatement labelStatement) {
        return labelStatement;
    }

    public ForStatement visit(ForStatement forStatement, List<DeclarationStatement> declarations, Expression condition, Expression post, Statement body) {
        return forStatement;
    }

    public Statement visit(ThrowStatement throwStatement) {
        return throwStatement;
    }

    public DeclarationStatement visit(DeclarationStatement declarationStatement, ParameterExpression parameter, Expression initializer) {
        return declarationStatement.parameter == parameter && declarationStatement.initializer == initializer ? declarationStatement : Expressions.declare(declarationStatement.modifiers, parameter, initializer);
    }

    public Expression visit(LambdaExpression lambdaExpression) {
        return lambdaExpression;
    }

    public Expression visit(FunctionExpression functionExpression, BlockStatement body, List<ParameterExpression> parameterList) {
        return functionExpression.body.equals(body) && functionExpression.parameterList.equals(parameterList) ? functionExpression : Expressions.lambda(body, parameterList);
    }

    public Expression visit(BinaryExpression binaryExpression, Expression expression0, Expression expression1) {
        return binaryExpression.expression0 == expression0 && binaryExpression.expression1 == expression1 ? binaryExpression : Expressions.makeBinary(binaryExpression.nodeType, expression0, expression1);
    }

    public Expression visit(TernaryExpression ternaryExpression, Expression expression0, Expression expression1, Expression expression2) {
        return ternaryExpression.expression0 == expression0 && ternaryExpression.expression1 == expression1 && ternaryExpression.expression2 == expression2 ? ternaryExpression : Expressions.makeTernary(ternaryExpression.nodeType, expression0, expression1, expression2);
    }

    public Expression visit(IndexExpression indexExpression, Expression array, List<Expression> indexExpressions) {
        return indexExpression.array == array && indexExpression.indexExpressions.equals(indexExpressions) ? indexExpression : new IndexExpression(array, indexExpressions);
    }

    public Expression visit(UnaryExpression unaryExpression, Expression expression) {
        return unaryExpression.expression == expression ? unaryExpression : Expressions.makeUnary(unaryExpression.nodeType, expression, unaryExpression.type, null);
    }

    public Expression visit(MethodCallExpression methodCallExpression, Expression targetExpression, List<Expression> expressions) {
        return methodCallExpression.targetExpression == targetExpression && methodCallExpression.expressions.equals(expressions) ? methodCallExpression : Expressions.call(targetExpression, methodCallExpression.method, expressions);
    }

    public Expression visit(DefaultExpression defaultExpression) {
        return defaultExpression;
    }

    public Expression visit(DynamicExpression dynamicExpression) {
        return dynamicExpression;
    }

    public Expression visit(MemberExpression memberExpression, Expression expression) {
        return memberExpression.expression == expression ? memberExpression : Expressions.field(expression, memberExpression.field);
    }

    public Expression visit(InvocationExpression invocationExpression) {
        return invocationExpression;
    }

    static <T> boolean eq(T t0, T t1) {
        return t0 == t1 || t0 != null && t1 != null && t0.equals(t1);
    }

    public Expression visit(NewArrayExpression newArrayExpression, int dimension, Expression bound, List<Expression> expressions) {
        return Visitor.eq(expressions, newArrayExpression.expressions) && Visitor.eq(bound, newArrayExpression.bound) ? newArrayExpression : (expressions == null ? Expressions.newArrayBounds(Types.getComponentTypeN(newArrayExpression.type), dimension, bound) : Expressions.newArrayInit(Types.getComponentTypeN(newArrayExpression.type), dimension, expressions));
    }

    public Expression visit(ListInitExpression listInitExpression) {
        return listInitExpression;
    }

    public Expression visit(NewExpression newExpression, List<Expression> arguments, List<MemberDeclaration> memberDeclarations) {
        return arguments.equals(newExpression.arguments) && Linq4j.equals(memberDeclarations, newExpression.memberDeclarations) ? newExpression : Expressions.new_(newExpression.type, arguments, memberDeclarations);
    }

    public Statement visit(SwitchStatement switchStatement) {
        return switchStatement;
    }

    public Statement visit(TryStatement tryStatement) {
        return tryStatement;
    }

    public Expression visit(MemberInitExpression memberInitExpression) {
        return memberInitExpression;
    }

    public Expression visit(TypeBinaryExpression typeBinaryExpression, Expression expression) {
        return typeBinaryExpression;
    }

    public MemberDeclaration visit(MethodDeclaration methodDeclaration, List<ParameterExpression> parameters, BlockStatement body) {
        return parameters.equals(methodDeclaration.parameters) && body.equals(methodDeclaration.body) ? methodDeclaration : Expressions.methodDecl(methodDeclaration.modifier, methodDeclaration.resultType, methodDeclaration.name, parameters, body);
    }

    public MemberDeclaration visit(FieldDeclaration fieldDeclaration, ParameterExpression parameter, Expression initializer) {
        return parameter.equals(fieldDeclaration.parameter) && Visitor.eq(initializer, fieldDeclaration.initializer) ? fieldDeclaration : Expressions.fieldDecl(fieldDeclaration.modifier, parameter, initializer);
    }

    public Expression visit(ParameterExpression parameterExpression) {
        return parameterExpression;
    }

    public ConstantExpression visit(ConstantExpression constantExpression) {
        return constantExpression;
    }

    public ClassDeclaration visit(ClassDeclaration classDeclaration, List<MemberDeclaration> memberDeclarations) {
        return classDeclaration;
    }

    public MemberDeclaration visit(ConstructorDeclaration constructorDeclaration, List<ParameterExpression> parameters, BlockStatement body) {
        return constructorDeclaration;
    }
}

