/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.control.ControlNodeActionExecutor;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.command.wf.NotificationXCommand;
import org.apache.oozie.executor.jpa.BulkUpdateInsertJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.db.SLADbXOperations;

public class ActionKillXCommand
extends ActionXCommand<Void> {
    private String actionId;
    private String jobId;
    private WorkflowJobBean wfJob;
    private WorkflowActionBean wfAction;
    private JPAService jpaService = null;
    private List<JsonBean> updateList = new ArrayList<JsonBean>();
    private List<JsonBean> insertList = new ArrayList<JsonBean>();

    public ActionKillXCommand(String actionId, String type) {
        super("action.kill", type, 0);
        this.actionId = actionId;
        this.jobId = Services.get().get(UUIDService.class).getId(actionId);
    }

    public ActionKillXCommand(String actionId) {
        this(actionId, "action.kill");
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.wfJob = this.jpaService.execute(new WorkflowJobGetJPAExecutor(this.jobId));
            this.wfAction = this.jpaService.execute(new WorkflowActionGetJPAExecutor(this.actionId));
            LogUtils.setLogInfo(this.wfJob, this.logInfo);
            LogUtils.setLogInfo(this.wfAction, this.logInfo);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.wfAction.getStatus() != WorkflowAction.Status.KILLED) {
            throw new PreconditionException(ErrorCode.E0726, this.wfAction.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute() throws CommandException {
        ActionExecutor executor;
        this.LOG.debug("STARTED WorkflowActionKillXCommand for action " + this.actionId);
        if (this.wfAction.isPending() && (executor = Services.get().get(ActionService.class).getExecutor(this.wfAction.getType())) != null) {
            try {
                boolean isRetry = false;
                boolean isUserRetry = false;
                ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(this.wfJob, this.wfAction, isRetry, isUserRetry);
                this.incrActionCounter(this.wfAction.getType(), 1);
                Instrumentation.Cron cron = new Instrumentation.Cron();
                cron.start();
                executor.kill(context, this.wfAction);
                cron.stop();
                this.addActionCron(this.wfAction.getType(), cron);
                this.wfAction.resetPending();
                this.wfAction.setStatus(WorkflowAction.Status.KILLED);
                this.wfAction.setEndTime(new Date());
                this.updateList.add(this.wfAction);
                this.wfJob.setLastModifiedTime(new Date());
                this.updateList.add(this.wfJob);
                SLAEventBean slaEvent = SLADbXOperations.createStatusEvent(this.wfAction.getSlaXml(), this.wfAction.getId(), SLAEvent.Status.KILLED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                if (slaEvent != null) {
                    this.insertList.add(slaEvent);
                }
                this.queue(new NotificationXCommand(this.wfJob, this.wfAction));
            }
            catch (ActionExecutorException ex) {
                this.wfAction.resetPending();
                this.wfAction.setStatus(WorkflowAction.Status.FAILED);
                this.wfAction.setErrorInfo(ex.getErrorCode().toString(), "KILL COMMAND FAILED - exception while executing job kill");
                this.wfAction.setEndTime(new Date());
                this.wfJob.setStatus(WorkflowJob.Status.KILLED);
                this.updateList.add(this.wfAction);
                this.wfJob.setLastModifiedTime(new Date());
                this.updateList.add(this.wfJob);
                SLAEventBean slaEvent = SLADbXOperations.createStatusEvent(this.wfAction.getSlaXml(), this.wfAction.getId(), SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                if (slaEvent != null) {
                    this.insertList.add(slaEvent);
                }
                this.LOG.warn("Exception while executing kill(). Error Code [{0}], Message[{1}]", ex.getErrorCode(), ex.getMessage(), ex);
            }
            finally {
                try {
                    this.jpaService.execute(new BulkUpdateInsertJPAExecutor(this.updateList, this.insertList));
                    if (!(executor instanceof ControlNodeActionExecutor) && EventHandlerService.isEnabled()) {
                        this.generateEvent(this.wfAction, this.wfJob.getUser());
                    }
                }
                catch (JPAExecutorException e) {
                    throw new CommandException(e);
                }
            }
        }
        this.LOG.debug("ENDED WorkflowActionKillXCommand for action " + this.actionId);
        return null;
    }
}

