/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.coord.SyncCoordAction;
import org.apache.oozie.coord.SyncCoordDataset;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.service.ELService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class CoordELEvaluator {
    public static final Integer MINUTE = 1;
    public static final Integer HOUR = 60 * MINUTE;

    public static ELEvaluator createELEvaluatorForGroup(Configuration conf, String group) {
        ELEvaluator eval = Services.get().get(ELService.class).createEvaluator(group);
        CoordELEvaluator.setConfigToEval(eval, conf);
        return eval;
    }

    public static ELEvaluator createInstancesELEvaluator(Element event, SyncCoordAction appInst, Configuration conf) throws Exception {
        return CoordELEvaluator.createInstancesELEvaluator("coord-action-create", event, appInst, conf);
    }

    public static ELEvaluator createInstancesELEvaluator(String tag, Element event, SyncCoordAction appInst, Configuration conf) throws Exception {
        ELEvaluator eval = Services.get().get(ELService.class).createEvaluator(tag);
        CoordELEvaluator.setConfigToEval(eval, conf);
        SyncCoordDataset ds = CoordELEvaluator.getDSObject(event);
        CoordELFunctions.configureEvaluator(eval, ds, appInst);
        return eval;
    }

    public static ELEvaluator createELEvaluatorForDataEcho(Configuration conf, String group, HashMap<String, String> dataNameList) throws Exception {
        ELEvaluator eval = CoordELEvaluator.createELEvaluatorForGroup(conf, group);
        for (String key : dataNameList.keySet()) {
            String value = dataNameList.get(key);
            eval.setVariable("oozie.dataname." + key, value);
        }
        return eval;
    }

    public static ELEvaluator createLazyEvaluator(Date actualTime, Date nominalTime, Element dEvent, Configuration conf) throws Exception {
        ELEvaluator eval = Services.get().get(ELService.class).createEvaluator("coord-action-start");
        CoordELEvaluator.setConfigToEval(eval, conf);
        SyncCoordDataset ds = CoordELEvaluator.getDSObject(dEvent);
        SyncCoordAction appInst = new SyncCoordAction();
        appInst.setNominalTime(nominalTime);
        appInst.setActualTime(actualTime);
        CoordELFunctions.configureEvaluator(eval, ds, appInst);
        eval.setVariable("oozie.coord.el.conf", conf);
        return eval;
    }

    public static ELEvaluator createSLAEvaluator(Date nominalTime, Configuration conf) throws Exception {
        ELEvaluator eval = Services.get().get(ELService.class).createEvaluator("coord-sla-create");
        CoordELEvaluator.setConfigToEval(eval, conf);
        SyncCoordAction appInst = new SyncCoordAction();
        appInst.setNominalTime(nominalTime);
        CoordELFunctions.configureEvaluator(eval, null, appInst);
        return eval;
    }

    public static ELEvaluator createDataEvaluator(Element eJob, Configuration conf, String actionId) throws Exception {
        String uris;
        String strActualTime;
        ELEvaluator e = Services.get().get(ELService.class).createEvaluator("coord-action-start");
        CoordELEvaluator.setConfigToEval(e, conf);
        SyncCoordAction appInst = new SyncCoordAction();
        String strNominalTime = eJob.getAttributeValue("action-nominal-time");
        if (strNominalTime != null) {
            appInst.setNominalTime(DateUtils.parseDateOozieTZ(strNominalTime));
            appInst.setTimeZone(DateUtils.getTimeZone(eJob.getAttributeValue("timezone")));
            appInst.setFrequency(Integer.parseInt(eJob.getAttributeValue("frequency")));
            appInst.setTimeUnit(TimeUnit.valueOf(eJob.getAttributeValue("freq_timeunit")));
            appInst.setActionId(actionId);
            appInst.setName(eJob.getAttributeValue("name"));
        }
        if ((strActualTime = eJob.getAttributeValue("action-actual-time")) != null) {
            appInst.setActualTime(DateUtils.parseDateOozieTZ(strActualTime));
        }
        CoordELFunctions.configureEvaluator(e, null, appInst);
        Element events = eJob.getChild("input-events", eJob.getNamespace());
        if (events != null) {
            for (Element data : events.getChildren("data-in", eJob.getNamespace())) {
                if (data.getChild("uris", data.getNamespace()) != null) {
                    uris = data.getChild("uris", data.getNamespace()).getTextTrim();
                    uris = uris.replaceAll("#", ",");
                    e.setVariable(".datain." + data.getAttributeValue("name"), uris);
                }
                if (data.getChild("unresolved-instances", data.getNamespace()) == null) continue;
                e.setVariable(".datain." + data.getAttributeValue("name") + ".unresolved", "true");
            }
        }
        if ((events = eJob.getChild("output-events", eJob.getNamespace())) != null) {
            for (Element data : events.getChildren("data-out", eJob.getNamespace())) {
                if (data.getChild("uris", data.getNamespace()) != null) {
                    uris = data.getChild("uris", data.getNamespace()).getTextTrim();
                    uris = uris.replaceAll("#", ",");
                    e.setVariable(".dataout." + data.getAttributeValue("name"), uris);
                }
                if (data.getChild("unresolved-instances", data.getNamespace()) == null) continue;
                e.setVariable(".dataout." + data.getAttributeValue("name") + ".unresolved", "true");
            }
        }
        return e;
    }

    public static ELEvaluator createURIELEvaluator(String strDate) throws Exception {
        ELEvaluator eval = new ELEvaluator();
        Calendar date = Calendar.getInstance(DateUtils.getOozieProcessingTimeZone());
        date.setTime(DateUtils.parseDateOozieTZ(strDate));
        eval.setVariable("YEAR", date.get(1));
        eval.setVariable("MONTH", CoordELEvaluator.make2Digits(date.get(2) + 1));
        eval.setVariable("DAY", CoordELEvaluator.make2Digits(date.get(5)));
        eval.setVariable("HOUR", CoordELEvaluator.make2Digits(date.get(11)));
        eval.setVariable("MINUTE", CoordELEvaluator.make2Digits(date.get(12)));
        return eval;
    }

    private static SyncCoordDataset getDSObject(Element eData) throws Exception {
        SyncCoordDataset ds = new SyncCoordDataset();
        Element eDataset = eData.getChild("dataset", eData.getNamespace());
        Date initInstance = DateUtils.parseDateOozieTZ(eDataset.getAttributeValue("initial-instance"));
        ds.setInitInstance(initInstance);
        if (eDataset.getAttributeValue("frequency") != null) {
            int frequency = Integer.parseInt(eDataset.getAttributeValue("frequency"));
            ds.setFrequency(frequency);
            ds.setType("SYNC");
            if (eDataset.getAttributeValue("freq_timeunit") == null) {
                throw new RuntimeException("No freq_timeunit defined in data set definition\n" + XmlUtils.prettyPrint(eDataset));
            }
            ds.setTimeUnit(TimeUnit.valueOf(eDataset.getAttributeValue("freq_timeunit")));
            if (eDataset.getAttributeValue("timezone") == null) {
                throw new RuntimeException("No timezone defined in data set definition\n" + XmlUtils.prettyPrint(eDataset));
            }
            ds.setTimeZone(DateUtils.getTimeZone(eDataset.getAttributeValue("timezone")));
            if (eDataset.getAttributeValue("end_of_duration") == null) {
                throw new RuntimeException("No end_of_duration defined in data set definition\n" + XmlUtils.prettyPrint(eDataset));
            }
            ds.setEndOfDuration(TimeUnit.valueOf(eDataset.getAttributeValue("end_of_duration")));
            Element doneFlagElement = eDataset.getChild("done-flag", eData.getNamespace());
            String doneFlag = CoordUtils.getDoneFlag(doneFlagElement);
            ds.setDoneFlag(doneFlag);
        } else {
            ds.setType("ASYNC");
        }
        String name = eDataset.getAttributeValue("name");
        ds.setName(name);
        String uriTemplate = eDataset.getChild("uri-template", eData.getNamespace()).getTextTrim();
        ds.setUriTemplate(uriTemplate);
        return ds;
    }

    private static void setConfigToEval(ELEvaluator eval, Configuration conf) {
        for (Map.Entry entry : conf) {
            eval.setVariable((String)entry.getKey(), ((String)entry.getValue()).trim());
        }
    }

    private static String make2Digits(int num) {
        String ret = "" + num;
        if (num <= 9) {
            ret = "0" + ret;
        }
        return ret;
    }
}

