/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.event;

import java.util.Date;
import org.apache.oozie.AppType;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.util.XLog;

public class CoordinatorActionEvent
extends JobEvent {
    private CoordinatorAction.Status status;
    private Date nominalTime;
    private String missingDeps;
    private String errorCode;
    private String errorMessage;

    public CoordinatorActionEvent(String id, String parentId, CoordinatorAction.Status status, String user, String appName, Date nomTime, Date startTime, String missDeps) {
        super(id, parentId, user, AppType.COORDINATOR_ACTION, appName);
        this.setStatus(status);
        this.setNominalTime(nomTime);
        this.setStartTime(startTime);
        this.setMissingDeps(missDeps);
        XLog.getLog(EventHandlerService.class).trace("Event generated - " + this.toString());
    }

    public String getBundleJobId() {
        return null;
    }

    public CoordinatorAction.Status getStatus() {
        return this.status;
    }

    public void setStatus(CoordinatorAction.Status castatus) {
        this.status = castatus;
        switch (this.status) {
            case WAITING: {
                this.setEventStatus(JobEvent.EventStatus.WAITING);
                break;
            }
            case SUCCEEDED: {
                this.setEventStatus(JobEvent.EventStatus.SUCCESS);
                this.setEndTime(new Date());
                break;
            }
            case RUNNING: {
                this.setEventStatus(JobEvent.EventStatus.STARTED);
                break;
            }
            case SUSPENDED: {
                this.setEventStatus(JobEvent.EventStatus.SUSPEND);
                break;
            }
            case KILLED: 
            case FAILED: 
            case TIMEDOUT: {
                this.setEventStatus(JobEvent.EventStatus.FAILURE);
                this.setEndTime(new Date());
            }
        }
    }

    public Date getNominalTime() {
        return this.nominalTime;
    }

    public void setNominalTime(Date time) {
        this.nominalTime = time;
    }

    public String getMissingDeps() {
        return this.missingDeps;
    }

    public void setMissingDeps(String dependencies) {
        this.missingDeps = dependencies;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String code) {
        this.errorCode = code;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }
}

