/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa.sla;

import java.util.Collection;
import javax.persistence.EntityManager;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class SLACalculationInsertUpdateJPAExecutor
implements JPAExecutor<String> {
    private Collection<JsonBean> insertList;
    private Collection<JsonBean> updateList;

    public SLACalculationInsertUpdateJPAExecutor(Collection<JsonBean> insertList, Collection<JsonBean> updateList) {
        this.setInsertList(insertList);
        this.setUpdateList(updateList);
    }

    public SLACalculationInsertUpdateJPAExecutor() {
    }

    public void setInsertList(Collection<JsonBean> insertList) {
        this.insertList = insertList;
    }

    public void setUpdateList(Collection<JsonBean> updateList) {
        this.updateList = updateList;
    }

    @Override
    public String getName() {
        return "SLACalculationInsertUpdateJPAExecutor";
    }

    @Override
    public String execute(EntityManager em) throws JPAExecutorException {
        try {
            if (this.insertList != null) {
                for (JsonBean entity : this.insertList) {
                    ParamChecker.notNull(entity, "JsonBean");
                    em.persist((Object)entity);
                }
            }
            FaultInjection.activate("org.apache.oozie.command.SkipCommitFaultInjection");
            if (this.updateList != null) {
                for (JsonBean entity : this.updateList) {
                    ParamChecker.notNull(entity, "JsonBean");
                    em.merge((Object)entity);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }
}

