/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.bundle.BundleKillXCommand;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.executor.jpa.BundleActionsGetByLastModifiedTimeJPAExecutor;
import org.apache.oozie.executor.jpa.BundleActionsGetStatusPendingJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobsGetRunningOrPendingJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionsGetByLastModifiedTimeJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionsStatusJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetPendingActionsCountJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsGetPendingJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.MemoryLocks;
import org.apache.oozie.util.StatusUtils;
import org.apache.oozie.util.XLog;

public class StatusTransitService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.StatusTransitService.";
    public static final String CONF_STATUSTRANSIT_INTERVAL = "oozie.service.StatusTransitService.statusTransit.interval";
    public static final String CONF_BACKWARD_SUPPORT_FOR_COORD_STATUS = "oozie.service.StatusTransitService.backward.support.for.coord.status";
    public static final String CONF_BACKWARD_SUPPORT_FOR_STATES_WITHOUT_ERROR = "oozie.service.StatusTransitService.backward.support.for.states.without.error";
    private static int limit = -1;
    private static Date lastInstanceStartTime = null;
    private static final XLog LOG = XLog.getLog(StatusTransitRunnable.class);

    @Override
    public void init(Services services) {
        Configuration conf = services.getConf();
        StatusTransitRunnable stateTransitRunnable = new StatusTransitRunnable();
        services.get(SchedulerService.class).schedule(stateTransitRunnable, 10L, (long)conf.getInt(CONF_STATUSTRANSIT_INTERVAL, 60), SchedulerService.Unit.SEC);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return StatusTransitService.class;
    }

    public static class StatusTransitRunnable
    implements Runnable {
        private JPAService jpaService = Services.get().get(JPAService.class);
        private MemoryLocks.LockToken lock;

        public StatusTransitRunnable() {
            if (this.jpaService == null) {
                LOG.error("Missing JPAService");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                try {
                    Date curDate = new Date();
                    this.lock = Services.get().get(MemoryLocksService.class).getWriteLock(StatusTransitService.class.getName(), Service.lockTimeout);
                    if (this.lock == null) {
                        LOG.info("This StatusTransitService instance will not run since there is already an instance running");
                    } else {
                        LOG.info("Acquired lock for [{0}]", StatusTransitService.class.getName());
                        this.coordTransit();
                        this.bundleTransit();
                        lastInstanceStartTime = curDate;
                    }
                    if (this.lock == null) break block7;
                    this.lock.release();
                }
                catch (Exception ex) {
                    try {
                        LOG.warn((Object)"Exception happened during StatusTransitRunnable ", ex);
                        if (this.lock == null) break block7;
                        this.lock.release();
                    }
                    catch (Throwable throwable) {
                        if (this.lock != null) {
                            this.lock.release();
                            LOG.info("Released lock for [{0}]", StatusTransitService.class.getName());
                        }
                        throw throwable;
                    }
                    LOG.info("Released lock for [{0}]", StatusTransitService.class.getName());
                }
                LOG.info("Released lock for [{0}]", StatusTransitService.class.getName());
            }
        }

        public List<BundleJobBean> removeDuplicates(List<BundleJobBean> pendingJobList) {
            TreeSet<BundleJobBean> s = new TreeSet<BundleJobBean>(new Comparator<BundleJobBean>(){

                @Override
                public int compare(BundleJobBean b1, BundleJobBean b2) {
                    if (b1.getId().equals(b2.getId())) {
                        return 0;
                    }
                    return 1;
                }
            });
            s.addAll(pendingJobList);
            return new ArrayList<BundleJobBean>(s);
        }

        private void bundleTransit() throws JPAExecutorException, CommandException {
            List<BundleJobBean> pendingJobCheckList = null;
            if (lastInstanceStartTime == null) {
                LOG.info("Running bundle status service first instance");
                pendingJobCheckList = this.jpaService.execute(new BundleJobsGetRunningOrPendingJPAExecutor(limit));
            } else {
                LOG.info("Running bundle status service from last instance time =  " + DateUtils.formatDateOozieTZ(lastInstanceStartTime));
                List<BundleActionBean> actionList = this.jpaService.execute(new BundleActionsGetByLastModifiedTimeJPAExecutor(lastInstanceStartTime));
                HashSet<String> bundleIds = new HashSet<String>();
                for (BundleActionBean action : actionList) {
                    bundleIds.add(action.getBundleId());
                }
                pendingJobCheckList = new ArrayList<BundleJobBean>();
                for (String bundleId : bundleIds.toArray(new String[bundleIds.size()])) {
                    BundleJobBean bundle = this.jpaService.execute(new BundleJobGetJPAExecutor(bundleId));
                    if (!bundle.isPending() && !bundle.getStatus().equals((Object)Job.Status.RUNNING) && !bundle.getStatus().equals((Object)Job.Status.RUNNINGWITHERROR) && !bundle.getStatus().equals((Object)Job.Status.PAUSED) && !bundle.getStatus().equals((Object)Job.Status.PAUSEDWITHERROR)) continue;
                    pendingJobCheckList.add(bundle);
                }
            }
            this.aggregateBundleJobsStatus(pendingJobCheckList);
        }

        private void aggregateBundleJobsStatus(List<BundleJobBean> bundleLists) throws JPAExecutorException, CommandException {
            if (bundleLists != null) {
                for (BundleJobBean bundleJob : bundleLists) {
                    try {
                        String jobId = bundleJob.getId();
                        Job.Status[] bundleStatus = new Job.Status[]{bundleJob.getStatus()};
                        List<BundleActionBean> bundleActions = this.jpaService.execute(new BundleActionsGetStatusPendingJPAExecutor(jobId));
                        HashMap<Job.Status, Integer> bundleActionStatus = new HashMap<Job.Status, Integer>();
                        boolean foundPending = false;
                        for (BundleActionBean bAction : bundleActions) {
                            int counter = 0;
                            counter = bundleActionStatus.containsKey(bAction.getStatus()) ? bundleActionStatus.get(bAction.getStatus()) + 1 : ++counter;
                            bundleActionStatus.put(bAction.getStatus(), counter);
                            if (bAction.getCoordId() == null && (bAction.getStatus() == Job.Status.FAILED || bAction.getStatus() == Job.Status.KILLED)) {
                                new BundleKillXCommand(jobId).call();
                                LOG.info("Bundle job [" + jobId + "] has been killed since one of its coordinator job failed submission.");
                            }
                            if (!bAction.isPending()) continue;
                            foundPending = true;
                        }
                        if (!foundPending && this.checkTerminalStatus(bundleActionStatus, bundleActions, bundleStatus)) {
                            LOG.info("Set bundle job [" + jobId + "] status to '" + bundleStatus[0].toString() + "' from '" + bundleJob.getStatus() + "'");
                            this.updateBundleJob(foundPending, bundleJob, bundleStatus[0]);
                            continue;
                        }
                        if (!foundPending && this.checkPrepStatus(bundleActionStatus, bundleActions, bundleStatus)) {
                            LOG.info("Set bundle job [" + jobId + "] status to '" + bundleStatus[0].toString() + "' from '" + bundleJob.getStatus() + "'");
                            this.updateBundleJob(foundPending, bundleJob, bundleStatus[0]);
                            continue;
                        }
                        if (this.checkPausedStatus(bundleActionStatus, bundleActions, bundleStatus)) {
                            LOG.info("Set bundle job [" + jobId + "] status to '" + bundleStatus[0].toString() + "' from '" + bundleJob.getStatus() + "'");
                            this.updateBundleJob(foundPending, bundleJob, bundleStatus[0]);
                            continue;
                        }
                        if (this.checkSuspendStatus(bundleActionStatus, bundleActions, bundleStatus, foundPending)) {
                            LOG.info("Set bundle job [" + jobId + "] status to '" + bundleStatus[0].toString() + "' from '" + bundleJob.getStatus() + "'");
                            this.updateBundleJob(foundPending, bundleJob, bundleStatus[0]);
                            continue;
                        }
                        if (!this.checkRunningStatus(bundleActionStatus, bundleActions, bundleStatus)) continue;
                        LOG.info("Set bundle job [" + jobId + "] status to '" + bundleStatus[0].toString() + "' from '" + bundleJob.getStatus() + "'");
                        this.updateBundleJob(foundPending, bundleJob, bundleStatus[0]);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Exception happened during aggregate bundle job's status, job = " + bundleJob.getId()), ex);
                    }
                }
            }
        }

        private void aggregateCoordJobsStatus(List<CoordinatorJobBean> CoordList) throws JPAExecutorException, CommandException {
            if (CoordList != null) {
                Configuration conf = Services.get().getConf();
                boolean backwardSupportForCoordStatus = conf.getBoolean(StatusTransitService.CONF_BACKWARD_SUPPORT_FOR_COORD_STATUS, false);
                for (CoordinatorJobBean coordJob : CoordList) {
                    try {
                        if (backwardSupportForCoordStatus && coordJob.getAppNamespace() != null && coordJob.getAppNamespace().equals("uri:oozie:coordinator:0.1")) continue;
                        String jobId = coordJob.getId();
                        Job.Status[] coordStatus = new Job.Status[]{coordJob.getStatus()};
                        boolean isPending = false;
                        int count = this.jpaService.execute(new CoordJobGetPendingActionsCountJPAExecutor(jobId));
                        if (count > 0) {
                            isPending = true;
                        }
                        List<CoordinatorAction.Status> coordActionStatusList = this.jpaService.execute(new CoordJobGetActionsStatusJPAExecutor(jobId));
                        HashMap<CoordinatorAction.Status, Integer> coordActionStatus = new HashMap<CoordinatorAction.Status, Integer>();
                        for (CoordinatorAction.Status status : coordActionStatusList) {
                            int counter = 0;
                            counter = coordActionStatus.containsKey(status) ? (Integer)coordActionStatus.get(status) + 1 : ++counter;
                            coordActionStatus.put(status, counter);
                        }
                        int nonPendingCoordActionsCount = coordActionStatusList.size();
                        boolean isDoneMaterialization = coordJob.isDoneMaterialization();
                        if ((isDoneMaterialization || coordStatus[0] == Job.Status.FAILED || coordStatus[0] == Job.Status.KILLED) && this.checkCoordTerminalStatus(coordActionStatus, nonPendingCoordActionsCount, coordStatus, isDoneMaterialization)) {
                            LOG.info("Set coordinator job [" + jobId + "] status to '" + coordStatus[0].toString() + "' from '" + coordJob.getStatus() + "'");
                            this.updateCoordJob(isPending, coordJob, coordStatus[0]);
                            continue;
                        }
                        if (this.checkCoordPausedStatus(coordActionStatus, nonPendingCoordActionsCount, coordStatus)) {
                            LOG.info("Set coordinator job [" + jobId + "] status to " + coordStatus[0].toString() + "' from '" + coordJob.getStatus() + "'");
                            this.updateCoordJob(isPending, coordJob, coordStatus[0]);
                            continue;
                        }
                        if (this.checkCoordSuspendStatus(coordActionStatus, nonPendingCoordActionsCount, coordStatus, coordJob.isDoneMaterialization(), isPending)) {
                            LOG.info("Set coordinator job [" + jobId + "] status to " + coordStatus[0].toString() + "' from '" + coordJob.getStatus() + "'");
                            this.updateCoordJob(isPending, coordJob, coordStatus[0]);
                            continue;
                        }
                        if (this.checkCoordRunningStatus(coordActionStatus, nonPendingCoordActionsCount, coordStatus)) {
                            LOG.info("Set coordinator job [" + jobId + "] status to " + coordStatus[0].toString() + "' from '" + coordJob.getStatus() + "'");
                            this.updateCoordJob(isPending, coordJob, coordStatus[0]);
                            continue;
                        }
                        this.checkCoordPending(isPending, coordJob, true);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Exception happened during aggregate coordinator job's status, job = " + coordJob.getId()), ex);
                    }
                }
            }
        }

        private boolean checkTerminalStatus(HashMap<Job.Status, Integer> bundleActionStatus, List<BundleActionBean> bundleActions, Job.Status[] bundleStatus) {
            boolean ret = false;
            int totalValuesSucceed = 0;
            if (bundleActionStatus.containsKey(Job.Status.SUCCEEDED)) {
                totalValuesSucceed = bundleActionStatus.get(Job.Status.SUCCEEDED);
            }
            int totalValuesFailed = 0;
            if (bundleActionStatus.containsKey(Job.Status.FAILED)) {
                totalValuesFailed = bundleActionStatus.get(Job.Status.FAILED);
            }
            int totalValuesKilled = 0;
            if (bundleActionStatus.containsKey(Job.Status.KILLED)) {
                totalValuesKilled = bundleActionStatus.get(Job.Status.KILLED);
            }
            int totalValuesDoneWithError = 0;
            if (bundleActionStatus.containsKey(Job.Status.DONEWITHERROR)) {
                totalValuesDoneWithError = bundleActionStatus.get(Job.Status.DONEWITHERROR);
            }
            if (bundleActions.size() == totalValuesSucceed + totalValuesFailed + totalValuesKilled + totalValuesDoneWithError) {
                if (bundleActions.size() == totalValuesSucceed) {
                    bundleStatus[0] = Job.Status.SUCCEEDED;
                    ret = true;
                } else if (bundleActions.size() == totalValuesKilled) {
                    bundleStatus[0] = Job.Status.KILLED;
                    ret = true;
                } else if (bundleActions.size() == totalValuesFailed) {
                    bundleStatus[0] = Job.Status.FAILED;
                    ret = true;
                } else {
                    bundleStatus[0] = Job.Status.DONEWITHERROR;
                    ret = true;
                }
            }
            return ret;
        }

        private boolean checkCoordTerminalStatus(HashMap<CoordinatorAction.Status, Integer> coordActionStatus, int coordActionsCount, Job.Status[] coordStatus, boolean isDoneMaterialization) {
            boolean ret = false;
            int totalValuesSucceed = 0;
            if (coordActionStatus.containsKey(CoordinatorAction.Status.SUCCEEDED)) {
                totalValuesSucceed = coordActionStatus.get(CoordinatorAction.Status.SUCCEEDED);
            }
            int totalValuesFailed = 0;
            if (coordActionStatus.containsKey(CoordinatorAction.Status.FAILED)) {
                totalValuesFailed = coordActionStatus.get(CoordinatorAction.Status.FAILED);
            }
            int totalValuesKilled = 0;
            if (coordActionStatus.containsKey(CoordinatorAction.Status.KILLED)) {
                totalValuesKilled = coordActionStatus.get(CoordinatorAction.Status.KILLED);
            }
            int totalValuesTimeOut = 0;
            if (coordActionStatus.containsKey(CoordinatorAction.Status.TIMEDOUT)) {
                totalValuesTimeOut = coordActionStatus.get(CoordinatorAction.Status.TIMEDOUT);
            }
            if (coordActionsCount == totalValuesSucceed + totalValuesFailed + totalValuesKilled + totalValuesTimeOut) {
                if (coordActionsCount == totalValuesSucceed && isDoneMaterialization) {
                    coordStatus[0] = Job.Status.SUCCEEDED;
                    ret = true;
                } else if (coordActionsCount == totalValuesKilled) {
                    coordStatus[0] = Job.Status.KILLED;
                    ret = true;
                } else if (coordActionsCount == totalValuesFailed) {
                    coordStatus[0] = Job.Status.FAILED;
                    ret = true;
                } else {
                    coordStatus[0] = Job.Status.DONEWITHERROR;
                    ret = true;
                }
            }
            return ret;
        }

        private boolean checkPrepStatus(HashMap<Job.Status, Integer> bundleActionStatus, List<BundleActionBean> bundleActions, Job.Status[] bundleStatus) {
            boolean ret = false;
            if (bundleActionStatus.containsKey(Job.Status.PREP) && bundleActions.size() > bundleActionStatus.get(Job.Status.PREP)) {
                bundleStatus[0] = Job.Status.RUNNING;
                ret = true;
            }
            return ret;
        }

        private boolean checkPausedStatus(HashMap<Job.Status, Integer> bundleActionStatus, List<BundleActionBean> bundleActions, Job.Status[] bundleJobStatus) {
            boolean ret = false;
            if (bundleJobStatus[0] == Job.Status.PAUSED || bundleJobStatus[0] == Job.Status.PAUSEDWITHERROR) {
                bundleJobStatus[0] = bundleActionStatus.containsKey(Job.Status.KILLED) || bundleActionStatus.containsKey(Job.Status.FAILED) || bundleActionStatus.containsKey(Job.Status.DONEWITHERROR) || bundleActionStatus.containsKey(Job.Status.SUSPENDEDWITHERROR) || bundleActionStatus.containsKey(Job.Status.RUNNINGWITHERROR) || bundleActionStatus.containsKey(Job.Status.PAUSEDWITHERROR) ? Job.Status.PAUSEDWITHERROR : Job.Status.PAUSED;
                ret = true;
            } else if (bundleActionStatus.containsKey(Job.Status.PAUSED) && bundleActions.size() == bundleActionStatus.get(Job.Status.PAUSED).intValue()) {
                bundleJobStatus[0] = Job.Status.PAUSED;
                ret = true;
            } else if (bundleActionStatus.containsKey(Job.Status.PAUSEDWITHERROR)) {
                int pausedActions;
                int n = pausedActions = bundleActionStatus.containsKey(Job.Status.PAUSED) ? bundleActionStatus.get(Job.Status.PAUSED) : 0;
                if (bundleActions.size() == pausedActions + bundleActionStatus.get(Job.Status.PAUSEDWITHERROR)) {
                    bundleJobStatus[0] = Job.Status.PAUSEDWITHERROR;
                    ret = true;
                }
            } else {
                ret = false;
            }
            return ret;
        }

        private boolean checkSuspendStatus(HashMap<Job.Status, Integer> bundleActionStatus, List<BundleActionBean> bundleActions, Job.Status[] bundleStatus, boolean isPending) {
            boolean ret = false;
            if (bundleStatus[0] == Job.Status.SUSPENDED || bundleStatus[0] == Job.Status.SUSPENDEDWITHERROR) {
                bundleStatus[0] = bundleActionStatus.containsKey(Job.Status.KILLED) || bundleActionStatus.containsKey(Job.Status.FAILED) || bundleActionStatus.containsKey(Job.Status.DONEWITHERROR) || bundleActionStatus.containsKey(Job.Status.SUSPENDEDWITHERROR) || bundleActionStatus.containsKey(Job.Status.PAUSEDWITHERROR) ? Job.Status.SUSPENDEDWITHERROR : Job.Status.SUSPENDED;
                ret = true;
            } else if (!isPending && bundleActionStatus.containsKey(Job.Status.SUSPENDED) || bundleActionStatus.containsKey(Job.Status.SUSPENDEDWITHERROR)) {
                int doneWithErrorActions;
                int succeededActions = bundleActionStatus.containsKey(Job.Status.SUCCEEDED) ? bundleActionStatus.get(Job.Status.SUCCEEDED) : 0;
                int killedActions = bundleActionStatus.containsKey(Job.Status.KILLED) ? bundleActionStatus.get(Job.Status.KILLED) : 0;
                int failedActions = bundleActionStatus.containsKey(Job.Status.FAILED) ? bundleActionStatus.get(Job.Status.FAILED) : 0;
                int n = doneWithErrorActions = bundleActionStatus.containsKey(Job.Status.DONEWITHERROR) ? bundleActionStatus.get(Job.Status.DONEWITHERROR) : 0;
                if (bundleActions.size() == bundleActionStatus.get(Job.Status.SUSPENDED) + succeededActions) {
                    bundleStatus[0] = Job.Status.SUSPENDED;
                    ret = true;
                } else if (bundleActions.size() == bundleActionStatus.get(Job.Status.SUSPENDEDWITHERROR) + bundleActionStatus.get(Job.Status.SUSPENDED) + succeededActions + killedActions + failedActions + doneWithErrorActions) {
                    bundleStatus[0] = Job.Status.SUSPENDEDWITHERROR;
                    ret = true;
                }
            }
            return ret;
        }

        private boolean checkCoordPausedStatus(HashMap<CoordinatorAction.Status, Integer> coordActionStatus, int coordActionsCount, Job.Status[] coordStatus) {
            boolean ret = false;
            if (coordStatus[0].equals((Object)Job.Status.PAUSED) || coordStatus[0].equals((Object)Job.Status.PAUSEDWITHERROR)) {
                coordStatus[0] = coordActionStatus.containsKey(CoordinatorAction.Status.KILLED) || coordActionStatus.containsKey(CoordinatorAction.Status.FAILED) || coordActionStatus.containsKey(CoordinatorAction.Status.TIMEDOUT) ? Job.Status.PAUSEDWITHERROR : Job.Status.PAUSED;
                ret = true;
            }
            return ret;
        }

        private boolean checkCoordSuspendStatus(HashMap<CoordinatorAction.Status, Integer> coordActionStatus, int coordActionsCount, Job.Status[] coordStatus, boolean isDoneMaterialization, boolean isPending) {
            boolean ret = false;
            if (coordStatus[0] == Job.Status.SUSPENDED || coordStatus[0] == Job.Status.SUSPENDEDWITHERROR) {
                coordStatus[0] = coordActionStatus.containsKey(CoordinatorAction.Status.KILLED) || coordActionStatus.containsKey(CoordinatorAction.Status.FAILED) || coordActionStatus.containsKey(CoordinatorAction.Status.TIMEDOUT) ? Job.Status.SUSPENDEDWITHERROR : Job.Status.SUSPENDED;
                ret = true;
            } else if (isDoneMaterialization && !isPending && coordActionStatus.containsKey(CoordinatorAction.Status.SUSPENDED)) {
                int timedoutActions;
                int succeededActions = coordActionStatus.containsKey(CoordinatorAction.Status.SUCCEEDED) ? coordActionStatus.get(CoordinatorAction.Status.SUCCEEDED) : 0;
                int killedActions = coordActionStatus.containsKey(CoordinatorAction.Status.KILLED) ? coordActionStatus.get(CoordinatorAction.Status.KILLED) : 0;
                int failedActions = coordActionStatus.containsKey(CoordinatorAction.Status.FAILED) ? coordActionStatus.get(CoordinatorAction.Status.FAILED) : 0;
                int n = timedoutActions = coordActionStatus.containsKey(CoordinatorAction.Status.TIMEDOUT) ? coordActionStatus.get(CoordinatorAction.Status.TIMEDOUT) : 0;
                if (coordActionsCount == coordActionStatus.get(CoordinatorAction.Status.SUSPENDED) + succeededActions) {
                    coordStatus[0] = Job.Status.SUSPENDED;
                    ret = true;
                } else if (coordActionsCount == coordActionStatus.get(CoordinatorAction.Status.SUSPENDED) + succeededActions + killedActions + failedActions + timedoutActions) {
                    coordStatus[0] = Job.Status.SUSPENDEDWITHERROR;
                    ret = true;
                }
            }
            return ret;
        }

        private boolean checkCoordRunningStatus(HashMap<CoordinatorAction.Status, Integer> coordActionStatus, int coordActionsCount, Job.Status[] coordStatus) {
            boolean ret = false;
            if (coordStatus[0] != Job.Status.PREP) {
                coordStatus[0] = coordActionStatus.containsKey(CoordinatorAction.Status.KILLED) || coordActionStatus.containsKey(CoordinatorAction.Status.FAILED) || coordActionStatus.containsKey(CoordinatorAction.Status.TIMEDOUT) ? Job.Status.RUNNINGWITHERROR : Job.Status.RUNNING;
                ret = true;
            }
            return ret;
        }

        private boolean checkRunningStatus(HashMap<Job.Status, Integer> bundleActionStatus, List<BundleActionBean> bundleActions, Job.Status[] bundleStatus) {
            boolean ret = false;
            if (bundleStatus[0] != Job.Status.PREP) {
                bundleStatus[0] = bundleActionStatus.containsKey(Job.Status.FAILED) || bundleActionStatus.containsKey(Job.Status.KILLED) || bundleActionStatus.containsKey(Job.Status.DONEWITHERROR) || bundleActionStatus.containsKey(Job.Status.RUNNINGWITHERROR) ? Job.Status.RUNNINGWITHERROR : Job.Status.RUNNING;
                ret = true;
            }
            return ret;
        }

        private void updateBundleJob(boolean isPending, BundleJobBean bundleJob, Job.Status bundleStatus) throws JPAExecutorException {
            String jobId = bundleJob.getId();
            bundleJob.setStatus(StatusUtils.getStatusIfBackwardSupportTrue(bundleStatus));
            if (isPending) {
                bundleJob.setPending();
                LOG.info("Bundle job [" + jobId + "] Pending set to TRUE");
            } else {
                bundleJob.resetPending();
                LOG.info("Bundle job [" + jobId + "] Pending set to FALSE");
            }
            this.jpaService.execute(new BundleJobUpdateJPAExecutor(bundleJob));
        }

        private void updateCoordJob(boolean isPending, CoordinatorJobBean coordJob, Job.Status coordStatus) throws JPAExecutorException, CommandException {
            Job.Status prevStatus = coordJob.getStatus();
            if (!(coordJob.getStatus() != Job.Status.SUCCEEDED && coordJob.getStatus() != Job.Status.FAILED && coordJob.getStatus() != Job.Status.KILLED && coordJob.getStatus() != Job.Status.DONEWITHERROR || coordStatus != Job.Status.SUSPENDED && coordStatus != Job.Status.SUSPENDEDWITHERROR)) {
                LOG.info("Coord Job [" + coordJob.getId() + "] status to " + coordStatus + " can not be updated as its already in Terminal state");
                return;
            }
            boolean isPendingStateChanged = this.checkCoordPending(isPending, coordJob, false);
            coordJob.setStatus(StatusUtils.getStatusIfBackwardSupportTrue(coordStatus));
            coordJob.setStatus(StatusUtils.getStatus(coordJob));
            if (coordJob.getStatus() != prevStatus || isPendingStateChanged) {
                LOG.debug("Updating coord job " + coordJob.getId());
                coordJob.setLastModifiedTime(new Date());
                this.jpaService.execute(new CoordJobUpdateJPAExecutor(coordJob));
            }
            if (coordJob.getBundleId() != null && !prevStatus.equals((Object)coordJob.getStatus())) {
                BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(coordJob, prevStatus);
                bundleStatusUpdate.call();
            }
        }

        private boolean checkCoordPending(boolean isPending, CoordinatorJobBean coordJob, boolean saveToDB) throws JPAExecutorException {
            boolean hasChange;
            boolean prevPending = coordJob.isPending();
            if (isPending) {
                coordJob.setPending();
                LOG.info("Coord job [" + coordJob.getId() + "] Pending set to TRUE");
            } else {
                coordJob.resetPending();
                LOG.info("Coord job [" + coordJob.getId() + "] Pending set to FALSE");
            }
            boolean bl = hasChange = prevPending != coordJob.isPending();
            if (saveToDB && hasChange) {
                this.jpaService.execute(new CoordJobUpdateJPAExecutor(coordJob));
            }
            return hasChange;
        }

        private void coordTransit() throws JPAExecutorException, CommandException {
            List<CoordinatorJobBean> pendingJobCheckList = null;
            if (lastInstanceStartTime == null) {
                LOG.info("Running coordinator status service first instance");
                pendingJobCheckList = this.jpaService.execute(new CoordJobsGetPendingJPAExecutor(limit));
            } else {
                LOG.info("Running coordinator status service from last instance time =  " + DateUtils.formatDateOozieTZ(lastInstanceStartTime));
                List<String> coordJobIdList = this.jpaService.execute(new CoordActionsGetByLastModifiedTimeJPAExecutor(lastInstanceStartTime));
                HashSet<String> coordIds = new HashSet<String>();
                for (String coordJobId : coordJobIdList) {
                    coordIds.add(coordJobId);
                }
                pendingJobCheckList = new ArrayList<CoordinatorJobBean>();
                for (String coordId : coordIds.toArray(new String[coordIds.size()])) {
                    CoordinatorJobBean coordJob;
                    try {
                        coordJob = this.jpaService.execute(new CoordJobGetJPAExecutor(coordId));
                    }
                    catch (JPAExecutorException jpaee) {
                        if (jpaee.getErrorCode().equals((Object)ErrorCode.E0604)) {
                            LOG.warn((Object)"Exception happened during StatusTransitRunnable; Coordinator Job doesn't exist", jpaee);
                            continue;
                        }
                        throw jpaee;
                    }
                    Job.Status coordJobStatus = coordJob.getStatus();
                    if (!coordJob.isPending() && !coordJobStatus.equals((Object)Job.Status.PAUSED) && !coordJobStatus.equals((Object)Job.Status.RUNNING) && !coordJobStatus.equals((Object)Job.Status.RUNNINGWITHERROR) && !coordJobStatus.equals((Object)Job.Status.PAUSEDWITHERROR)) continue;
                    pendingJobCheckList.add(coordJob);
                }
            }
            this.aggregateCoordJobsStatus(pendingJobCheckList);
        }
    }
}

