/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.concurrent.Semaphore;
import java.util.regex.Matcher;
import org.apache.log4j.Appender;
import org.apache.log4j.rolling.RollingPolicyBase;
import org.apache.log4j.rolling.RolloverDescription;
import org.apache.log4j.rolling.TimeBasedRollingPolicy;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.util.XLogStreamer;

public class OozieRollingPolicy
extends RollingPolicyBase
implements TriggeringPolicy {
    private TimeBasedRollingPolicy tbrp;
    private Semaphore deleteSem = new Semaphore(1);
    private Thread deleteThread = new Thread();
    private int maxHistory = 720;

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public void setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
    }

    public OozieRollingPolicy() {
        this.tbrp = new TimeBasedRollingPolicy();
    }

    public void activateOptions() {
        super.activateOptions();
        this.tbrp.setFileNamePattern(this.getFileNamePattern());
        this.tbrp.activateOptions();
    }

    public RolloverDescription initialize(String file, boolean append) throws SecurityException {
        return this.tbrp.initialize(file, append);
    }

    public RolloverDescription rollover(String activeFile) throws SecurityException {
        return this.tbrp.rollover(activeFile);
    }

    public boolean isTriggeringEvent(Appender appender, LoggingEvent event, String filename, long fileLength) {
        if (this.maxHistory >= 0 && this.deleteSem.tryAcquire()) {
            if (!this.deleteThread.isAlive()) {
                this.deleteThread = new Thread(){

                    @Override
                    public void run() {
                        OozieRollingPolicy.this.deleteOldFiles();
                    }
                };
                this.deleteThread.start();
            }
            this.deleteSem.release();
        }
        return this.tbrp.isTriggeringEvent(appender, event, filename, fileLength);
    }

    private void deleteOldFiles() {
        ArrayList<FileInfo> fileList = new ArrayList<FileInfo>();
        XLogService xls = this.getXLogService();
        if (xls != null) {
            String[] children;
            String oozieLogPath = xls.getOozieLogPath();
            String logFile = xls.getOozieLogName();
            if (oozieLogPath != null && logFile != null && (children = new File(oozieLogPath).list()) != null) {
                for (String child : children) {
                    if (!child.startsWith(logFile) || child.equals(logFile)) continue;
                    File childFile = new File(new File(oozieLogPath).getAbsolutePath(), child);
                    if (child.endsWith(".gz")) {
                        long gzFileCreationTime = this.getGZFileCreationTime(child);
                        if (gzFileCreationTime == -1L) continue;
                        fileList.add(new FileInfo(childFile.getAbsolutePath(), gzFileCreationTime));
                        continue;
                    }
                    long modTime = childFile.lastModified();
                    fileList.add(new FileInfo(childFile.getAbsolutePath(), modTime));
                }
            }
        }
        if (fileList.size() > this.maxHistory) {
            Collections.sort(fileList);
            for (int i = this.maxHistory; i < fileList.size(); ++i) {
                new File(((FileInfo)fileList.get(i)).getFileName()).delete();
            }
        }
    }

    private long getGZFileCreationTime(String fileName) {
        long returnVal = -1L;
        Matcher m = XLogStreamer.gzTimePattern.matcher(fileName);
        if (m.matches() && m.groupCount() == 4) {
            long logFileStartTime;
            int year = Integer.parseInt(m.group(1));
            int month = Integer.parseInt(m.group(2));
            int day = Integer.parseInt(m.group(3));
            int hour = Integer.parseInt(m.group(4));
            int minute = 0;
            Calendar calendarEntry = Calendar.getInstance();
            calendarEntry.set(year, month - 1, day, hour, minute);
            returnVal = logFileStartTime = calendarEntry.getTimeInMillis();
        }
        return returnVal;
    }

    XLogService getXLogService() {
        if (Services.get() != null) {
            return Services.get().get(XLogService.class);
        }
        return null;
    }

    class FileInfo
    implements Comparable<FileInfo> {
        String fileName;
        long modTime;

        public FileInfo(String fileName, long modTime) {
            this.fileName = fileName;
            this.modTime = modTime;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getModTime() {
            return this.modTime;
        }

        @Override
        public int compareTo(FileInfo fileInfo) {
            long diff = fileInfo.modTime - this.modTime;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

