/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;
import org.pentaho.reporting.engine.classic.core.layout.text.LegacyFontMetrics;
import org.pentaho.reporting.engine.classic.core.layout.text.TextUtility;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfigurationWrapper;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public abstract class AbstractOutputProcessorMetaData
implements OutputProcessorMetaData {
    private static final Log logger = LogFactory.getLog(AbstractOutputProcessorMetaData.class);
    private FontStorage fontStorage;
    private FontRegistry fontRegistry;
    private HashMap<OutputProcessorFeature.NumericOutputProcessorFeature, Double> numericFeatures;
    private HashMap<String, String> fontFamilyMapping;
    private HashSet<OutputProcessorFeature.BooleanOutputProcessorFeature> booleanFeatures;
    private Configuration configuration;
    private ReusableFontContext reusableFontContext;
    private HashMap<FontMetricsKey, FontMetrics> fontMetricsCache;
    private LFUMap<FontMetricsKey, ExtendedBaselineInfo> baselinesCache;
    private LFUMap<CacheKey, StyleCacheEntry> fontMetricsByStyleCache;
    private FontMetricsKey lookupKey;
    private double defaultFontSize;
    private double fontSmoothThreshold;
    private double deviceResolution;
    private CacheKey lookupCacheKey;

    protected AbstractOutputProcessorMetaData() {
        this((FontStorage)new DefaultFontStorage((FontRegistry)new AWTFontRegistry()));
    }

    protected AbstractOutputProcessorMetaData(FontStorage fontStorage) {
        if (fontStorage == null) {
            throw new NullPointerException();
        }
        this.booleanFeatures = new HashSet();
        this.numericFeatures = new HashMap();
        this.reusableFontContext = new ReusableFontContext();
        this.fontMetricsCache = new HashMap();
        this.baselinesCache = new LFUMap(200);
        this.lookupKey = new FontMetricsKey();
        this.lookupCacheKey = new CacheKey();
        this.fontMetricsByStyleCache = new LFUMap(200);
        this.fontFamilyMapping = new HashMap();
        this.fontRegistry = fontStorage.getFontRegistry();
        this.fontStorage = fontStorage;
        this.setFamilyMapping(null, "SansSerif");
    }

    @Override
    public void initialize(Configuration configuration) {
        double deviceResolution;
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.configuration = configuration;
        ExtendedConfigurationWrapper extendedConfig = new ExtendedConfigurationWrapper(configuration);
        double defaultFontSize = extendedConfig.getIntProperty("org.pentaho.reporting.engine.classic.core.layout.defaults.FontSize", 12);
        this.setNumericFeatureValue(OutputProcessorFeature.DEFAULT_FONT_SIZE, defaultFontSize);
        double fontSmoothThreshold = extendedConfig.getIntProperty("org.pentaho.reporting.engine.classic.core.layout.defaults.FontSmoothThreshold", 8);
        this.setNumericFeatureValue(OutputProcessorFeature.FONT_SMOOTH_THRESHOLD, fontSmoothThreshold);
        if (!extendedConfig.getBoolProperty("org.pentaho.reporting.engine.classic.core.layout.fontrenderer.UseMaxCharBounds", true)) {
            this.addFeature(OutputProcessorFeature.LEGACY_LINEHEIGHT_CALC);
        }
        if (extendedConfig.getBoolProperty("org.pentaho.reporting.engine.classic.core.layout.fontrenderer.ComplexTextLayout", false)) {
            this.addFeature(OutputProcessorFeature.COMPLEX_TEXT);
        }
        if (extendedConfig.getBoolProperty("org.pentaho.reporting.engine.classic.core.FixImageResolutionMapping", true)) {
            this.addFeature(OutputProcessorFeature.IMAGE_RESOLUTION_MAPPING);
        }
        if (extendedConfig.getBoolProperty("org.pentaho.reporting.engine.classic.core.UseNativeScaling", true)) {
            this.addFeature(OutputProcessorFeature.PREFER_NATIVE_SCALING);
        }
        if (extendedConfig.getBoolProperty("org.pentaho.reporting.engine.classic.core.DetectExtraContent", true)) {
            this.addFeature(OutputProcessorFeature.DETECT_EXTRA_CONTENT);
        }
        if (extendedConfig.getBoolProperty("org.pentaho.reporting.engine.classic.core.legacy.StrictCompatibility", false)) {
            this.addFeature(OutputProcessorFeature.STRICT_COMPATIBILITY);
            this.addFeature(OutputProcessorFeature.PRD_3750);
        }
        if ((deviceResolution = (double)extendedConfig.getIntProperty("org.pentaho.reporting.engine.classic.core.layout.DeviceResolution", 72)) > 0.0) {
            this.setNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION, deviceResolution);
        } else {
            this.setNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION, 72.0);
        }
    }

    @Override
    public Configuration getConfiguration() {
        if (this.configuration == null) {
            throw new InvalidReportStateException("Initialize() has not been called yet.");
        }
        return this.configuration;
    }

    protected void setFamilyMapping(String family, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.fontFamilyMapping.put(family, name);
    }

    protected void addFeature(OutputProcessorFeature.BooleanOutputProcessorFeature feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        this.booleanFeatures.add(feature);
    }

    protected void removeFeature(OutputProcessorFeature.BooleanOutputProcessorFeature feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        this.booleanFeatures.remove(feature);
    }

    @Override
    public boolean isFeatureSupported(OutputProcessorFeature.BooleanOutputProcessorFeature feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        return this.booleanFeatures.contains(feature);
    }

    protected void setNumericFeatureValue(OutputProcessorFeature.NumericOutputProcessorFeature feature, double value) {
        if (feature == null) {
            throw new NullPointerException();
        }
        if (OutputProcessorFeature.DEFAULT_FONT_SIZE.equals(feature)) {
            this.numericFeatures.put(OutputProcessorFeature.DEFAULT_FONT_SIZE, new Double(value));
            this.defaultFontSize = value;
        } else if (OutputProcessorFeature.FONT_SMOOTH_THRESHOLD.equals(feature)) {
            this.numericFeatures.put(OutputProcessorFeature.FONT_SMOOTH_THRESHOLD, new Double(value));
            this.fontSmoothThreshold = value;
        } else if (OutputProcessorFeature.DEVICE_RESOLUTION.equals(feature)) {
            this.numericFeatures.put(OutputProcessorFeature.DEVICE_RESOLUTION, new Double(value));
            this.deviceResolution = value;
        } else {
            this.numericFeatures.put(feature, new Double(value));
        }
    }

    @Override
    public double getNumericFeatureValue(OutputProcessorFeature.NumericOutputProcessorFeature feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        if (OutputProcessorFeature.DEFAULT_FONT_SIZE == feature) {
            return this.defaultFontSize;
        }
        if (OutputProcessorFeature.FONT_SMOOTH_THRESHOLD == feature) {
            return this.fontSmoothThreshold;
        }
        if (OutputProcessorFeature.DEVICE_RESOLUTION == feature) {
            return this.deviceResolution;
        }
        Double d = this.numericFeatures.get(feature);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public boolean isContentSupported(Object content) {
        return content != null;
    }

    protected FontRegistry getFontRegistry() {
        return this.fontRegistry;
    }

    protected FontStorage getFontStorage() {
        return this.fontStorage;
    }

    @Override
    public String getNormalizedFontFamilyName(String name) {
        String normalizedFontFamily = this.fontFamilyMapping.get(name);
        if (normalizedFontFamily == null) {
            if (name == null) {
                throw new IllegalStateException("There is no default mapping for <null> fonts defined.");
            }
            return name;
        }
        return normalizedFontFamily;
    }

    public FontMetrics getFontMetrics(String fontFamily, double fontSize, boolean bold, boolean italics, String encoding, boolean embedded, boolean antiAliasing) throws IllegalArgumentException {
        if (fontFamily == null) {
            throw new NullPointerException();
        }
        this.lookupKey.setAntiAliased(antiAliasing);
        this.lookupKey.setEncoding(encoding);
        this.lookupKey.setEmbedded(embedded);
        this.lookupKey.setFontFamily(fontFamily);
        this.lookupKey.setFontSize(fontSize);
        this.lookupKey.setBold(bold);
        this.lookupKey.setItalics(italics);
        FontMetrics cached = this.fontMetricsCache.get(this.lookupKey);
        if (cached != null) {
            return cached;
        }
        FontRegistry registry = this.getFontRegistry();
        FontFamily family = registry.getFontFamily(fontFamily);
        if (family == null) {
            logger.warn((Object)("Unable to lookup the font family: " + fontFamily));
            String fallBack = this.getNormalizedFontFamilyName(null);
            if (fallBack == null) {
                throw new IllegalArgumentException("No default family defined, aborting.");
            }
            family = registry.getFontFamily(fallBack);
            if (family == null) {
                throw new IllegalArgumentException("Default family is invalid. Aborting.");
            }
        }
        this.reusableFontContext.setAntiAliased(antiAliasing);
        this.reusableFontContext.setFontSize(fontSize);
        this.reusableFontContext.setEncoding(encoding);
        this.reusableFontContext.setEmbedded(embedded);
        FontRecord record = family.getFontRecord(bold, italics);
        FontMetrics fm = this.getFontStorage().getFontMetrics(record.getIdentifier(), (FontContext)this.reusableFontContext);
        if (fm == null) {
            throw new NullPointerException("FontMetrics returned from factory is null.");
        }
        if (this.isFeatureSupported(OutputProcessorFeature.LEGACY_LINEHEIGHT_CALC)) {
            LegacyFontMetrics legacyFontMetrics = new LegacyFontMetrics(fm, fontSize);
            this.fontMetricsCache.put(new FontMetricsKey(this.lookupKey), legacyFontMetrics);
            return legacyFontMetrics;
        }
        this.fontMetricsCache.put(new FontMetricsKey(this.lookupKey), fm);
        return fm;
    }

    @Override
    public ExtendedBaselineInfo getBaselineInfo(int codePoint, StyleSheet styleSheet) {
        FontMetrics fontMetrics = this.getFontMetrics(styleSheet);
        if (fontMetrics.isUniformFontMetrics()) {
            String fontFamily = this.getNormalizedFontFamilyName((String)styleSheet.getStyleProperty(TextStyleKeys.FONT));
            if (fontFamily == null) {
                throw new IllegalArgumentException("No valid font family specified.");
            }
            double fontSize = styleSheet.getDoubleStyleProperty(TextStyleKeys.FONTSIZE, this.defaultFontSize);
            boolean antiAliasing = RenderUtility.isFontSmooth(styleSheet, this);
            String encoding = (String)styleSheet.getStyleProperty(TextStyleKeys.FONTENCODING);
            boolean embedded = this.isFeatureSupported(OutputProcessorFeature.EMBED_ALL_FONTS) || styleSheet.getBooleanStyleProperty(TextStyleKeys.EMBEDDED_FONT);
            boolean bold = styleSheet.getBooleanStyleProperty(TextStyleKeys.BOLD, false);
            boolean italics = styleSheet.getBooleanStyleProperty(TextStyleKeys.ITALIC, false);
            this.lookupKey.setAntiAliased(antiAliasing);
            this.lookupKey.setEncoding(encoding);
            this.lookupKey.setEmbedded(embedded);
            this.lookupKey.setFontFamily(fontFamily);
            this.lookupKey.setFontSize(fontSize);
            this.lookupKey.setBold(bold);
            this.lookupKey.setItalics(italics);
            ExtendedBaselineInfo cached = (ExtendedBaselineInfo)this.baselinesCache.get((Object)this.lookupKey);
            if (cached != null) {
                return cached;
            }
        }
        ExtendedBaselineInfo baselineInfo = TextUtility.createBaselineInfo(120, fontMetrics, null);
        if (fontMetrics.isUniformFontMetrics()) {
            this.baselinesCache.put((Object)new FontMetricsKey(this.lookupKey), (Object)baselineInfo);
        }
        return baselineInfo;
    }

    @Override
    public FontMetrics getFontMetrics(StyleSheet styleSheet) throws IllegalArgumentException {
        this.lookupCacheKey.reuse(styleSheet.getId(), styleSheet.getClass().getName());
        StyleCacheEntry o = (StyleCacheEntry)this.fontMetricsByStyleCache.get((Object)this.lookupCacheKey);
        if (o != null && o.getChangeTracker() == styleSheet.getChangeTracker()) {
            return o.getMetrics();
        }
        String fontFamily = this.getNormalizedFontFamilyName((String)styleSheet.getStyleProperty(TextStyleKeys.FONT));
        if (fontFamily == null) {
            throw new IllegalArgumentException("No valid font family specified.");
        }
        double fontSize = styleSheet.getDoubleStyleProperty(TextStyleKeys.FONTSIZE, this.defaultFontSize);
        boolean antiAliasing = RenderUtility.isFontSmooth(styleSheet, this);
        String encoding = (String)styleSheet.getStyleProperty(TextStyleKeys.FONTENCODING);
        boolean embedded = this.isFeatureSupported(OutputProcessorFeature.EMBED_ALL_FONTS) || styleSheet.getBooleanStyleProperty(TextStyleKeys.EMBEDDED_FONT);
        boolean bold = styleSheet.getBooleanStyleProperty(TextStyleKeys.BOLD, false);
        boolean italics = styleSheet.getBooleanStyleProperty(TextStyleKeys.ITALIC, false);
        FontMetrics metrics = this.getFontMetrics(fontFamily, fontSize, bold, italics, encoding, embedded, antiAliasing);
        CacheKey key = new CacheKey(styleSheet.getId(), styleSheet.getClass().getName());
        this.fontMetricsByStyleCache.put((Object)key, (Object)new StyleCacheEntry(styleSheet.getChangeTracker(), metrics));
        return metrics;
    }

    @Override
    public void commit() {
        this.fontStorage.commit();
        this.fontMetricsByStyleCache.clear();
    }

    @Override
    public boolean isExtraContentElement(StyleSheet style, ReportAttributeMap attributes) {
        if (!this.isFeatureSupported(OutputProcessorFeature.DETECT_EXTRA_CONTENT)) {
            return false;
        }
        if (!StringUtils.isEmpty((String)((String)style.getStyleProperty(ElementStyleKeys.ANCHOR_NAME)))) {
            return true;
        }
        return !StringUtils.isEmpty((String)((String)style.getStyleProperty(ElementStyleKeys.HREF_TARGET)));
    }

    private static class StyleCacheEntry {
        private long changeTracker;
        private FontMetrics metrics;

        private StyleCacheEntry(long changeTracker, FontMetrics metrics) {
            this.changeTracker = changeTracker;
            this.metrics = metrics;
        }

        public long getChangeTracker() {
            return this.changeTracker;
        }

        public FontMetrics getMetrics() {
            return this.metrics;
        }
    }

    private static class CacheKey {
        private InstanceID instanceId;
        private String styleClass;

        protected CacheKey() {
        }

        protected CacheKey(InstanceID instanceId, String styleClass) {
            if (instanceId == null) {
                throw new NullPointerException();
            }
            if (styleClass == null) {
                throw new NullPointerException();
            }
            this.instanceId = instanceId;
            this.styleClass = styleClass;
        }

        public void reuse(InstanceID instanceId, String styleClass) {
            if (instanceId == null) {
                throw new NullPointerException();
            }
            if (styleClass == null) {
                throw new NullPointerException();
            }
            this.instanceId = instanceId;
            this.styleClass = styleClass;
        }

        public Object getInstanceId() {
            return this.instanceId;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.instanceId.equals(cacheKey.instanceId)) {
                return false;
            }
            return this.styleClass.equals(cacheKey.styleClass);
        }

        public int hashCode() {
            int result = this.instanceId.hashCode();
            result = 31 * result + this.styleClass.hashCode();
            return result;
        }

        public String toString() {
            return "CacheKey{instanceId=" + this.instanceId + ", styleClass='" + this.styleClass + '\'' + '}';
        }
    }

    protected static class ReusableFontContext
    implements FontContext {
        private boolean antiAliased;
        private double fontSize;
        private boolean embedded;
        private String encoding;

        protected ReusableFontContext() {
        }

        public boolean isEmbedded() {
            return this.embedded;
        }

        public void setEmbedded(boolean embedded) {
            this.embedded = embedded;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void setAntiAliased(boolean antiAliased) {
            this.antiAliased = antiAliased;
        }

        public void setFontSize(double fontSize) {
            this.fontSize = fontSize;
        }

        public boolean isAntiAliased() {
            return this.antiAliased;
        }

        public boolean isFractionalMetrics() {
            return true;
        }

        public double getFontSize() {
            return this.fontSize;
        }
    }

    private static class FontMetricsKey {
        private int hashCode;
        private boolean hashValid;
        private String fontFamily;
        private double fontSize;
        private boolean antiAliased;
        private boolean embedded;
        private String encoding;
        private boolean italics;
        private boolean bold;

        private FontMetricsKey() {
        }

        private FontMetricsKey(FontMetricsKey derived) {
            this.fontFamily = derived.fontFamily;
            this.fontSize = derived.fontSize;
            this.antiAliased = derived.antiAliased;
            this.embedded = derived.embedded;
            this.encoding = derived.encoding;
            this.italics = derived.italics;
            this.bold = derived.bold;
        }

        public String getFontFamily() {
            return this.fontFamily;
        }

        public void setFontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
            this.hashValid = false;
        }

        public double getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(double fontSize) {
            this.fontSize = fontSize;
            this.hashValid = false;
        }

        public boolean isAntiAliased() {
            return this.antiAliased;
        }

        public void setAntiAliased(boolean antiAliased) {
            this.antiAliased = antiAliased;
            this.hashValid = false;
        }

        public boolean isEmbedded() {
            return this.embedded;
        }

        public void setEmbedded(boolean embedded) {
            this.embedded = embedded;
            this.hashValid = false;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
            this.hashValid = false;
        }

        public boolean isItalics() {
            return this.italics;
        }

        public void setItalics(boolean italics) {
            this.italics = italics;
            this.hashValid = false;
        }

        public boolean isBold() {
            return this.bold;
        }

        public void setBold(boolean bold) {
            this.bold = bold;
            this.hashValid = false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontMetricsKey that = (FontMetricsKey)o;
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            if (this.antiAliased != that.antiAliased) {
                return false;
            }
            if (this.embedded != that.embedded) {
                return false;
            }
            if (this.bold != that.bold) {
                return false;
            }
            if (this.italics != that.italics) {
                return false;
            }
            if (that.fontSize != this.fontSize) {
                return false;
            }
            if (this.encoding != null ? !this.encoding.equals(that.encoding) : that.encoding != null) {
                return false;
            }
            return this.fontFamily.equals(that.fontFamily);
        }

        public int hashCode() {
            if (!this.hashValid) {
                int result = this.fontFamily.hashCode();
                long temp = this.fontSize != 0.0 ? Double.doubleToLongBits(this.fontSize) : 0L;
                result = 29 * result + (int)(temp ^ temp >>> 32);
                result = 29 * result + (this.antiAliased ? 1 : 0);
                result = 29 * result + (this.embedded ? 1 : 0);
                result = 29 * result + (this.italics ? 1 : 0);
                result = 29 * result + (this.bold ? 1 : 0);
                this.hashCode = result = 29 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
                this.hashValid = true;
                return result;
            }
            return this.hashCode;
        }
    }
}

