/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.alignment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.AlignmentChunk;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.DefaultSequenceList;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.SequenceList;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.StartSequenceElement;

public class ChunkIterator
implements Iterator<AlignmentChunk>,
Cloneable {
    private SequenceList sequenceList;
    private int startPosition;

    public ChunkIterator(SequenceList sequenceList, int startPosition) {
        this.sequenceList = sequenceList;
        this.startPosition = startPosition;
    }

    public int getPosition() {
        return this.startPosition;
    }

    @Override
    public boolean hasNext() {
        return this.startPosition < this.sequenceList.size();
    }

    @Override
    public AlignmentChunk next() {
        if (this.startPosition >= this.sequenceList.size()) {
            throw new NoSuchElementException();
        }
        if (this.startPosition == 0 && this.sequenceList.size() == 1) {
            this.startPosition = 0;
            return new AlignmentChunk(this.sequenceList, 0, 1, this.sequenceList.getMinimumLength(0));
        }
        InlineSequenceElement.Classification lastType = this.sequenceList.getSequenceElement(this.startPosition).getType();
        long length = this.sequenceList.getMinimumLength(this.startPosition);
        boolean lastNodeWasSpacer = lastType == InlineSequenceElement.Classification.CONTENT && this.sequenceList.getNode(this.startPosition).getNodeType() == 65;
        for (int i = this.startPosition + 1; i < this.sequenceList.size(); ++i) {
            InlineSequenceElement sequenceElement = this.sequenceList.getSequenceElement(i);
            InlineSequenceElement.Classification classification = sequenceElement.getType();
            if (!lastNodeWasSpacer && lastType != InlineSequenceElement.Classification.START && classification != InlineSequenceElement.Classification.END) {
                int chunkStart = this.startPosition;
                this.startPosition = i;
                return new AlignmentChunk(this.sequenceList, chunkStart, i - chunkStart, length);
            }
            lastNodeWasSpacer = classification == InlineSequenceElement.Classification.CONTENT && this.sequenceList.getNode(i).getNodeType() == 65;
            lastType = classification;
            length += this.sequenceList.getMinimumLength(i);
        }
        int chunkStart = this.startPosition;
        this.startPosition = this.sequenceList.size();
        return new AlignmentChunk(this.sequenceList, chunkStart, this.sequenceList.size() - chunkStart, length);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public ChunkIterator createPadding(int start, ArrayList<RenderBox> paddingBoxes) {
        int i;
        DefaultSequenceList list = new DefaultSequenceList(paddingBoxes.size() + this.sequenceList.size() - start);
        for (i = 0; i < paddingBoxes.size(); ++i) {
            RenderBox box = paddingBoxes.get(i);
            list.add(StartSequenceElement.INSTANCE, box);
        }
        for (i = start; i < this.sequenceList.size(); ++i) {
            list.add(this.sequenceList.getSequenceElement(i), this.sequenceList.getNode(i));
        }
        return new ChunkIterator(list, 0);
    }
}

