/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultAttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultStyleKeyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeGroupRefReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.GlobalMetaDefinition;
import org.pentaho.reporting.engine.classic.core.metadata.parser.StyleGroupRefReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.StyleReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementReadHandler
extends AbstractXmlReadHandler {
    private static final Log logger = LogFactory.getLog(ElementReadHandler.class);
    private String name;
    private boolean expert;
    private boolean hidden;
    private boolean preferred;
    private boolean deprecated;
    private ElementMetaData.TypeClassification reportElementType;
    private AttributeMap<AttributeMetaData> attributes;
    private HashMap<StyleKey, StyleMetaData> styles;
    private String bundleName;
    private String prefix;
    private Class elementType;
    private Class contentType;
    private String namespace;
    private ArrayList<StyleReadHandler> styleHandlers;
    private ArrayList<AttributeReadHandler> attributeHandlers;
    private GlobalMetaDefinition globalMetaDefinition;
    private boolean experimental;
    private int compatibilityLevel;

    public ElementReadHandler(GlobalMetaDefinition globalMetaDefinition) {
        this.globalMetaDefinition = globalMetaDefinition;
        this.attributes = new AttributeMap();
        this.styles = new HashMap();
        this.attributeHandlers = new ArrayList();
        this.styleHandlers = new ArrayList();
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        this.name = attrs.getValue(this.getUri(), "name");
        if (this.name == null) {
            throw new ParseException("Attribute 'name' is undefined", this.getLocator());
        }
        this.namespace = attrs.getValue(this.getUri(), "namespace");
        this.experimental = "true".equals(attrs.getValue(this.getUri(), "experimental"));
        this.compatibilityLevel = ReportParserUtil.parseVersion(attrs.getValue(this.getUri(), "compatibility-level"));
        this.expert = "true".equals(attrs.getValue(this.getUri(), "expert"));
        this.hidden = "true".equals(attrs.getValue(this.getUri(), "hidden"));
        this.preferred = "true".equals(attrs.getValue(this.getUri(), "preferred"));
        this.deprecated = "true".equals(attrs.getValue(this.getUri(), "deprecated"));
        boolean container = "true".equals(attrs.getValue(this.getUri(), "container"));
        this.reportElementType = !container ? ElementMetaData.TypeClassification.DATA : ElementMetaData.TypeClassification.SECTION;
        String eType = attrs.getValue(this.getUri(), "type-classification");
        if ("section".equals(eType)) {
            this.reportElementType = ElementMetaData.TypeClassification.SECTION;
        } else if ("data".equals(eType)) {
            this.reportElementType = ElementMetaData.TypeClassification.DATA;
        } else if ("control".equals(eType)) {
            this.reportElementType = ElementMetaData.TypeClassification.CONTROL;
        } else if ("footer".equals(eType)) {
            this.reportElementType = ElementMetaData.TypeClassification.FOOTER;
        } else if ("group-footer".equals(eType)) {
            this.reportElementType = ElementMetaData.TypeClassification.RELATIONAL_FOOTER;
        } else if ("header".equals(eType)) {
            this.reportElementType = ElementMetaData.TypeClassification.HEADER;
        } else if ("group-header".equals(eType)) {
            this.reportElementType = ElementMetaData.TypeClassification.RELATIONAL_HEADER;
        } else if ("subreport".equals(eType)) {
            this.reportElementType = ElementMetaData.TypeClassification.SUBREPORT;
        }
        this.bundleName = attrs.getValue(this.getUri(), "bundle-name");
        this.prefix = "element." + this.name;
        String elementTypeText = attrs.getValue(this.getUri(), "implementation");
        if (elementTypeText == null) {
            throw new ParseException("Attribute 'implementation' is undefined", this.getLocator());
        }
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(ElementReadHandler.class);
            this.elementType = Class.forName(elementTypeText, false, loader);
        }
        catch (Exception e) {
            throw new ParseException("Attribute 'implementation' is not valid", e, this.getLocator());
        }
        if (!ElementType.class.isAssignableFrom(this.elementType)) {
            throw new ParseException("Attribute 'implementation' is not valid", this.getLocator());
        }
        String contentType = attrs.getValue(this.getUri(), "content-type");
        if (contentType == null) {
            this.contentType = Object.class;
        } else {
            try {
                ClassLoader loader = ObjectUtilities.getClassLoader(ElementReadHandler.class);
                this.contentType = Class.forName(contentType, false, loader);
            }
            catch (Exception e) {
                throw new ParseException("Attribute 'content-type' is not valid", e, this.getLocator());
            }
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.getUri().equals(uri)) {
            return null;
        }
        if ("attribute-group-ref".equals(tagName)) {
            return new AttributeGroupRefReadHandler(this.attributes, this.globalMetaDefinition, this.bundleName);
        }
        if ("style-group-ref".equals(tagName)) {
            return new StyleGroupRefReadHandler(this.styles, this.globalMetaDefinition, this.bundleName);
        }
        if ("attribute".equals(tagName)) {
            AttributeReadHandler readHandler = new AttributeReadHandler(null);
            this.attributeHandlers.add(readHandler);
            return readHandler;
        }
        if ("style".equals(tagName)) {
            StyleReadHandler readHandler = new StyleReadHandler(this.bundleName);
            this.styleHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        AbstractXmlReadHandler handler;
        int i;
        for (i = 0; i < this.attributeHandlers.size(); ++i) {
            String prefix;
            String bundleName;
            handler = this.attributeHandlers.get(i);
            String namespace = handler.getNamespace();
            String attrName = handler.getName();
            String namespacePrefix = ElementTypeRegistry.getInstance().getNamespacePrefix(namespace);
            if (namespacePrefix == null) {
                logger.warn((Object)("Invalid namespace-prefix, skipping attribute " + namespace + ':' + attrName));
                continue;
            }
            if (handler.getBundle() != null) {
                bundleName = handler.getBundle();
                prefix = "attribute." + namespacePrefix + '.';
            } else {
                bundleName = this.bundleName;
                prefix = this.prefix + ".attribute." + namespacePrefix + '.';
            }
            DefaultAttributeMetaData metaData = new DefaultAttributeMetaData(namespace, attrName, bundleName, prefix, handler.getPropertyEditor(), handler.getValueType(), handler.isExpert(), handler.isPreferred(), handler.isHidden(), handler.isDeprecated(), handler.isMandatory(), handler.isComputed(), handler.isTransient(), handler.getValueRole(), handler.isBulk(), handler.isDesignTimeValue(), handler.getAttributeCore(), handler.isExperimental(), handler.getCompatibilityLevel());
            this.attributes.setAttribute(namespace, attrName, (Object)metaData);
        }
        for (i = 0; i < this.styleHandlers.size(); ++i) {
            handler = this.styleHandlers.get(i);
            String keyName = handler.getName();
            StyleKey key = StyleKey.getStyleKey(keyName);
            DefaultStyleKeyMetaData metaData = new DefaultStyleKeyMetaData(key, handler.getPropertyEditor(), handler.getBundleName(), "style.", handler.isExpert(), handler.isPreferred(), handler.isHidden(), handler.isDeprecated(), handler.isExperimental(), handler.getCompatibilityLevel());
            this.styles.put(key, metaData);
        }
    }

    public Object getObject() throws SAXException {
        return new DefaultElementMetaData(this.name, this.bundleName, "element.", this.namespace, this.expert, this.preferred, this.hidden, this.deprecated, this.reportElementType, this.attributes, this.styles, this.elementType, this.contentType, this.experimental, this.compatibilityLevel);
    }
}

