/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeDefinition;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeGroup;
import org.pentaho.reporting.engine.classic.core.metadata.parser.StyleGroup;
import org.pentaho.reporting.engine.classic.core.metadata.parser.StyleReadHandler;

public class GlobalMetaDefinition
implements Cloneable {
    private HashMap<String, StyleGroup> styleGroups = new HashMap();
    private HashMap<String, AttributeGroup> attributeGroups = new HashMap();

    public void addAttributeGroup(AttributeGroup group) {
        if (group == null) {
            throw new NullPointerException();
        }
        this.attributeGroups.put(group.getName(), group);
    }

    public void addStyleGroup(StyleGroup group) {
        if (group == null) {
            throw new NullPointerException();
        }
        this.styleGroups.put(group.getName(), group);
    }

    public StyleGroup getStyleGroup(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.styleGroups.get(name);
    }

    public AttributeGroup getAttributeGroup(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributeGroups.get(name);
    }

    public Object clone() throws CloneNotSupportedException {
        GlobalMetaDefinition definition = (GlobalMetaDefinition)super.clone();
        definition.styleGroups = (HashMap)this.styleGroups.clone();
        definition.attributeGroups = (HashMap)this.attributeGroups.clone();
        return definition;
    }

    public void merge(GlobalMetaDefinition definition) {
        if (definition == null) {
            throw new NullPointerException();
        }
        this.mergeStyles(definition);
        for (Map.Entry<String, AttributeGroup> entry : definition.attributeGroups.entrySet()) {
            AttributeGroup styleGroup = this.attributeGroups.get(entry.getKey());
            if (styleGroup == null) {
                this.addAttributeGroup(entry.getValue());
                continue;
            }
            AttributeGroup entryGroup = entry.getValue();
            String name = styleGroup.getName();
            LinkedHashMap<String, AttributeDefinition> styles = new LinkedHashMap<String, AttributeDefinition>();
            AttributeDefinition[] data = styleGroup.getMetaData();
            for (int i = 0; i < data.length; ++i) {
                AttributeDefinition handler = data[i];
                styles.put(handler.getName(), handler);
            }
            AttributeDefinition[] entryData = entryGroup.getMetaData();
            for (int i = 0; i < entryData.length; ++i) {
                AttributeDefinition handler = entryData[i];
                styles.put(handler.getName(), handler);
            }
            this.addAttributeGroup(new AttributeGroup(name, styles.values().toArray(new AttributeDefinition[styles.size()])));
        }
    }

    private void mergeStyles(GlobalMetaDefinition definition) {
        for (Map.Entry<String, StyleGroup> entry : definition.styleGroups.entrySet()) {
            StyleGroup styleGroup = this.styleGroups.get(entry.getKey());
            if (styleGroup == null) {
                this.addStyleGroup(entry.getValue());
                continue;
            }
            StyleGroup entryGroup = entry.getValue();
            String name = styleGroup.getName();
            LinkedHashMap<String, StyleReadHandler> styles = new LinkedHashMap<String, StyleReadHandler>();
            StyleReadHandler[] data = styleGroup.getMetaData();
            for (int i = 0; i < data.length; ++i) {
                StyleReadHandler handler = data[i];
                styles.put(handler.getName(), handler);
            }
            StyleReadHandler[] entryData = entryGroup.getMetaData();
            for (int i = 0; i < entryData.length; ++i) {
                StyleReadHandler handler = entryData[i];
                styles.put(handler.getName(), handler);
            }
            this.addStyleGroup(new StyleGroup(name, styles.values().toArray(new StyleReadHandler[styles.size()])));
        }
    }
}

