/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.html;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportInterruptedException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.html.HtmlExportGUIModule;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlContentItems;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlExportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.validator.ReportStructureValidator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FileSystemURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.StreamHtmlOutputProcessor;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.file.FileRepository;

public class HtmlStreamExportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(HtmlStreamExportTask.class);
    private Messages messages;
    private final ReportProgressDialog progressDialog;
    private final MasterReport report;
    private StatusListener statusListener;
    private File targetDirectory;
    private String suffix;
    private String filename;

    public HtmlStreamExportTask(MasterReport report, ReportProgressDialog dialog, SwingGuiContext swingGuiContext) throws ReportProcessingException {
        if (report == null) {
            throw new ReportProcessingException("HtmlStreamExportTask(..): Report-Parameter cannot be null");
        }
        try {
            this.progressDialog = dialog;
            this.report = report;
            if (swingGuiContext != null) {
                this.statusListener = swingGuiContext.getStatusListener();
                this.messages = new Messages(swingGuiContext.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.html.messages.messages", ObjectUtilities.getClassLoader(HtmlExportGUIModule.class));
            } else {
                this.messages = new Messages(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.html.messages.messages", ObjectUtilities.getClassLoader(HtmlExportGUIModule.class));
            }
            Configuration config = report.getConfiguration();
            String targetFileName = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.stream.TargetFileName");
            if (targetFileName == null) {
                throw new ReportProcessingException(this.messages.getErrorString("HtmlStreamExportTask.ERROR_0002_TARGET_NOT_SET", new String[0]));
            }
            File targetFile = new File(targetFileName).getCanonicalFile();
            this.targetDirectory = targetFile.getParentFile();
            this.suffix = this.getSuffix(targetFileName);
            this.filename = IOUtils.getInstance().stripFileExtension(targetFile.getName());
            if (targetFile.exists() && !targetFile.delete()) {
                throw new ReportProcessingException(this.messages.getErrorString("HtmlStreamExportTask.ERROR_0003_TARGET_FILE_EXISTS", new String[]{targetFile.getAbsolutePath()}));
            }
        }
        catch (IOException ioe) {
            throw new ReportProcessingException("Failed to normalize directories.", ioe);
        }
    }

    private String getSuffix(String filename) {
        String suffix = IOUtils.getInstance().getFileExtension(filename);
        if (suffix.length() == 0) {
            return "";
        }
        return suffix.substring(1);
    }

    @Override
    public void run() {
        block10: {
            try {
                AbstractReportProcessor reportProcessor;
                FileRepository targetRepository = new FileRepository(this.targetDirectory);
                ContentLocation targetRoot = targetRepository.getRoot();
                ReportStructureValidator validator = new ReportStructureValidator();
                if (!validator.isValidForFastProcessing(this.report)) {
                    StreamHtmlOutputProcessor outputProcessor = new StreamHtmlOutputProcessor(this.report.getConfiguration());
                    AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(this.report.getResourceManager());
                    printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, this.filename, this.suffix));
                    printer.setDataWriter(null, null);
                    printer.setUrlRewriter(new FileSystemURLRewriter());
                    outputProcessor.setPrinter(printer);
                    reportProcessor = new StreamReportProcessor(this.report, outputProcessor);
                } else {
                    FastHtmlContentItems printer = new FastHtmlContentItems();
                    printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, this.filename, this.suffix));
                    printer.setDataWriter(null, null);
                    printer.setUrlRewriter(new FileSystemURLRewriter());
                    reportProcessor = new FastHtmlExportProcessor(this.report, printer);
                }
                if (this.progressDialog != null) {
                    this.progressDialog.setModal(false);
                    this.progressDialog.setVisible(true);
                    reportProcessor.addReportProgressListener(this.progressDialog);
                }
                reportProcessor.processReport();
                if (this.progressDialog != null) {
                    reportProcessor.removeReportProgressListener(this.progressDialog);
                }
                if (this.statusListener != null) {
                    this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("HtmlStreamExportTask.USER_TASK_FINISHED"), null);
                }
            }
            catch (ReportInterruptedException re) {
                if (this.statusListener != null) {
                    this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("HtmlStreamExportTask.USER_TASK_ABORTED"), null);
                }
            }
            catch (Exception re) {
                logger.error((Object)"Exporting failed .", (Throwable)re);
                if (this.statusListener == null) break block10;
                this.statusListener.setStatus(StatusType.ERROR, this.messages.getString("HtmlStreamExportTask.USER_TASK_ERROR"), re);
            }
        }
        if (this.progressDialog != null) {
            this.progressDialog.setVisible(false);
        }
    }
}

