/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.referencedoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DataSourceCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DataSourceFactory;

public class DataSourceReferenceTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"datasource-factory", "datasource-name", "datasource-class"};
    private final ArrayList rows = new ArrayList();

    public DataSourceReferenceTableModel(DataSourceCollector cf) {
        this.addFactoryCollector(cf);
    }

    private void addFactoryCollector(DataSourceCollector cf) {
        Iterator it = cf.getFactories();
        while (it.hasNext()) {
            DataSourceFactory cfact = (DataSourceFactory)it.next();
            if (cfact instanceof DataSourceCollector) {
                this.addFactoryCollector((DataSourceCollector)cfact);
                continue;
            }
            this.addDataSourceFactory(cfact);
        }
    }

    private void addDataSourceFactory(DataSourceFactory cf) {
        Iterator it = cf.getRegisteredNames();
        ArrayList<String> factories = new ArrayList<String>();
        while (it.hasNext()) {
            String c = (String)it.next();
            factories.add(c);
        }
        Collections.sort(factories);
        for (String keyName : factories) {
            ObjectDescription od = cf.getDataSourceDescription(keyName);
            this.rows.add(new DataSourceDescriptionRow(cf, keyName, od.getObjectClass()));
        }
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DataSourceDescriptionRow or = (DataSourceDescriptionRow)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return String.valueOf(or.getFactory().getClass().getName());
            }
            case 1: {
                return String.valueOf(or.getName());
            }
            case 2: {
                return String.valueOf(or.getImplementingClass().getName());
            }
        }
        return null;
    }

    private static class DataSourceDescriptionRow {
        private final DataSourceFactory datasourceFactory;
        private final String datasourceName;
        private final Class implementingClass;

        private DataSourceDescriptionRow(DataSourceFactory datasourceFactory, String name, Class implementingClass) {
            this.datasourceFactory = datasourceFactory;
            this.datasourceName = name;
            this.implementingClass = implementingClass;
        }

        public DataSourceFactory getFactory() {
            return this.datasourceFactory;
        }

        public String getName() {
            return this.datasourceName;
        }

        public Class getImplementingClass() {
            return this.implementingClass;
        }
    }
}

