/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.LocalImageContainer;
import org.pentaho.reporting.engine.classic.core.URLImageContainer;
import org.pentaho.reporting.engine.classic.core.layout.ModelPrinter;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnGroupNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.CollectSelectedNodesStep;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.RevalidateTextEllipseProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;
import org.pentaho.reporting.engine.classic.core.layout.text.Glyph;
import org.pentaho.reporting.engine.classic.core.layout.text.GlyphList;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PageDrawable;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.BorderRenderer;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class LogicalPageDrawable
extends IterateStructuralProcessStep
implements PageDrawable {
    public static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Log logger = LogFactory.getLog(LogicalPageDrawable.class);
    private FontDecorationSpec strikeThrough;
    private FontDecorationSpec underline;
    private boolean outlineMode;
    private LogicalPageBox rootBox;
    private OutputProcessorMetaData metaData;
    private PageFormat pageFormat;
    private double width;
    private double height;
    private CodePointBuffer codePointBuffer;
    private Graphics2D graphics;
    private boolean textLineOverflow;
    private long contentAreaX1;
    private long contentAreaX2;
    private RevalidateTextEllipseProcessStep revalidateTextEllipseProcessStep;
    private StrictBounds drawArea;
    private Rectangle2D.Double boxArea;
    private TextSpec textSpec;
    private boolean ellipseDrawn;
    private CollectSelectedNodesStep collectSelectedNodesStep;
    private BorderRenderer borderRenderer;
    private boolean drawPageBackground = true;
    private ResourceManager resourceManager;
    private boolean clipOnWordBoundary;
    private boolean strictClipping;
    private boolean unalignedPageBands;
    private TableContext tableContext;
    private FastStack<Graphics2D> graphicsContexts = new FastStack();
    private StrictBounds pageArea;

    public LogicalPageDrawable() {
        this.borderRenderer = new BorderRenderer();
        this.codePointBuffer = new CodePointBuffer(400);
        this.boxArea = new Rectangle2D.Double();
    }

    @Deprecated
    public LogicalPageDrawable(LogicalPageBox rootBox, OutputProcessorMetaData metaData, ResourceManager resourceManager) {
        this();
        this.init(rootBox, metaData, resourceManager);
    }

    public void init(LogicalPageBox rootBox, OutputProcessorMetaData metaData, ResourceManager resourceManager) {
        if (rootBox == null) {
            throw new NullPointerException();
        }
        if (metaData == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.resourceManager = resourceManager;
        this.metaData = metaData;
        this.rootBox = rootBox;
        this.width = StrictGeomUtility.toExternalValue(rootBox.getPageWidth());
        this.height = StrictGeomUtility.toExternalValue(rootBox.getPageHeight());
        Paper paper = new Paper();
        paper.setImageableArea(0.0, 0.0, this.width, this.height);
        this.pageFormat = new PageFormat();
        this.pageFormat.setPaper(paper);
        this.strictClipping = "true".equals(metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.StrictClipping"));
        this.outlineMode = "true".equals(metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.debug.OutlineMode"));
        if ("true".equals(metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.debug.PrintPageContents"))) {
            ModelPrinter.INSTANCE.print(rootBox);
        }
        this.unalignedPageBands = metaData.isFeatureSupported(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        this.revalidateTextEllipseProcessStep = new RevalidateTextEllipseProcessStep(metaData);
        this.collectSelectedNodesStep = new CollectSelectedNodesStep();
        this.clipOnWordBoundary = "true".equals(metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.LastLineBreaksOnWordBoundary"));
    }

    public LogicalPageBox getLogicalPageBox() {
        return this.rootBox;
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public boolean isClipOnWordBoundary() {
        return this.clipOnWordBoundary;
    }

    public boolean isOutlineMode() {
        return this.outlineMode;
    }

    public void setOutlineMode(boolean outlineMode) {
        this.outlineMode = outlineMode;
    }

    protected StrictBounds getDrawArea() {
        return this.drawArea;
    }

    @Override
    public PageFormat getPageFormat() {
        return (PageFormat)this.pageFormat.clone();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((int)this.width, (int)this.height);
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean isPreserveAspectRatio() {
        return true;
    }

    public boolean isDrawPageBackground() {
        return this.drawPageBackground;
    }

    public void setDrawPageBackground(boolean drawPageBackground) {
        this.drawPageBackground = drawPageBackground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics2D graphics, Rectangle2D area) {
        Graphics2D g2 = (Graphics2D)graphics.create();
        if (this.isDrawPageBackground()) {
            g2.setPaint(Color.white);
            g2.fill(area);
        }
        g2.translate(-area.getX(), -area.getY());
        try {
            StrictBounds pageBounds;
            this.pageArea = pageBounds = StrictGeomUtility.createBounds(area.getX(), area.getY(), area.getWidth(), area.getHeight());
            this.drawArea = pageBounds;
            this.graphics = g2;
            if (this.startBlockBox(this.rootBox)) {
                this.processRootBand(pageBounds);
            }
            this.finishBlockBox(this.rootBox);
        }
        finally {
            this.graphics = null;
            this.drawArea = null;
            g2.dispose();
        }
    }

    protected void processRootBand(StrictBounds pageBounds) {
        this.startProcessing(this.rootBox.getWatermarkArea());
        BlockRenderBox headerArea = this.rootBox.getHeaderArea();
        BlockRenderBox footerArea = this.rootBox.getFooterArea();
        BlockRenderBox repeatFooterArea = this.rootBox.getRepeatFooterArea();
        StrictBounds headerBounds = new StrictBounds(headerArea.getX(), headerArea.getY(), headerArea.getWidth(), headerArea.getHeight());
        StrictBounds footerBounds = new StrictBounds(footerArea.getX(), footerArea.getY(), footerArea.getWidth(), footerArea.getHeight());
        StrictBounds repeatFooterBounds = new StrictBounds(repeatFooterArea.getX(), repeatFooterArea.getY(), repeatFooterArea.getWidth(), repeatFooterArea.getHeight());
        StrictBounds contentBounds = new StrictBounds(this.rootBox.getX(), headerArea.getY() + headerArea.getHeight(), this.rootBox.getWidth(), repeatFooterArea.getY() - headerArea.getHeight());
        double headerHeight = StrictGeomUtility.toExternalValue(this.drawArea.getHeight());
        Shape clip = this.graphics.getClip();
        this.setDrawArea(headerBounds);
        this.graphics.clip(this.createClipRect(this.drawArea));
        this.startProcessing(headerArea);
        if (this.unalignedPageBands) {
            this.graphics.translate(0.0, headerHeight);
        }
        this.setDrawArea(contentBounds);
        this.graphics.setClip(clip);
        this.graphics.clip(this.createClipRect(this.drawArea));
        this.processBoxChilds(this.rootBox);
        if (this.unalignedPageBands) {
            this.graphics.translate(0.0, -headerHeight);
            this.graphics.translate(0.0, this.height - StrictGeomUtility.toExternalValue(footerBounds.getHeight() + repeatFooterBounds.getHeight()));
        }
        this.setDrawArea(repeatFooterBounds);
        this.graphics.setClip(clip);
        this.graphics.clip(this.createClipRect(this.drawArea));
        this.startProcessing(repeatFooterArea);
        if (this.unalignedPageBands) {
            this.graphics.translate(0.0, StrictGeomUtility.toExternalValue(repeatFooterBounds.getHeight()));
        }
        this.setDrawArea(footerBounds);
        this.graphics.setClip(clip);
        this.graphics.clip(this.createClipRect(this.drawArea));
        this.startProcessing(footerArea);
        this.setDrawArea(pageBounds);
    }

    protected Rectangle2D createClipRect(StrictBounds bounds) {
        return StrictGeomUtility.createAWTRectangle(bounds.getX() - 1L, bounds.getY() - 1L, bounds.getWidth() + 2L, bounds.getHeight() + 2L);
    }

    protected LogicalPageBox getRootBox() {
        return this.rootBox;
    }

    protected void setDrawArea(StrictBounds drawArea) {
        this.drawArea = this.pageArea.createIntersection(drawArea);
    }

    protected void drawOutlineBox(Graphics2D g2, RenderBox box) {
        int nodeType = box.getNodeType();
        if (nodeType == 274) {
            g2.setPaint(Color.magenta);
        } else if (nodeType == 322) {
            g2.setPaint(Color.orange);
        } else if ((nodeType & 0x40002) == 262146) {
            g2.setPaint(Color.cyan);
        } else {
            g2.setPaint(Color.lightGray);
        }
        double x = StrictGeomUtility.toExternalValue(box.getX());
        double y = StrictGeomUtility.toExternalValue(box.getY());
        double w = StrictGeomUtility.toExternalValue(box.getWidth());
        double h = StrictGeomUtility.toExternalValue(box.getHeight());
        this.boxArea.setFrame(x, y, w, h);
        g2.draw(this.boxArea);
    }

    protected void processLinksAndAnchors(RenderNode box) {
        String bookmark;
        String anchor;
        StyleSheet styleSheet = box.getStyleSheet();
        String target = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TARGET);
        String title = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TITLE);
        if (target != null || title != null) {
            String window = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_WINDOW);
            this.drawHyperlink(box, target, window, title);
        }
        if ((anchor = (String)styleSheet.getStyleProperty(ElementStyleKeys.ANCHOR_NAME)) != null) {
            this.drawAnchor(box);
        }
        if ((bookmark = (String)styleSheet.getStyleProperty(BandStyleKeys.BOOKMARK)) != null) {
            this.drawBookmark(box, bookmark);
        }
    }

    protected void drawBookmark(RenderNode box, String bookmark) {
    }

    protected void drawHyperlink(RenderNode box, String target, String window, String title) {
    }

    @Override
    public boolean startCanvasBox(CanvasRenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected boolean startRowBox(RenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected boolean startTableCellBox(TableCellRenderBox box) {
        return this.startBox(box);
    }

    protected boolean startBox(RenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        if (!(box instanceof LogicalPageBox) && !box.isBoxVisible(this.drawArea)) {
            box.isBoxVisible(this.drawArea);
            return false;
        }
        this.renderBoxBorderAndBackground(box);
        this.processLinksAndAnchors(box);
        return true;
    }

    @Override
    protected boolean startTableRowBox(TableRowRenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        StrictBounds bounds;
        if (box.getDisplayRole() != TableSectionRenderBox.Role.HEADER && (bounds = this.tableContext.getBounds()).getHeight() != 0L) {
            StrictBounds clipBounds = new StrictBounds(bounds.getX(), bounds.getY() + bounds.getHeight(), StrictGeomUtility.toInternalValue(32767.0), StrictGeomUtility.toInternalValue(32767.0));
            this.clip(clipBounds);
            this.tableContext.getDrawArea().setRect(this.drawArea);
            this.drawArea.setRect(this.drawArea.createIntersection(clipBounds));
        }
        return this.startBox(box);
    }

    @Override
    protected void finishTableSectionBox(TableSectionRenderBox box) {
        if (box.getDisplayRole() == TableSectionRenderBox.Role.HEADER) {
            this.tableContext.getBounds().setRect(box.getX(), box.getY(), box.getWidth(), box.getHeight());
        } else if (this.tableContext.getBounds().getHeight() != 0L) {
            this.drawArea.setRect(this.tableContext.getDrawArea());
            this.clearClipping();
        }
    }

    @Override
    protected boolean startTableBox(TableRenderBox box) {
        this.tableContext = new TableContext(this.tableContext);
        return this.startBox(box);
    }

    @Override
    protected void finishTableBox(TableRenderBox box) {
        this.tableContext = this.tableContext.pop();
    }

    @Override
    protected boolean startTableColumnGroupBox(TableColumnGroupNode box) {
        return false;
    }

    @Override
    protected boolean startAutoBox(RenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        if (!box.isBoxVisible(this.drawArea)) {
            return false;
        }
        this.renderBoxBorderAndBackground(box);
        TextSpec textSpec = this.getTextSpec();
        if (textSpec != null) {
            textSpec.close();
            this.setTextSpec(null);
        }
        FontDecorationSpec newUnderlineSpec = this.computeUnderline(box, this.underline);
        if (this.underline != null && newUnderlineSpec == null) {
            this.drawTextDecoration(this.underline);
            this.underline = null;
        } else {
            this.underline = newUnderlineSpec;
        }
        FontDecorationSpec newStrikeThroughSpec = this.computeStrikeThrough(box, this.strikeThrough);
        if (this.strikeThrough != null && newStrikeThroughSpec == null) {
            this.drawTextDecoration(this.strikeThrough);
            this.strikeThrough = null;
        } else {
            this.strikeThrough = newStrikeThroughSpec;
        }
        this.processLinksAndAnchors(box);
        return true;
    }

    protected boolean isIgnoreBorderWhenDrawingOutline() {
        return false;
    }

    protected void renderBoxBorderAndBackground(RenderBox box) {
        Graphics2D g2 = this.getGraphics();
        if (this.isOutlineMode()) {
            this.drawOutlineBox(g2, box);
            if (this.isIgnoreBorderWhenDrawingOutline()) {
                return;
            }
        }
        if (!box.getBoxDefinition().getBorder().isEmpty()) {
            this.borderRenderer.paintBackgroundAndBorder(box, g2);
        } else {
            Color backgroundColor = (Color)box.getStyleSheet().getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR);
            if (backgroundColor != null) {
                double x = StrictGeomUtility.toExternalValue(box.getX());
                double y = StrictGeomUtility.toExternalValue(box.getY());
                double w = StrictGeomUtility.toExternalValue(box.getWidth());
                double h = StrictGeomUtility.toExternalValue(box.getHeight());
                this.boxArea.setFrame(x, y, w, h);
                g2.setColor(backgroundColor);
                g2.fill(this.boxArea);
            }
        }
    }

    protected Rectangle2D.Double getBoxArea() {
        return this.boxArea;
    }

    protected TextSpec getTextSpec() {
        return this.textSpec;
    }

    protected void setTextSpec(TextSpec textSpec) {
        this.textSpec = textSpec;
    }

    private FontDecorationSpec computeUnderline(RenderBox box, FontDecorationSpec oldSpec) {
        StyleSheet styleSheet = box.getStyleSheet();
        if (!styleSheet.getBooleanStyleProperty(TextStyleKeys.UNDERLINED)) {
            return null;
        }
        if (oldSpec == null) {
            oldSpec = new FontDecorationSpec();
        }
        double size = box.getStyleSheet().getDoubleStyleProperty(TextStyleKeys.FONTSIZE, 0.0);
        double lineWidth = Math.max(1.0, size / 20.0);
        oldSpec.updateLineWidth(lineWidth);
        oldSpec.setTextColor((Color)box.getStyleSheet().getStyleProperty(ElementStyleKeys.PAINT));
        return oldSpec;
    }

    private FontDecorationSpec computeStrikeThrough(RenderBox box, FontDecorationSpec oldSpec) {
        StyleSheet styleSheet = box.getStyleSheet();
        if (!styleSheet.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH)) {
            return null;
        }
        if (oldSpec == null) {
            oldSpec = new FontDecorationSpec();
        }
        double size = box.getStyleSheet().getDoubleStyleProperty(TextStyleKeys.FONTSIZE, 0.0);
        double lineWidth = Math.max(1.0, size / 20.0);
        oldSpec.updateLineWidth(lineWidth);
        oldSpec.setTextColor((Color)box.getStyleSheet().getStyleProperty(ElementStyleKeys.PAINT));
        return oldSpec;
    }

    private boolean isStyleActive(StyleKey key, RenderBox parent) {
        if ((parent.getLayoutNodeType() & 0x42) != 66) {
            return false;
        }
        return parent.getStyleSheet().getBooleanStyleProperty(key);
    }

    @Override
    protected void finishInlineBox(InlineRenderBox box) {
        TextSpec textSpec;
        RenderBox parent = box.getParent();
        if (this.underline != null) {
            if (!this.isStyleActive(TextStyleKeys.UNDERLINED, parent)) {
                this.drawTextDecoration(this.underline);
                this.underline = null;
            }
        } else {
            this.underline = this.computeUnderline(box, null);
        }
        if (this.strikeThrough != null) {
            if (!this.isStyleActive(TextStyleKeys.STRIKETHROUGH, parent)) {
                this.drawTextDecoration(this.strikeThrough);
                this.strikeThrough = null;
            }
        } else {
            this.underline = this.computeUnderline(box, null);
        }
        if ((textSpec = this.getTextSpec()) != null) {
            textSpec.close();
            this.setTextSpec(null);
        }
    }

    private void drawTextDecoration(FontDecorationSpec decorationSpec) {
        Graphics2D graphics = (Graphics2D)this.getGraphics().create();
        graphics.setColor(decorationSpec.getTextColor());
        graphics.setStroke(new BasicStroke((float)decorationSpec.getLineWidth()));
        graphics.draw(new Line2D.Double(decorationSpec.getStart(), decorationSpec.getVerticalPosition(), decorationSpec.getEnd(), decorationSpec.getVerticalPosition()));
        graphics.dispose();
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.contentAreaX1 = box.getContentAreaX1();
        this.contentAreaX2 = box.getContentAreaX2();
        this.textSpec = null;
        for (RenderBox lineBox = (RenderBox)box.getFirstChild(); lineBox != null; lineBox = (RenderBox)lineBox.getNext()) {
            this.processTextLine(lineBox, this.contentAreaX1, this.contentAreaX2);
        }
        if (this.textSpec != null) {
            throw new IllegalStateException();
        }
    }

    protected void processTextLine(RenderBox lineBox, long contentAreaX1, long contentAreaX2) {
        if (!lineBox.isNodeVisible(this.drawArea)) {
            return;
        }
        boolean overflowProperty = lineBox.getParent().getStaticBoxLayoutProperties().isOverflowX();
        this.textLineOverflow = lineBox.getX() + lineBox.getWidth() > contentAreaX2 && !overflowProperty;
        this.ellipseDrawn = false;
        if (this.textLineOverflow) {
            this.revalidateTextEllipseProcessStep.compute(lineBox, contentAreaX1, contentAreaX2);
        }
        this.underline = null;
        this.strikeThrough = null;
        this.startProcessing(lineBox);
    }

    public long getContentAreaX2() {
        return this.contentAreaX2;
    }

    public void setContentAreaX2(long contentAreaX2) {
        this.contentAreaX2 = contentAreaX2;
    }

    public long getContentAreaX1() {
        return this.contentAreaX1;
    }

    public void setContentAreaX1(long contentAreaX1) {
        this.contentAreaX1 = contentAreaX1;
    }

    public boolean isTextLineOverflow() {
        return this.textLineOverflow;
    }

    public void setTextLineOverflow(boolean textLineOverflow) {
        this.textLineOverflow = textLineOverflow;
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        RenderableComplexText text;
        long x1;
        if (!node.isNodeVisible(this.drawArea)) {
            return;
        }
        int type = node.getNodeType();
        if (this.isTextLineOverflow() && node.isVirtualNode() && !this.ellipseDrawn) {
            RenderBox textEllipseBox;
            long x12;
            RenderNode text2;
            if (!this.isClipOnWordBoundary() && type == 17) {
                text2 = (RenderableText)node;
                long ellipseSize = this.extractEllipseSize(node);
                long x13 = text2.getX();
                long effectiveAreaX2 = this.contentAreaX2 - ellipseSize;
                if (x13 < this.contentAreaX2) {
                    this.drawText((RenderableText)text2, effectiveAreaX2);
                }
            } else if (!this.isClipOnWordBoundary() && type == 273 && (x12 = (text2 = (RenderableComplexText)node).getX()) < this.contentAreaX2) {
                Graphics2D g2;
                if (this.getTextSpec() == null) {
                    g2 = (Graphics2D)this.getGraphics().create();
                    StyleSheet layoutContext = text2.getStyleSheet();
                    this.configureGraphics(layoutContext, g2);
                    g2.setStroke(DEFAULT_STROKE);
                    if (RenderUtility.isFontSmooth(layoutContext, this.metaData)) {
                        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    } else {
                        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                    }
                } else {
                    g2 = this.getTextSpec().getGraphics();
                }
                this.drawComplexText((RenderableComplexText)text2, g2);
            }
            this.ellipseDrawn = true;
            RenderBox parent = node.getParent();
            if (parent != null && (textEllipseBox = parent.getTextEllipseBox()) != null) {
                this.processBoxChilds(textEllipseBox);
            }
            return;
        }
        if (type == 17) {
            ExtendedBaselineInfo baselineInfo;
            RenderableText text3 = (RenderableText)node;
            if (this.underline != null) {
                baselineInfo = text3.getBaselineInfo();
                long underlinePos = text3.getY() + baselineInfo.getUnderlinePosition();
                this.underline.updateVerticalPosition(StrictGeomUtility.toExternalValue(underlinePos));
                this.underline.updateStart(StrictGeomUtility.toExternalValue(text3.getX()));
                this.underline.updateEnd(StrictGeomUtility.toExternalValue(text3.getX() + text3.getWidth()));
            }
            if (this.strikeThrough != null) {
                baselineInfo = text3.getBaselineInfo();
                long strikethroughPos = text3.getY() + baselineInfo.getStrikethroughPosition();
                this.strikeThrough.updateVerticalPosition(StrictGeomUtility.toExternalValue(strikethroughPos));
                this.strikeThrough.updateStart(StrictGeomUtility.toExternalValue(text3.getX()));
                this.strikeThrough.updateEnd(StrictGeomUtility.toExternalValue(text3.getX() + text3.getWidth()));
            }
            if (this.isTextLineOverflow()) {
                long effectiveAreaX2;
                long ellipseSize = this.extractEllipseSize(node);
                long x14 = text3.getX();
                long x2 = x14 + text3.getWidth();
                if (x2 <= (effectiveAreaX2 = this.contentAreaX2 - ellipseSize)) {
                    this.drawText(text3);
                } else {
                    RenderBox textEllipseBox;
                    if (x14 < this.contentAreaX2) {
                        this.drawText(text3, effectiveAreaX2);
                    }
                    RenderBox parent = node.getParent();
                    if (parent != null && (textEllipseBox = parent.getTextEllipseBox()) != null) {
                        this.processBoxChilds(textEllipseBox);
                    }
                    this.ellipseDrawn = true;
                }
            } else {
                this.drawText(text3);
            }
        } else if (type == 273 && (x1 = (text = (RenderableComplexText)node).getX()) < this.contentAreaX2) {
            Graphics2D g2;
            if (this.getTextSpec() == null) {
                g2 = (Graphics2D)this.getGraphics().create();
                StyleSheet layoutContext = text.getStyleSheet();
                this.configureGraphics(layoutContext, g2);
                g2.setStroke(DEFAULT_STROKE);
                if (RenderUtility.isFontSmooth(layoutContext, this.metaData)) {
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                } else {
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                }
            } else {
                g2 = this.getTextSpec().getGraphics();
            }
            this.drawComplexText(text, g2);
        }
    }

    @Override
    protected void processRenderableContent(RenderableReplacedContentBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return;
        }
        if (!box.isBoxVisible(this.drawArea)) {
            return;
        }
        this.renderBoxBorderAndBackground(box);
        this.processLinksAndAnchors(box);
        this.drawReplacedContent(box);
    }

    private long extractEllipseSize(RenderNode node) {
        if (node == null) {
            return 0L;
        }
        RenderBox parent = node.getParent();
        if (parent == null) {
            return 0L;
        }
        RenderBox textEllipseBox = parent.getTextEllipseBox();
        if (textEllipseBox == null) {
            return 0L;
        }
        return textEllipseBox.getWidth();
    }

    protected void drawReplacedContent(RenderableReplacedContentBox content) {
        Graphics2D g2 = this.getGraphics();
        Object o = content.getContent().getRawObject();
        if (o instanceof Image) {
            this.drawImage(content, (Image)o);
        } else if (o instanceof DrawableWrapper) {
            DrawableWrapper d = (DrawableWrapper)o;
            this.drawDrawable(content, g2, d);
        } else if (o instanceof LocalImageContainer) {
            LocalImageContainer imageContainer = (LocalImageContainer)o;
            Image image = imageContainer.getImage();
            this.drawImage(content, image);
        } else if (o instanceof URLImageContainer) {
            URLImageContainer imageContainer = (URLImageContainer)o;
            if (!imageContainer.isLoadable()) {
                logger.info((Object)"URL-image cannot be rendered, as it was declared to be not loadable.");
                return;
            }
            ResourceKey sourceURL = imageContainer.getResourceKey();
            if (sourceURL == null) {
                logger.info((Object)"URL-image cannot be rendered, as it did not return a valid URL.");
            }
            try {
                Resource resource = this.resourceManager.create(sourceURL, null, Image.class);
                Image image = (Image)resource.getResource();
                this.drawImage(content, image);
            }
            catch (ResourceException e) {
                logger.info((Object)"URL-image cannot be rendered, as the image was not loadable.", (Throwable)e);
            }
        } else {
            logger.debug((Object)("Unable to handle " + o));
        }
    }

    protected void drawAnchor(RenderNode content) {
    }

    protected boolean drawImage(RenderableReplacedContentBox content, Image image) {
        AffineTransform scaleTransform;
        Graphics2D g2;
        StyleSheet layoutContext = content.getStyleSheet();
        boolean shouldScale = layoutContext.getBooleanStyleProperty(ElementStyleKeys.SCALE);
        int x = (int)StrictGeomUtility.toExternalValue(content.getX());
        int y = (int)StrictGeomUtility.toExternalValue(content.getY());
        int width = (int)StrictGeomUtility.toExternalValue(content.getWidth());
        int height = (int)StrictGeomUtility.toExternalValue(content.getHeight());
        if (width == 0 || height == 0) {
            logger.debug((Object)("Error: Image area is empty: " + content));
            return false;
        }
        WaitingImageObserver obs = new WaitingImageObserver(image);
        obs.waitImageLoaded();
        int imageWidth = image.getWidth((ImageObserver)obs);
        int imageHeight = image.getHeight((ImageObserver)obs);
        if (imageWidth < 1 || imageHeight < 1) {
            return false;
        }
        Rectangle2D.Double drawAreaBounds = new Rectangle2D.Double(x, y, width, height);
        if (!shouldScale) {
            double deviceScaleFactor = 1.0;
            double devResolution = this.metaData.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION);
            if (this.metaData.isFeatureSupported(OutputProcessorFeature.IMAGE_RESOLUTION_MAPPING) && devResolution != 72.0 && devResolution > 0.0) {
                deviceScaleFactor = 72.0 / devResolution;
            }
            int clipWidth = Math.min(width, (int)Math.ceil(deviceScaleFactor * (double)imageWidth));
            int clipHeight = Math.min(height, (int)Math.ceil(deviceScaleFactor * (double)imageHeight));
            ElementAlignment horizontalAlignment = (ElementAlignment)layoutContext.getStyleProperty(ElementStyleKeys.ALIGNMENT);
            ElementAlignment verticalAlignment = (ElementAlignment)layoutContext.getStyleProperty(ElementStyleKeys.VALIGNMENT);
            int alignmentX = (int)RenderUtility.computeHorizontalAlignment(horizontalAlignment, width, clipWidth);
            int alignmentY = (int)RenderUtility.computeVerticalAlignment(verticalAlignment, height, clipHeight);
            g2 = (Graphics2D)this.getGraphics().create();
            g2.clip(drawAreaBounds);
            g2.translate(x, y);
            g2.translate(alignmentX, alignmentY);
            g2.clip(new Rectangle2D.Float(0.0f, 0.0f, clipWidth, clipHeight));
            g2.scale(deviceScaleFactor, deviceScaleFactor);
            scaleTransform = null;
        } else {
            double scaleY;
            double scaleX;
            g2 = (Graphics2D)this.getGraphics().create();
            g2.clip(drawAreaBounds);
            g2.translate(x, y);
            g2.clip(new Rectangle2D.Float(0.0f, 0.0f, width, height));
            boolean keepAspectRatio = layoutContext.getBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO);
            if (keepAspectRatio) {
                double scaleFactor;
                scaleX = scaleFactor = Math.min((double)width / (double)imageWidth, (double)height / (double)imageHeight);
                scaleY = scaleFactor;
            } else {
                scaleX = (double)width / (double)imageWidth;
                scaleY = (double)height / (double)imageHeight;
            }
            int clipWidth = (int)(scaleX * (double)imageWidth);
            int clipHeight = (int)(scaleY * (double)imageHeight);
            ElementAlignment horizontalAlignment = (ElementAlignment)layoutContext.getStyleProperty(ElementStyleKeys.ALIGNMENT);
            ElementAlignment verticalAlignment = (ElementAlignment)layoutContext.getStyleProperty(ElementStyleKeys.VALIGNMENT);
            int alignmentX = (int)RenderUtility.computeHorizontalAlignment(horizontalAlignment, width, clipWidth);
            int alignmentY = (int)RenderUtility.computeVerticalAlignment(verticalAlignment, height, clipHeight);
            g2.translate(alignmentX, alignmentY);
            Object contentCached = content.getContent().getContentCached();
            if (contentCached instanceof Image) {
                image = (Image)contentCached;
                scaleTransform = null;
            } else if (!this.metaData.isFeatureSupported(OutputProcessorFeature.PREFER_NATIVE_SCALING)) {
                image = RenderUtility.scaleImage(image, clipWidth, clipHeight, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
                content.getContent().setContentCached(image);
                obs = new WaitingImageObserver(image);
                obs.waitImageLoaded();
                scaleTransform = null;
            } else {
                scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
            }
        }
        while (!g2.drawImage(image, scaleTransform, (ImageObserver)obs)) {
            obs.waitImageLoaded();
            if (!obs.isError()) continue;
            logger.warn((Object)"Error while loading the image during the rendering.");
            break;
        }
        g2.dispose();
        return true;
    }

    protected boolean drawDrawable(RenderableReplacedContentBox content, Graphics2D g2, DrawableWrapper d) {
        double x = StrictGeomUtility.toExternalValue(content.getX());
        double y = StrictGeomUtility.toExternalValue(content.getY());
        double width = StrictGeomUtility.toExternalValue(content.getWidth());
        double height = StrictGeomUtility.toExternalValue(content.getHeight());
        if (width < 0.0 || height < 0.0 || width == 0.0 && height == 0.0) {
            return false;
        }
        Graphics2D clone = (Graphics2D)g2.create();
        StyleSheet styleSheet = content.getStyleSheet();
        Object attribute = styleSheet.getStyleProperty(ElementStyleKeys.ANTI_ALIASING);
        if (attribute != null) {
            if (Boolean.TRUE.equals(attribute)) {
                clone.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else if (Boolean.FALSE.equals(attribute)) {
                clone.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
        if (RenderUtility.isFontSmooth(styleSheet, this.metaData)) {
            clone.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            clone.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (!this.strictClipping) {
            double extraPadding;
            Object o = styleSheet.getStyleProperty(ElementStyleKeys.STROKE);
            if (o instanceof BasicStroke) {
                BasicStroke stroke = (BasicStroke)o;
                extraPadding = (double)stroke.getLineWidth() / 2.0;
            } else {
                extraPadding = 0.5;
            }
            Rectangle2D.Double clipBounds = new Rectangle2D.Double(x - extraPadding, y - extraPadding, width + 2.0 * extraPadding, height + 2.0 * extraPadding);
            clone.clip(clipBounds);
            clone.translate(x, y);
        } else {
            Rectangle2D.Double clipBounds = new Rectangle2D.Double(x, y, width + 1.0, height + 1.0);
            clone.clip(clipBounds);
            clone.translate(x, y);
        }
        this.configureGraphics(styleSheet, clone);
        this.configureStroke(styleSheet, clone);
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, width, height);
        d.draw(clone, (Rectangle2D)bounds);
        clone.dispose();
        return true;
    }

    protected void drawText(RenderableText renderableText) {
        this.drawText(renderableText, renderableText.getX() + renderableText.getWidth());
    }

    protected void drawText(RenderableText renderableText, long contentX2) {
        Graphics2D g2;
        if (renderableText.getLength() == 0) {
            return;
        }
        long posX = renderableText.getX();
        long posY = renderableText.getY();
        if (this.getTextSpec() == null) {
            g2 = (Graphics2D)this.getGraphics().create();
            StyleSheet layoutContext = renderableText.getStyleSheet();
            this.configureGraphics(layoutContext, g2);
            g2.setStroke(DEFAULT_STROKE);
            if (RenderUtility.isFontSmooth(layoutContext, this.metaData)) {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
        } else {
            g2 = this.getTextSpec().getGraphics();
        }
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D rect = fm.getMaxCharBounds(g2);
        long awtBaseLine = StrictGeomUtility.toInternalValue(-rect.getY());
        GlyphList gs = renderableText.getGlyphs();
        if (this.metaData.isFeatureSupported(OutputProcessorFeature.FAST_FONTRENDERING) && this.isNormalTextSpacing(renderableText)) {
            int maxLength = renderableText.computeMaximumTextSize(contentX2);
            String text = gs.getText(renderableText.getOffset(), maxLength, this.codePointBuffer);
            float y = (float)StrictGeomUtility.toExternalValue(posY + awtBaseLine);
            g2.drawString(text, (float)StrictGeomUtility.toExternalValue(posX), y);
        } else {
            ExtendedBaselineInfo baselineInfo = renderableText.getBaselineInfo();
            int maxPos = renderableText.getOffset() + renderableText.computeMaximumTextSize(contentX2);
            long runningPos = posX;
            long baseline = baselineInfo.getBaseline(baselineInfo.getDominantBaseline());
            long baselineDelta = awtBaseLine - baseline;
            float y = (float)StrictGeomUtility.toExternalValue(posY + awtBaseLine + baselineDelta);
            for (int i = renderableText.getOffset(); i < maxPos; ++i) {
                Glyph g = gs.getGlyph(i);
                g2.drawString(gs.getGlyphAsString(i, this.codePointBuffer), (float)StrictGeomUtility.toExternalValue(runningPos), y);
                runningPos += RenderableText.convert(g.getWidth()) + (long)g.getSpacing().getMinimum();
            }
        }
        g2.dispose();
    }

    protected void drawComplexText(RenderableComplexText renderableComplexText, Graphics2D g2) {
        long posX = renderableComplexText.getX();
        long posY = renderableComplexText.getY();
        float baseline = renderableComplexText.getParagraphFontMetrics().getAscent();
        float y = (float)StrictGeomUtility.toExternalValue(posY) + baseline;
        renderableComplexText.getTextLayout().draw(g2, (float)StrictGeomUtility.toExternalValue(posX), y);
        g2.dispose();
    }

    protected final CodePointBuffer getCodePointBuffer() {
        return this.codePointBuffer;
    }

    protected boolean isNormalTextSpacing(RenderableText text) {
        return text.isNormalTextSpacing();
    }

    protected void configureStroke(StyleSheet layoutContext, Graphics2D g2) {
        Stroke styleProperty = (Stroke)layoutContext.getStyleProperty(ElementStyleKeys.STROKE);
        if (styleProperty != null) {
            g2.setStroke(styleProperty);
        } else {
            g2.setStroke(DEFAULT_STROKE);
        }
    }

    protected void configureGraphics(StyleSheet layoutContext, Graphics2D g2) {
        boolean bold = layoutContext.getBooleanStyleProperty(TextStyleKeys.BOLD);
        boolean italics = layoutContext.getBooleanStyleProperty(TextStyleKeys.ITALIC);
        int style = 0;
        if (bold) {
            style |= 1;
        }
        if (italics) {
            style |= 2;
        }
        Color cssColor = (Color)layoutContext.getStyleProperty(ElementStyleKeys.PAINT);
        g2.setColor(cssColor);
        int fontSize = layoutContext.getIntStyleProperty(TextStyleKeys.FONTSIZE, (int)this.metaData.getNumericFeatureValue(OutputProcessorFeature.DEFAULT_FONT_SIZE));
        String fontName = this.metaData.getNormalizedFontFamilyName((String)layoutContext.getStyleProperty(TextStyleKeys.FONT));
        g2.setFont(new Font(fontName, style, fontSize));
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public void clip(StrictBounds bounds) {
        Graphics2D g = this.getGraphics();
        this.graphicsContexts.push((Object)g);
        this.graphics = (Graphics2D)g.create();
        this.graphics.clip(StrictGeomUtility.createAWTRectangle(bounds));
    }

    public void clearClipping() {
        this.graphics.dispose();
        this.graphics = (Graphics2D)this.graphicsContexts.pop();
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    @Override
    public RenderNode[] getNodesAt(double x, double y, String namespace, String name) {
        return this.collectSelectedNodesStep.getNodesAt(this.rootBox, StrictGeomUtility.createBounds(x, y, 1.0, 1.0), namespace, name);
    }

    @Override
    public RenderNode[] getNodesAt(double x, double y, double width, double height, String namespace, String name) {
        return this.collectSelectedNodesStep.getNodesAt(this.rootBox, StrictGeomUtility.createBounds(x, y, width, height), namespace, name);
    }

    private static class TableContext {
        private TableContext parent;
        private StrictBounds bounds;
        private StrictBounds drawArea;

        private TableContext(TableContext parent) {
            this.parent = parent;
            this.bounds = new StrictBounds();
            this.drawArea = new StrictBounds();
        }

        public StrictBounds getDrawArea() {
            return this.drawArea;
        }

        public StrictBounds getBounds() {
            return this.bounds;
        }

        public TableContext pop() {
            return this.parent;
        }
    }

    private static class FontDecorationSpec {
        private double end = -1.0;
        private double start = -1.0;
        private double verticalPosition;
        private double lineWidth;
        private Color textColor;

        protected FontDecorationSpec() {
        }

        public Color getTextColor() {
            return this.textColor;
        }

        public void setTextColor(Color textColor) {
            this.textColor = textColor;
        }

        public void updateStart(double start) {
            if (this.start < 0.0) {
                this.start = start;
            } else if (start < this.start) {
                this.start = start;
            }
        }

        public double getEnd() {
            return this.end;
        }

        public void updateEnd(double end) {
            if (this.end < 0.0) {
                this.end = end;
            } else if (end > this.end) {
                this.end = end;
            }
        }

        public double getStart() {
            return this.start;
        }

        public double getLineWidth() {
            return this.lineWidth;
        }

        public void updateLineWidth(double lineWidth) {
            if (lineWidth > this.lineWidth) {
                this.lineWidth = lineWidth;
            }
        }

        public void updateVerticalPosition(double verticalPosition) {
            if (verticalPosition > this.verticalPosition) {
                this.verticalPosition = verticalPosition;
            }
        }

        public double getVerticalPosition() {
            return this.verticalPosition;
        }
    }

    protected static class TextSpec {
        private boolean bold;
        private boolean italics;
        private String fontName;
        private float fontSize;
        private Graphics2D graphics;

        protected TextSpec(StyleSheet layoutContext, OutputProcessorMetaData metaData, Graphics2D graphics) {
            if (graphics == null) {
                throw new NullPointerException();
            }
            if (metaData == null) {
                throw new NullPointerException();
            }
            if (layoutContext == null) {
                throw new NullPointerException();
            }
            this.graphics = graphics;
            this.fontName = metaData.getNormalizedFontFamilyName((String)layoutContext.getStyleProperty(TextStyleKeys.FONT));
            this.fontSize = (float)layoutContext.getDoubleStyleProperty(TextStyleKeys.FONTSIZE, 10.0);
            this.bold = layoutContext.getBooleanStyleProperty(TextStyleKeys.BOLD);
            this.italics = layoutContext.getBooleanStyleProperty(TextStyleKeys.ITALIC);
        }

        public boolean isBold() {
            return this.bold;
        }

        public boolean isItalics() {
            return this.italics;
        }

        public String getFontName() {
            return this.fontName;
        }

        public float getFontSize() {
            return this.fontSize;
        }

        public Graphics2D getGraphics() {
            return this.graphics;
        }

        public void close() {
            this.graphics.dispose();
            this.graphics = null;
        }
    }
}

