/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.AbstractEpsonPrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterSpecificationManager;

public class Epson24PinPrinterDriver
extends AbstractEpsonPrinterDriver {
    private static final String SPECIFICATION_RESOURCE = "/org/pentaho/reporting/engine/classic/core/modules/output/pageable/plaintext/driver/epson-24pin-printer-specifications.properties";
    public static final String EPSON_24PIN_PRINTER_TYPE = "org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.epson.24PinPrinterType";
    private static final String N_360TH_LINE_SPACING = "Epson24pin.n360inch-linespacing";
    private static final String SELECT_LINE_SCORE = "Epson24pin.select-line-score";
    private static PrinterSpecificationManager printerSpecificationManager;

    public Epson24PinPrinterDriver(OutputStream out, float charsPerInch, float linesPerInch, String printerModel) {
        super(out, charsPerInch, linesPerInch, printerModel);
    }

    @Override
    protected void sendDefineLineSpacing(float lineHeightInPoints) throws IOException {
        OutputStream outputStream = this.getOut();
        if (this.getPrinterSpecification().isFeatureAvailable(N_360TH_LINE_SPACING)) {
            int spacePar = (int)(lineHeightInPoints * 5.0f);
            outputStream.write(27);
            outputStream.write(43);
            outputStream.write(spacePar);
        } else {
            int spacePar = (int)((double)lineHeightInPoints * 2.5);
            outputStream.write(27);
            outputStream.write(51);
            outputStream.write(spacePar);
        }
    }

    @Override
    protected void sendFontStyle(boolean bold, boolean italic, boolean underline, boolean strikeTrough) throws IOException {
        OutputStream out = this.getOut();
        AbstractEpsonPrinterDriver.DriverState driverState = this.getDriverState();
        if (driverState.isBold()) {
            if (!bold) {
                out.write(27);
                out.write(70);
            }
        } else if (bold) {
            out.write(27);
            out.write(69);
        }
        if (driverState.isItalic()) {
            if (!italic) {
                out.write(27);
                out.write(53);
            }
        } else if (italic) {
            out.write(27);
            out.write(52);
        }
        if (driverState.isUnderline()) {
            if (!underline) {
                out.write(27);
                out.write(45);
                out.write(0);
            }
        } else if (underline) {
            out.write(27);
            out.write(45);
            out.write(1);
        }
        driverState.setBold(bold);
        driverState.setItalic(italic);
        driverState.setUnderline(underline);
        if (this.getPrinterSpecification().isFeatureAvailable(SELECT_LINE_SCORE)) {
            if (driverState.isStrikethrough()) {
                if (!strikeTrough) {
                    out.write(27);
                    out.write(40);
                    out.write(45);
                    out.write(3);
                    out.write(0);
                    out.write(1);
                    out.write(2);
                    out.write(0);
                }
            } else if (strikeTrough) {
                out.write(27);
                out.write(40);
                out.write(45);
                out.write(3);
                out.write(0);
                out.write(1);
                out.write(2);
                out.write(1);
            }
            driverState.setStrikethrough(strikeTrough);
        } else {
            driverState.setStrikethrough(false);
        }
    }

    @Override
    protected PrinterSpecificationManager getPrinterSpecificationManager() {
        return Epson24PinPrinterDriver.loadSpecificationManager();
    }

    public static synchronized PrinterSpecificationManager loadSpecificationManager() {
        if (printerSpecificationManager == null) {
            printerSpecificationManager = new PrinterSpecificationManager();
            printerSpecificationManager.load(SPECIFICATION_RESOURCE);
        }
        return printerSpecificationManager;
    }

    public static String getDefaultPrinter() {
        return ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty(EPSON_24PIN_PRINTER_TYPE, "Generic 24-Pin printer");
    }
}

