/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls;

import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.AbstractReportProcessTask;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.StreamExcelOutputProcessor;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.NameGenerator;

public class StreamXExcelReportProcessTask
extends AbstractReportProcessTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.isValid()) {
            this.setError(new ReportProcessingException("Error: The task is not configured properly."));
            return;
        }
        this.setError(null);
        try {
            MasterReport masterReport = this.getReport();
            Configuration configuration = masterReport.getConfiguration();
            ContentLocation contentLocation = this.getBodyContentLocation();
            NameGenerator nameGenerator = this.getBodyNameGenerator();
            ContentItem contentItem = contentLocation.createItem(nameGenerator.generateName(null, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"));
            OutputStream outputStream = contentItem.getOutputStream();
            try {
                StreamExcelOutputProcessor outputProcessor = new StreamExcelOutputProcessor(configuration, outputStream, masterReport.getResourceManager());
                outputProcessor.setUseXlsxFormat(true);
                StreamReportProcessor streamReportProcessor = new StreamReportProcessor(masterReport, outputProcessor);
                try {
                    ReportProgressListener[] progressListeners = this.getReportProgressListeners();
                    for (int i = 0; i < progressListeners.length; ++i) {
                        ReportProgressListener listener = progressListeners[i];
                        streamReportProcessor.addReportProgressListener(listener);
                    }
                    streamReportProcessor.processReport();
                }
                finally {
                    streamReportProcessor.close();
                }
            }
            finally {
                outputStream.close();
            }
        }
        catch (Throwable e) {
            this.setError(e);
        }
    }

    @Override
    public String getReportMimeType() {
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    }
}

