/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers;

import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.NoDataBand;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.ItemBandType;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.NoDataBandType;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.GroupList;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.BandReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.GroupsReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.RootBandReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class ReportDescriptionReadHandler
extends AbstractPropertyXmlReadHandler {
    private GroupList groupList = new GroupList();

    @Override
    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        ReportDefinition report = (ReportDefinition)this.getRootHandler().getHelperObject("::Report");
        int groupCount = report.getGroupCount();
        for (int i = 0; i < groupCount; ++i) {
            Group g = report.getGroup(i);
            if (!(g instanceof RelationalGroup)) {
                throw new ParseException("The existing report contains non-default groups. This parser cannot handle such a construct.");
            }
            this.groupList.add((RelationalGroup)g);
        }
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        ReportDefinition report = (ReportDefinition)this.getRootHandler().getHelperObject("::Report");
        if ("report-header".equals(tagName)) {
            return new RootBandReadHandler(report.getReportHeader());
        }
        if ("report-footer".equals(tagName)) {
            return new RootBandReadHandler(report.getReportFooter());
        }
        if ("page-header".equals(tagName)) {
            return new BandReadHandler(report.getPageHeader());
        }
        if ("page-footer".equals(tagName)) {
            return new BandReadHandler(report.getPageFooter());
        }
        if ("watermark".equals(tagName)) {
            return new BandReadHandler(report.getWatermark());
        }
        if ("no-data-band".equals(tagName)) {
            NoDataBand noDataBand = (NoDataBand)report.getChildElementByType(NoDataBandType.INSTANCE);
            if (noDataBand == null) {
                throw new ParseException("Not a relational report");
            }
            return new RootBandReadHandler(noDataBand);
        }
        if ("groups".equals(tagName)) {
            return new GroupsReadHandler(this.groupList);
        }
        if ("itemband".equals(tagName)) {
            ItemBand itemBand = (ItemBand)report.getChildElementByType(ItemBandType.INSTANCE);
            if (itemBand == null) {
                throw new ParseException("Not a relational report");
            }
            return new RootBandReadHandler(itemBand);
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        AbstractReportDefinition report = (AbstractReportDefinition)this.getRootHandler().getHelperObject("::Report");
        try {
            GroupList clone = (GroupList)this.groupList.clone();
            clone.installIntoReport(report);
        }
        catch (CloneNotSupportedException e) {
            throw new ParseException("Failed to add group-list to report", this.getLocator());
        }
    }

    public Object getObject() {
        return null;
    }
}

