/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import java.awt.Component;
import java.awt.Image;
import java.awt.Shape;
import java.io.File;
import java.net.URL;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.filter.types.AbstractElementType;
import org.pentaho.reporting.engine.classic.core.filter.types.ContentFieldType;
import org.pentaho.reporting.engine.classic.core.filter.types.DateFieldType;
import org.pentaho.reporting.engine.classic.core.filter.types.LabelType;
import org.pentaho.reporting.engine.classic.core.filter.types.NumberFieldType;
import org.pentaho.reporting.engine.classic.core.filter.types.TextFieldType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.libraries.formatting.FastMessageFormat;

public class AutoGeneratorUtility {
    private AutoGeneratorUtility() {
    }

    public static Group[] getGroups(ReportDefinition definition) {
        int groupCount = definition.getGroupCount();
        Group[] groups = new Group[groupCount];
        for (int i = 0; i < groupCount; ++i) {
            Group group;
            groups[i] = group = definition.getGroup(i);
        }
        return groups;
    }

    public static String generateUniqueExpressionName(DataSchema dataSchema, String pattern, String[] extraColumns) throws ReportProcessingException {
        FastMessageFormat fastMessageFormat = new FastMessageFormat(pattern);
        if (fastMessageFormat.getSubFormatCount() == 0) {
            throw new IllegalArgumentException();
        }
        HashSet<String> names = new HashSet<String>(Arrays.asList(dataSchema.getNames()));
        for (int i = 0; i < extraColumns.length; ++i) {
            names.add(extraColumns[i]);
        }
        Object[] data = new Object[1];
        for (int i = 0; i < Short.MAX_VALUE; ++i) {
            data[0] = IntegerCache.getInteger(i);
            String s = fastMessageFormat.format((Object)data);
            if (names.contains(s)) continue;
            return s;
        }
        throw new ReportProcessingException("Unable to create a unique name for the given pattern");
    }

    public static String generateUniqueExpressionName(DataSchema dataSchema, String pattern, AbstractReportDefinition extraColumns) throws ReportProcessingException {
        FastMessageFormat fastMessageFormat = new FastMessageFormat(pattern);
        if (fastMessageFormat.getSubFormatCount() == 0) {
            throw new IllegalArgumentException();
        }
        HashSet<String> names = new HashSet<String>(Arrays.asList(dataSchema.getNames()));
        Expression[] expressions = extraColumns.getExpressions().getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            Expression expression = expressions[i];
            names.add(expression.getName());
        }
        Object[] data = new Object[1];
        for (int i = 0; i < Short.MAX_VALUE; ++i) {
            data[0] = IntegerCache.getInteger(i);
            String s = fastMessageFormat.format((Object)data);
            if (names.contains(s)) continue;
            return s;
        }
        throw new ReportProcessingException("Unable to create a unique name for the given pattern");
    }

    public static float[] computeFieldWidths(Float[] fieldDescriptions, float pageWidth) {
        float[] resultWidths = new float[fieldDescriptions.length];
        float definedWidth = 0.0f;
        int definedNumberOfFields = 0;
        for (int i = 0; i < fieldDescriptions.length; ++i) {
            float relativeValue;
            Float number = fieldDescriptions[i];
            if (number == null || ((Number)number).floatValue() == 0.0f) continue;
            if (((Number)number).floatValue() < 0.0f) {
                resultWidths[i] = ((Number)number).floatValue();
                ++definedNumberOfFields;
                definedWidth += ((Number)number).floatValue();
                continue;
            }
            float absValue = ((Number)number).floatValue();
            resultWidths[i] = relativeValue = -absValue * 100.0f / pageWidth;
            ++definedNumberOfFields;
            definedWidth += relativeValue;
        }
        if (definedNumberOfFields == fieldDescriptions.length) {
            return resultWidths;
        }
        if (definedNumberOfFields == 0) {
            Arrays.fill(resultWidths, (float)(-(100 / fieldDescriptions.length)));
            return resultWidths;
        }
        float availableSpace = -100.0f - definedWidth;
        if (availableSpace > 0.0f) {
            return resultWidths;
        }
        float avgSpace = availableSpace / (float)(fieldDescriptions.length - definedNumberOfFields);
        for (int i = 0; i < resultWidths.length; ++i) {
            float width = resultWidths[i];
            if (width != 0.0f) continue;
            resultWidths[i] = avgSpace;
        }
        return resultWidths;
    }

    public static Element generateFooterElement(Class aggregationType, ElementType targetType, String group, String fieldName) {
        if (aggregationType == null) {
            Element footerValueElement = new Element();
            footerValueElement.setElementType(new LabelType());
            footerValueElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", "");
            footerValueElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling", Boolean.TRUE);
            footerValueElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes", Boolean.FALSE);
            return footerValueElement;
        }
        Element element = AutoGeneratorUtility.generateDetailsElement(fieldName, targetType);
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "aggregation-type", aggregationType);
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "aggregation-group", group);
        return element;
    }

    public static Element generateHeaderElement(String fieldName) {
        Element headerElement = new Element();
        headerElement.getStyle().setStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT, Boolean.TRUE);
        headerElement.setElementType(new LabelType());
        headerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for", fieldName);
        headerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling", Boolean.TRUE);
        headerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes", Boolean.TRUE);
        return headerElement;
    }

    public static Element generateDetailsElement(String fieldName, ElementType targetType) {
        Element detailsElement = new Element();
        detailsElement.getStyle().setStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT, Boolean.TRUE);
        detailsElement.setElementType(targetType);
        detailsElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field", fieldName);
        detailsElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling", Boolean.TRUE);
        detailsElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes", Boolean.TRUE);
        return detailsElement;
    }

    public static Number createFieldWidth(DataAttributes attributes, DataAttributeContext context) {
        return (Number)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting", "display-size", Number.class, context);
    }

    public static String createFieldName(DataAttributes attributes, DataAttributeContext context) {
        return (String)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "name", String.class, context);
    }

    public static ElementType createFieldType(DataAttributes attributes, DataAttributeContext context) {
        if (attributes == null) {
            return new TextFieldType();
        }
        Class type = (Class)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "value-type", Class.class, context);
        return AutoGeneratorUtility.createFieldType(type);
    }

    public static ElementType createFieldType(Class type) {
        AbstractElementType elementType = Number.class.isAssignableFrom(type) ? new NumberFieldType() : (java.util.Date.class.isAssignableFrom(type) ? new DateFieldType() : (byte[].class.isAssignableFrom(type) || Blob.class.isAssignableFrom(type) || File.class.isAssignableFrom(type) || URL.class.isAssignableFrom(type) || Image.class.isAssignableFrom(type) || Shape.class.isAssignableFrom(type) || Component.class.isAssignableFrom(type) || ImageContainer.class.isAssignableFrom(type) ? new ContentFieldType() : new TextFieldType()));
        return elementType;
    }

    public static String computeFormatString(DataAttributes attributes, DataAttributeContext context) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        Class type = (Class)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "value-type", Class.class, context);
        Boolean currency = (Boolean)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric", "currency", Boolean.class, context);
        Number scale = (Number)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric", "scale", Number.class, context);
        Number precision = (Number)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric", "precision", Number.class, context);
        if (Date.class.isAssignableFrom(type)) {
            DateFormat dateFormat = DateFormat.getDateInstance(2, context.getLocale());
            if (dateFormat instanceof SimpleDateFormat) {
                SimpleDateFormat sdf = (SimpleDateFormat)dateFormat;
                return sdf.toPattern();
            }
            return null;
        }
        if (Time.class.isAssignableFrom(type)) {
            DateFormat dateFormat = DateFormat.getTimeInstance(2, context.getLocale());
            if (dateFormat instanceof SimpleDateFormat) {
                SimpleDateFormat sdf = (SimpleDateFormat)dateFormat;
                return sdf.toPattern();
            }
            return null;
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, context.getLocale());
            if (dateFormat instanceof SimpleDateFormat) {
                SimpleDateFormat sdf = (SimpleDateFormat)dateFormat;
                return sdf.toPattern();
            }
            return null;
        }
        if (Number.class.isAssignableFrom(type)) {
            NumberFormat format;
            if (Boolean.TRUE.equals(currency) && (format = NumberFormat.getCurrencyInstance(context.getLocale())) instanceof DecimalFormat) {
                DecimalFormat decimalFormat = (DecimalFormat)format;
                return decimalFormat.toPattern();
            }
            format = new DecimalFormat();
            if (scale != null && precision != null) {
                ((DecimalFormat)format).setMaximumFractionDigits(scale.intValue());
                ((DecimalFormat)format).setMinimumFractionDigits(scale.intValue());
                ((DecimalFormat)format).setMaximumIntegerDigits(precision.intValue() - scale.intValue());
                ((DecimalFormat)format).setMinimumIntegerDigits(1);
            }
            return ((DecimalFormat)format).toPattern();
        }
        return null;
    }

    public static boolean isIgnorable(DataAttributes attributes, DataAttributeContext context) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        String source = (String)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "source", String.class, context);
        if ("environment".equals(source)) {
            return true;
        }
        if ("expression".equals(source)) {
            ExpressionMetaData data;
            Class expressionType = (Class)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/expressions", "class", Class.class, context);
            if (expressionType == null) {
                return false;
            }
            return ExpressionRegistry.getInstance().isExpressionRegistered(expressionType.getClass().getName()) && ((data = ExpressionRegistry.getInstance().getExpressionMetaData(expressionType.getName())).isElementLayoutProcessor() || data.isGlobalLayoutProcessor());
        }
        if ("parameter".equals(source)) {
            Boolean include = (Boolean)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/parameters", "include-in-wizard", Boolean.class, context);
            return !Boolean.TRUE.equals(include);
        }
        Object indexColumn = attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "indexed-column", Boolean.class, context);
        return Boolean.TRUE.equals(indexColumn);
    }

    public static Band findGeneratedContent(Band band) {
        Band generatedContentInternal = AutoGeneratorUtility.findGeneratedContentInternal(band);
        if (generatedContentInternal != null) {
            generatedContentInternal.clear();
            return generatedContentInternal;
        }
        if (band.getElementCount() == 0) {
            return band;
        }
        return null;
    }

    private static Band findGeneratedContentInternal(Band band) {
        if (Boolean.TRUE.equals(band.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "generated-content-marker"))) {
            return band;
        }
        Element[] elements = band.getElementArray();
        for (int i = 0; i < elements.length; ++i) {
            Band retval;
            Element element = elements[i];
            if (!(element instanceof Band) || (retval = AutoGeneratorUtility.findGeneratedContentInternal((Band)element)) == null) continue;
            return retval;
        }
        return null;
    }
}

