/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngine;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionInfoXCommand;
import org.apache.oozie.command.coord.CoordChangeXCommand;
import org.apache.oozie.command.coord.CoordJobXCommand;
import org.apache.oozie.command.coord.CoordJobsXCommand;
import org.apache.oozie.command.coord.CoordKillXCommand;
import org.apache.oozie.command.coord.CoordRerunXCommand;
import org.apache.oozie.command.coord.CoordResumeXCommand;
import org.apache.oozie.command.coord.CoordSubmitXCommand;
import org.apache.oozie.command.coord.CoordSuspendXCommand;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogStreamingService;
import org.apache.oozie.util.CoordActionsInDateRange;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogStreamer;

public class CoordinatorEngine
extends BaseEngine {
    private static XLog LOG = XLog.getLog(CoordinatorEngine.class);
    private static final Set<String> FILTER_NAMES = new HashSet<String>();

    public CoordinatorEngine() {
        if (!Services.get().getConf().getBoolean("oozie.useXCommand", true)) {
            LOG.debug("Oozie CoordinatorEngine is not using XCommands.");
        } else {
            LOG.debug("Oozie CoordinatorEngine is using XCommands.");
        }
    }

    public CoordinatorEngine(String user) {
        this();
        this.user = ParamChecker.notEmpty(user, "user");
    }

    @Override
    public String getDefinition(String jobId) throws BaseEngineException {
        CoordinatorJobBean job = this.getCoordJobWithNoActionInfo(jobId);
        return job.getOrigJobXml();
    }

    private CoordinatorJobBean getCoordJobWithNoActionInfo(String jobId) throws BaseEngineException {
        try {
            return (CoordinatorJobBean)new CoordJobXCommand(jobId).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    public CoordinatorActionBean getCoordAction(String actionId) throws BaseEngineException {
        try {
            return (CoordinatorActionBean)new CoordActionInfoXCommand(actionId).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public CoordinatorJobBean getCoordJob(String jobId) throws BaseEngineException {
        try {
            return (CoordinatorJobBean)new CoordJobXCommand(jobId).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public CoordinatorJobBean getCoordJob(String jobId, String filter, int start, int length, boolean desc) throws BaseEngineException {
        List<String> filterList = this.parseStatusFilter(filter);
        try {
            return (CoordinatorJobBean)new CoordJobXCommand(jobId, filterList, start, length, desc).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public String getJobIdForExternalId(String externalId) throws CoordinatorEngineException {
        return null;
    }

    @Override
    public void kill(String jobId) throws CoordinatorEngineException {
        try {
            new CoordKillXCommand(jobId).call();
            LOG.info("User " + this.user + " killed the Coordinator job " + jobId);
        }
        catch (CommandException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    @Override
    public void change(String jobId, String changeValue) throws CoordinatorEngineException {
        try {
            new CoordChangeXCommand(jobId, changeValue).call();
            LOG.info("User " + this.user + " changed the Coordinator job " + jobId + " to " + changeValue);
        }
        catch (CommandException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    @Override
    @Deprecated
    public void reRun(String jobId, Configuration conf) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, "invalid use of rerun"));
    }

    public CoordinatorActionInfo reRun(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup) throws BaseEngineException {
        try {
            return (CoordinatorActionInfo)new CoordRerunXCommand(jobId, rerunType, scope, refresh, noCleanup).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public void resume(String jobId) throws CoordinatorEngineException {
        try {
            new CoordResumeXCommand(jobId).call();
        }
        catch (CommandException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    @Override
    @Deprecated
    public void start(String jobId) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, "invalid use of start"));
    }

    @Override
    public void streamLog(String jobId, Writer writer, Map<String, String[]> params) throws IOException, BaseEngineException {
        XLogStreamer.Filter filter = new XLogStreamer.Filter();
        filter.setParameter("JOB", jobId);
        CoordinatorJobBean job = this.getCoordJobWithNoActionInfo(jobId);
        Services.get().get(XLogStreamingService.class).streamLog(filter, job.getCreatedTime(), new Date(), writer, params);
    }

    public void streamLog(String jobId, String logRetrievalScope, String logRetrievalType, Writer writer, Map<String, String[]> params) throws IOException, BaseEngineException, CommandException {
        XLogStreamer.Filter filter = new XLogStreamer.Filter();
        filter.setParameter("JOB", jobId);
        if (logRetrievalScope != null && logRetrievalType != null) {
            if (logRetrievalType.equals("action")) {
                String[] list;
                LinkedHashSet<String> actionSet = new LinkedHashSet<String>();
                for (String s : list = logRetrievalScope.split(",")) {
                    if ((s = s.trim()).contains("-")) {
                        int end;
                        int start;
                        String[] range = s.split("-");
                        if (range.length != 2) {
                            throw new CommandException(ErrorCode.E0302, "format is wrong for action's range '" + s + "'");
                        }
                        try {
                            start = Integer.parseInt(range[0].trim());
                        }
                        catch (NumberFormatException ne) {
                            throw new CommandException(ErrorCode.E0302, "could not parse " + range[0].trim() + "into an integer", ne);
                        }
                        try {
                            end = Integer.parseInt(range[1].trim());
                        }
                        catch (NumberFormatException ne) {
                            throw new CommandException(ErrorCode.E0302, "could not parse " + range[1].trim() + "into an integer", ne);
                        }
                        if (start > end) {
                            throw new CommandException(ErrorCode.E0302, "format is wrong for action's range '" + s + "'");
                        }
                        for (int i = start; i <= end; ++i) {
                            actionSet.add(jobId + "@" + i);
                        }
                        continue;
                    }
                    try {
                        Integer.parseInt(s);
                    }
                    catch (NumberFormatException ne) {
                        throw new CommandException(ErrorCode.E0302, "format is wrong for action id'" + s + "'. Integer only.");
                    }
                    actionSet.add(jobId + "@" + s);
                }
                Iterator actionsIterator = actionSet.iterator();
                StringBuilder orSeparatedActions = new StringBuilder("");
                boolean orRequired = false;
                while (actionsIterator.hasNext()) {
                    if (orRequired) {
                        orSeparatedActions.append("|");
                    }
                    orSeparatedActions.append(((String)actionsIterator.next()).toString());
                    orRequired = true;
                }
                if (actionSet.size() > 1 && orRequired) {
                    orSeparatedActions.insert(0, "(");
                    orSeparatedActions.append(")");
                }
                filter.setParameter("ACTION", orSeparatedActions.toString());
            }
            if (logRetrievalType.equalsIgnoreCase("date")) {
                List<String> coordActionIdList = null;
                try {
                    coordActionIdList = CoordActionsInDateRange.getCoordActionIdsFromDates(jobId, logRetrievalScope);
                }
                catch (XException xe) {
                    throw new CommandException(ErrorCode.E0302, "Error in date range for coordinator actions", xe);
                }
                StringBuilder orSeparatedActions = new StringBuilder("");
                boolean orRequired = false;
                for (String coordActionId : coordActionIdList) {
                    if (orRequired) {
                        orSeparatedActions.append("|");
                    }
                    orSeparatedActions.append(coordActionId);
                    orRequired = true;
                }
                if (coordActionIdList.size() > 1 && orRequired) {
                    orSeparatedActions.insert(0, "(");
                    orSeparatedActions.append(")");
                }
                filter.setParameter("ACTION", orSeparatedActions.toString());
            }
        }
        CoordinatorJobBean job = this.getCoordJobWithNoActionInfo(jobId);
        Services.get().get(XLogStreamingService.class).streamLog(filter, job.getCreatedTime(), new Date(), writer, params);
    }

    @Override
    public String submitJob(Configuration conf, boolean startJob) throws CoordinatorEngineException {
        try {
            CoordSubmitXCommand submit = new CoordSubmitXCommand(conf);
            return (String)submit.call();
        }
        catch (CommandException ex) {
            throw new CoordinatorEngineException(ex);
        }
    }

    @Override
    public String dryRunSubmit(Configuration conf) throws CoordinatorEngineException {
        try {
            CoordSubmitXCommand submit = new CoordSubmitXCommand(true, conf);
            return (String)submit.call();
        }
        catch (CommandException ex) {
            throw new CoordinatorEngineException(ex);
        }
    }

    @Override
    public void suspend(String jobId) throws CoordinatorEngineException {
        try {
            new CoordSuspendXCommand(jobId).call();
        }
        catch (CommandException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    @Override
    public WorkflowJob getJob(String jobId) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, "cannot get a workflow job from CoordinatorEngine"));
    }

    @Override
    public WorkflowJob getJob(String jobId, int start, int length) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, "cannot get a workflow job from CoordinatorEngine"));
    }

    public CoordinatorJobInfo getCoordJobs(String filter, int start, int len) throws CoordinatorEngineException {
        Map<String, List<String>> filterList = this.parseFilter(filter);
        try {
            return (CoordinatorJobInfo)new CoordJobsXCommand(filterList, start, len).call();
        }
        catch (CommandException ex) {
            throw new CoordinatorEngineException(ex);
        }
    }

    private List<String> parseStatusFilter(String filter) throws CoordinatorEngineException {
        ArrayList<String> filterList = new ArrayList<String>();
        if (filter != null) {
            StringTokenizer st = new StringTokenizer(filter, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.contains("=")) {
                    String[] pair = token.split("=");
                    if (pair.length != 2) {
                        throw new CoordinatorEngineException(ErrorCode.E0421, token, "elements must be name=value pairs");
                    }
                    if (pair[0].equalsIgnoreCase("status")) {
                        String statusValue = pair[1];
                        try {
                            CoordinatorAction.Status.valueOf((String)statusValue);
                        }
                        catch (IllegalArgumentException ex) {
                            StringBuilder validStatusList = new StringBuilder();
                            for (CoordinatorAction.Status status : CoordinatorAction.Status.values()) {
                                validStatusList.append(status.toString() + " ");
                            }
                            throw new CoordinatorEngineException(ErrorCode.E0421, filter, XLog.format("invalid status value [{0}]. Valid status values are: [{1}]", statusValue, validStatusList));
                        }
                        filterList.add(statusValue);
                        continue;
                    }
                    throw new CoordinatorEngineException(ErrorCode.E0421, filter, XLog.format("invalid filter [{0}]. The only valid filter is \"status\"", pair[0]));
                }
                throw new CoordinatorEngineException(ErrorCode.E0421, token, "elements must be name=value pairs");
            }
        }
        return filterList;
    }

    @VisibleForTesting
    Map<String, List<String>> parseFilter(String filter) throws CoordinatorEngineException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        boolean isTimeUnitSpecified = false;
        String timeUnit = "MINUTE";
        boolean isFrequencySpecified = false;
        String frequency = "";
        if (filter != null) {
            StringTokenizer st = new StringTokenizer(filter, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.contains("=")) {
                    ArrayList<String> list;
                    String[] pair = token.split("=");
                    if (pair.length != 2) {
                        throw new CoordinatorEngineException(ErrorCode.E0420, filter, "elements must be name=value pairs");
                    }
                    if (!FILTER_NAMES.contains(pair[0].toLowerCase())) {
                        throw new CoordinatorEngineException(ErrorCode.E0420, filter, XLog.format("invalid name [{0}]", pair[0]));
                    }
                    if (pair[0].equalsIgnoreCase("frequency")) {
                        isFrequencySpecified = true;
                        try {
                            frequency = (int)Float.parseFloat(pair[1]) + "";
                            continue;
                        }
                        catch (NumberFormatException NANException) {
                            throw new CoordinatorEngineException(ErrorCode.E0420, filter, XLog.format("invalid value [{0}] for frequency. A numerical value is expected", pair[1]));
                        }
                    }
                    if (pair[0].equalsIgnoreCase("unit")) {
                        isTimeUnitSpecified = true;
                        timeUnit = pair[1];
                        if (timeUnit.equalsIgnoreCase("months") || timeUnit.equalsIgnoreCase("days") || timeUnit.equalsIgnoreCase("hours") || timeUnit.equalsIgnoreCase("minutes")) continue;
                        throw new CoordinatorEngineException(ErrorCode.E0420, filter, XLog.format("invalid value [{0}] for time unit. Valid value is one of months, days, hours or minutes", pair[1]));
                    }
                    if (pair[0].equals("status")) {
                        try {
                            Job.Status.valueOf((String)pair[1]);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new CoordinatorEngineException(ErrorCode.E0420, filter, XLog.format("invalid status [{0}]", pair[1]));
                        }
                    }
                    if ((list = (ArrayList<String>)map.get(pair[0])) == null) {
                        list = new ArrayList<String>();
                        map.put(pair[0], list);
                    }
                    list.add(pair[1]);
                    continue;
                }
                throw new CoordinatorEngineException(ErrorCode.E0420, filter, "elements must be name=value pairs");
            }
            if (!isFrequencySpecified && isTimeUnitSpecified) {
                throw new CoordinatorEngineException(ErrorCode.E0420, filter, "time unit should be added only when frequency is specified. Either specify frequency also or else remove the time unit");
            }
            if (isFrequencySpecified) {
                if (isTimeUnitSpecified) {
                    if (timeUnit.equalsIgnoreCase("months")) {
                        timeUnit = "MONTH";
                    } else if (timeUnit.equalsIgnoreCase("days")) {
                        timeUnit = "DAY";
                    } else if (timeUnit.equalsIgnoreCase("hours")) {
                        frequency = Integer.parseInt(frequency) * 60 + "";
                        timeUnit = "MINUTE";
                    } else if (timeUnit.equalsIgnoreCase("minutes")) {
                        timeUnit = "MINUTE";
                    }
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(timeUnit);
                map.put("unit", list);
                list = new ArrayList();
                list.add(frequency);
                map.put("frequency", list);
            }
        }
        return map;
    }

    static {
        FILTER_NAMES.add("user");
        FILTER_NAMES.add("name");
        FILTER_NAMES.add("group");
        FILTER_NAMES.add("status");
        FILTER_NAMES.add("id");
        FILTER_NAMES.add("frequency");
        FILTER_NAMES.add("unit");
    }
}

