/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.oozie.action.hadoop.LauncherMapper;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.service.UserGroupInformationService;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.PropertiesUtils;

public class LauncherMapperHelper {
    public static String getRecoveryId(Configuration launcherConf, Path actionDir, String recoveryId) throws HadoopAccessorException, IOException {
        String jobId = null;
        Path recoveryFile = new Path(actionDir, recoveryId);
        FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(launcherConf.get("user.name"), recoveryFile.toUri(), launcherConf);
        if (fs.exists(recoveryFile)) {
            FSDataInputStream is = fs.open(recoveryFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            jobId = reader.readLine();
            reader.close();
        }
        return jobId;
    }

    public static void setupMainClass(Configuration launcherConf, String javaMainClass) {
        if (javaMainClass != null && !javaMainClass.equals("")) {
            launcherConf.set("oozie.launcher.action.main.class", javaMainClass);
        }
    }

    public static void setupLauncherURIHandlerConf(Configuration launcherConf) {
        for (Map.Entry entry : Services.get().get(URIHandlerService.class).getLauncherConfig()) {
            launcherConf.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void setupMainArguments(Configuration launcherConf, String[] args) {
        launcherConf.setInt("oozie.action.main.arg.count", args.length);
        for (int i = 0; i < args.length; ++i) {
            launcherConf.set("oozie.action.main.arg." + i, args[i]);
        }
    }

    public static void setupMaxOutputData(Configuration launcherConf, int maxOutputData) {
        launcherConf.setInt("oozie.action.max.output.data", maxOutputData);
    }

    public static void setupMaxExternalStatsSize(Configuration launcherConf, int maxStatsData) {
        launcherConf.setInt("oozie.external.stats.max.size", maxStatsData);
    }

    public static void setupLauncherInfo(JobConf launcherConf, String jobId, String actionId, Path actionDir, String recoveryId, Configuration actionConf, String prepareXML) throws IOException, HadoopAccessorException {
        launcherConf.setMapperClass(LauncherMapper.class);
        launcherConf.setSpeculativeExecution(false);
        launcherConf.setNumMapTasks(1);
        launcherConf.setNumReduceTasks(0);
        launcherConf.set("oozie.job.id", jobId);
        launcherConf.set("oozie.action.id", actionId);
        launcherConf.set("oozie.action.dir.path", actionDir.toString());
        launcherConf.set("oozie.action.recovery.id", recoveryId);
        launcherConf.set("oozie.action.prepare.xml", prepareXML);
        actionConf.set("oozie.job.id", jobId);
        actionConf.set("oozie.action.id", actionId);
        if (Services.get().getConf().getBoolean("oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache", false)) {
            ArrayList<String> purgedEntries = new ArrayList<String>();
            Collection entries = actionConf.getStringCollection("mapreduce.job.cache.files");
            for (String entry : entries) {
                if (!entry.contains("#")) continue;
                purgedEntries.add(entry);
            }
            actionConf.setStrings("mapreduce.job.cache.files", purgedEntries.toArray(new String[purgedEntries.size()]));
            launcherConf.setBoolean("oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache", true);
        }
        FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(launcherConf.get("user.name"), actionDir.toUri(), (Configuration)launcherConf);
        fs.mkdirs(actionDir);
        FSDataOutputStream os = fs.create(new Path(actionDir, "action.xml"));
        actionConf.writeXml((OutputStream)os);
        os.close();
        Path inputDir = new Path(actionDir, "input");
        fs.mkdirs(inputDir);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "dummy.txt")));
        writer.write("dummy");
        ((Writer)writer).close();
        launcherConf.set("mapred.input.dir", inputDir.toString());
        launcherConf.set("mapred.output.dir", new Path(actionDir, "output").toString());
    }

    public static void setupYarnRestartHandling(JobConf launcherJobConf, Configuration actionConf, String actionId, int rerunCount) throws NoSuchAlgorithmException {
        launcherJobConf.setLong("oozie.job.launch.time", System.currentTimeMillis());
        String tag = LauncherMapperHelper.getTag(actionId, rerunCount);
        actionConf.set("mapreduce.job.tags", tag);
    }

    private static String getTag(String actionId, Integer rerunCount) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(actionId.getBytes(), 0, actionId.length());
        String retryStr = rerunCount.toString();
        digest.update(retryStr.getBytes(), 0, retryStr.length());
        String md5 = "oozie-" + new BigInteger(1, digest.digest()).toString(16);
        return md5;
    }

    public static boolean isMainDone(RunningJob runningJob) throws IOException {
        return runningJob.isComplete();
    }

    public static boolean isMainSuccessful(RunningJob runningJob) throws IOException {
        Counters.Group group;
        Counters counters;
        boolean succeeded = runningJob.isSuccessful();
        if (succeeded && (counters = runningJob.getCounters()) != null && (group = counters.getGroup("oozie.launcher")) != null) {
            succeeded = group.getCounter("oozie.launcher.error") == 0L;
        }
        return succeeded;
    }

    public static boolean hasExternalChildJobs(Map<String, String> actionData) throws IOException {
        return actionData.containsKey("externalChildIDs");
    }

    public static boolean hasOutputData(Map<String, String> actionData) throws IOException {
        return actionData.containsKey("output.properties");
    }

    public static boolean hasStatsData(Map<String, String> actionData) throws IOException {
        return actionData.containsKey("stats.properties");
    }

    public static boolean hasIdSwap(Map<String, String> actionData) throws IOException {
        return actionData.containsKey("newId");
    }

    public static Path getActionDataSequenceFilePath(Path actionDir) {
        return new Path(actionDir, "action-data.seq");
    }

    public static Map<String, String> getActionData(final FileSystem fs, final Path actionDir, final Configuration conf) throws IOException, InterruptedException {
        UserGroupInformationService ugiService = Services.get().get(UserGroupInformationService.class);
        UserGroupInformation ugi = ugiService.getProxyUser(conf.get("user.name"));
        return (Map)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Map<String, String>>(){

            @Override
            public Map<String, String> run() throws IOException {
                HashMap<String, String> ret = new HashMap<String, String>();
                Path seqFilePath = LauncherMapperHelper.getActionDataSequenceFilePath(actionDir);
                if (fs.exists(seqFilePath)) {
                    SequenceFile.Reader seqFile = new SequenceFile.Reader(fs, seqFilePath, conf);
                    Text key = new Text();
                    Text value = new Text();
                    while (seqFile.next((Writable)key, (Writable)value)) {
                        ret.put(key.toString(), value.toString());
                    }
                    seqFile.close();
                } else {
                    FileStatus[] files = fs.listStatus(actionDir);
                    BufferedReader reader = null;
                    if (files != null && files.length > 0) {
                        for (int x = 0; x < files.length; ++x) {
                            FSDataInputStream is;
                            Path file = files[x].getPath();
                            if (file.equals((Object)new Path(actionDir, "externalChildIds.properties"))) {
                                is = fs.open(file);
                                reader = new BufferedReader(new InputStreamReader((InputStream)is));
                                ret.put("externalChildIDs", IOUtils.getReaderAsString(reader, -1));
                                continue;
                            }
                            if (file.equals((Object)new Path(actionDir, "newId.properties"))) {
                                is = fs.open(file);
                                reader = new BufferedReader(new InputStreamReader((InputStream)is));
                                Properties props = PropertiesUtils.readProperties(reader, -1);
                                ret.put("newId", props.getProperty("id"));
                                continue;
                            }
                            if (file.equals((Object)new Path(actionDir, "output.properties"))) {
                                int maxOutputData = conf.getInt("oozie.action.max.output.data", 2048);
                                is = fs.open(file);
                                reader = new BufferedReader(new InputStreamReader((InputStream)is));
                                ret.put("output.properties", PropertiesUtils.propertiesToString(PropertiesUtils.readProperties(reader, maxOutputData)));
                                continue;
                            }
                            if (file.equals((Object)new Path(actionDir, "stats.properties"))) {
                                int statsMaxOutputData = conf.getInt("oozie.external.stats.max.size", Integer.MAX_VALUE);
                                is = fs.open(file);
                                reader = new BufferedReader(new InputStreamReader((InputStream)is));
                                ret.put("stats.properties", PropertiesUtils.propertiesToString(PropertiesUtils.readProperties(reader, statsMaxOutputData)));
                                continue;
                            }
                            if (!file.equals((Object)new Path(actionDir, "error.properties"))) continue;
                            is = fs.open(file);
                            reader = new BufferedReader(new InputStreamReader((InputStream)is));
                            ret.put("error.properties", IOUtils.getReaderAsString(reader, -1));
                        }
                    }
                }
                return ret;
            }
        });
    }
}

