/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.rest;

import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Entity
@Table(name="WF_ACTIONS")
@DiscriminatorColumn(name="bean_type", discriminatorType=DiscriminatorType.STRING)
public class JsonWorkflowAction
implements WorkflowAction,
JsonBean,
PersistenceCapable {
    @Id
    private String id;
    @Basic
    @Column(name="name")
    private String name = null;
    @Basic
    @Column(name="cred")
    private String cred = null;
    @Basic
    @Column(name="type")
    private String type = null;
    @Basic
    @Column(name="conf")
    @Lob
    private String conf = null;
    @Transient
    private WorkflowAction.Status status = WorkflowAction.Status.PREP;
    @Basic
    @Column(name="retries")
    private int retries;
    @Basic
    @Column(name="user_retry_count")
    private int userRetryCount;
    @Basic
    @Column(name="user_retry_max")
    private int userRetryMax;
    @Basic
    @Column(name="user_retry_interval")
    private int userRetryInterval;
    @Transient
    private Date startTime;
    @Transient
    private Date endTime;
    @Basic
    @Column(name="transition")
    private String transition = null;
    @Column(name="data")
    @Lob
    private String data = null;
    @Column(name="stats")
    @Lob
    private String stats = null;
    @Column(name="external_child_ids")
    @Lob
    private String externalChildIDs = null;
    @Basic
    @Column(name="external_id")
    private String externalId = null;
    @Basic
    @Column(name="external_status")
    private String externalStatus = null;
    @Basic
    @Column(name="tracker_uri")
    private String trackerUri = null;
    @Basic
    @Column(name="console_url")
    private String consoleUrl = null;
    @Basic
    @Column(name="error_code")
    private String errorCode = null;
    @Column(name="error_message", length=500)
    private String errorMessage = null;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$oozie$client$rest$JsonWorkflowAction;
    private transient Object pcDetachedState;

    @Override
    public JSONObject toJSONObject() {
        return this.toJSONObject("GMT");
    }

    @Override
    public JSONObject toJSONObject(String timeZoneId) {
        JSONObject json = new JSONObject();
        json.put((Object)"id", (Object)JsonWorkflowAction.pcGetid(this));
        json.put((Object)"name", (Object)JsonWorkflowAction.pcGetname(this));
        json.put((Object)"cred", (Object)JsonWorkflowAction.pcGetcred(this));
        json.put((Object)"type", (Object)JsonWorkflowAction.pcGettype(this));
        json.put((Object)"conf", (Object)JsonWorkflowAction.pcGetconf(this));
        json.put((Object)"status", (Object)this.status.toString());
        json.put((Object)"retries", (Object)JsonWorkflowAction.pcGetretries(this));
        json.put((Object)"startTime", (Object)JsonUtils.formatDateRfc822((Date)this.startTime, (String)timeZoneId));
        json.put((Object)"endTime", (Object)JsonUtils.formatDateRfc822((Date)this.endTime, (String)timeZoneId));
        json.put((Object)"transition", (Object)JsonWorkflowAction.pcGettransition(this));
        json.put((Object)"data", (Object)JsonWorkflowAction.pcGetdata(this));
        json.put((Object)"stats", (Object)JsonWorkflowAction.pcGetstats(this));
        json.put((Object)"externalChildIDs", (Object)JsonWorkflowAction.pcGetexternalChildIDs(this));
        json.put((Object)"externalId", (Object)JsonWorkflowAction.pcGetexternalId(this));
        json.put((Object)"externalStatus", (Object)JsonWorkflowAction.pcGetexternalStatus(this));
        json.put((Object)"trackerUri", (Object)JsonWorkflowAction.pcGettrackerUri(this));
        json.put((Object)"consoleUrl", (Object)JsonWorkflowAction.pcGetconsoleUrl(this));
        json.put((Object)"errorCode", (Object)JsonWorkflowAction.pcGeterrorCode(this));
        json.put((Object)"errorMessage", (Object)JsonWorkflowAction.pcGeterrorMessage(this));
        json.put((Object)"toString", (Object)this.toString());
        return json;
    }

    public String getId() {
        return JsonWorkflowAction.pcGetid(this);
    }

    public void setId(String id) {
        JsonWorkflowAction.pcSetid(this, id);
    }

    public String getName() {
        return JsonWorkflowAction.pcGetname(this);
    }

    public void setName(String name) {
        JsonWorkflowAction.pcSetname(this, name);
    }

    public String getCred() {
        return JsonWorkflowAction.pcGetcred(this);
    }

    public void setCred(String cred) {
        JsonWorkflowAction.pcSetcred(this, cred);
    }

    public String getType() {
        return JsonWorkflowAction.pcGettype(this);
    }

    public void setType(String type) {
        JsonWorkflowAction.pcSettype(this, type);
    }

    public String getConf() {
        return JsonWorkflowAction.pcGetconf(this);
    }

    public void setConf(String conf) {
        JsonWorkflowAction.pcSetconf(this, conf);
    }

    public WorkflowAction.Status getStatus() {
        return this.status;
    }

    public void setStatus(WorkflowAction.Status status) {
        this.status = status;
    }

    public int getRetries() {
        return JsonWorkflowAction.pcGetretries(this);
    }

    public void setRetries(int retries) {
        JsonWorkflowAction.pcSetretries(this, retries);
    }

    public int getUserRetryCount() {
        return JsonWorkflowAction.pcGetuserRetryCount(this);
    }

    public void setUserRetryCount(int retryCount) {
        JsonWorkflowAction.pcSetuserRetryCount(this, retryCount);
    }

    public void incrmentUserRetryCount() {
        JsonWorkflowAction jsonWorkflowAction = this;
        JsonWorkflowAction.pcSetuserRetryCount(jsonWorkflowAction, JsonWorkflowAction.pcGetuserRetryCount(jsonWorkflowAction) + 1);
    }

    public int getUserRetryMax() {
        return JsonWorkflowAction.pcGetuserRetryMax(this);
    }

    public void setUserRetryMax(int retryMax) {
        JsonWorkflowAction.pcSetuserRetryMax(this, retryMax);
    }

    public int getUserRetryInterval() {
        return JsonWorkflowAction.pcGetuserRetryInterval(this);
    }

    public void setUserRetryInterval(int retryInterval) {
        JsonWorkflowAction.pcSetuserRetryInterval(this, retryInterval);
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getTransition() {
        return JsonWorkflowAction.pcGettransition(this);
    }

    public void setTransition(String transition) {
        JsonWorkflowAction.pcSettransition(this, transition);
    }

    public String getData() {
        return JsonWorkflowAction.pcGetdata(this);
    }

    public void setData(String data) {
        JsonWorkflowAction.pcSetdata(this, data);
    }

    public String getStats() {
        return JsonWorkflowAction.pcGetstats(this);
    }

    public void setStats(String stats) {
        JsonWorkflowAction.pcSetstats(this, stats);
    }

    public String getExternalChildIDs() {
        return JsonWorkflowAction.pcGetexternalChildIDs(this);
    }

    public void setExternalChildIDs(String externalChildIDs) {
        JsonWorkflowAction.pcSetexternalChildIDs(this, externalChildIDs);
    }

    public String getExternalId() {
        return JsonWorkflowAction.pcGetexternalId(this);
    }

    public void setExternalId(String externalId) {
        JsonWorkflowAction.pcSetexternalId(this, externalId);
    }

    public String getExternalStatus() {
        return JsonWorkflowAction.pcGetexternalStatus(this);
    }

    public void setExternalStatus(String externalStatus) {
        JsonWorkflowAction.pcSetexternalStatus(this, externalStatus);
    }

    public String getTrackerUri() {
        return JsonWorkflowAction.pcGettrackerUri(this);
    }

    public void setTrackerUri(String trackerUri) {
        JsonWorkflowAction.pcSettrackerUri(this, trackerUri);
    }

    public String getConsoleUrl() {
        return JsonWorkflowAction.pcGetconsoleUrl(this);
    }

    public void setConsoleUrl(String consoleUrl) {
        JsonWorkflowAction.pcSetconsoleUrl(this, consoleUrl);
    }

    public String getErrorCode() {
        return JsonWorkflowAction.pcGeterrorCode(this);
    }

    public String getErrorMessage() {
        return JsonWorkflowAction.pcGeterrorMessage(this);
    }

    public void setErrorInfo(String errorCode, String errorMessage) {
        JsonWorkflowAction.pcSeterrorCode(this, errorCode);
        if (errorMessage != null && errorMessage.length() > 500) {
            errorMessage = errorMessage.substring(0, 500);
        }
        JsonWorkflowAction.pcSeterrorMessage(this, errorMessage);
    }

    public String toString() {
        return MessageFormat.format("Action name[{0}] status[{1}]", this.getName(), this.getStatus());
    }

    public static JSONArray toJSONArray(List<? extends JsonWorkflowAction> nodes, String timeZoneId) {
        JSONArray array = new JSONArray();
        for (JsonWorkflowAction jsonWorkflowAction : nodes) {
            array.add((Object)jsonWorkflowAction.toJSONObject(timeZoneId));
        }
        return array;
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"conf", "consoleUrl", "cred", "data", "errorCode", "errorMessage", "externalChildIDs", "externalId", "externalStatus", "id", "name", "retries", "stats", "trackerUri", "transition", "type", "userRetryCount", "userRetryInterval", "userRetryMax"};
        Class[] classArray = new Class[19];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[0] = clazz;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[10] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[11] = Integer.TYPE;
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[13] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[14] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[15] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowAction.class$("java.lang.String"));
        classArray[16] = Integer.TYPE;
        classArray[17] = Integer.TYPE;
        classArray[18] = Integer.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz2 = class$Lorg$apache$oozie$client$rest$JsonWorkflowAction != null ? class$Lorg$apache$oozie$client$rest$JsonWorkflowAction : (class$Lorg$apache$oozie$client$rest$JsonWorkflowAction = JsonWorkflowAction.class$("org.apache.oozie.client.rest.JsonWorkflowAction"));
        PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JsonWorkflowAction", (PersistenceCapable)new JsonWorkflowAction());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.conf = null;
        this.consoleUrl = null;
        this.cred = null;
        this.data = null;
        this.errorCode = null;
        this.errorMessage = null;
        this.externalChildIDs = null;
        this.externalId = null;
        this.externalStatus = null;
        this.id = null;
        this.name = null;
        this.retries = 0;
        this.stats = null;
        this.trackerUri = null;
        this.transition = null;
        this.type = null;
        this.userRetryCount = 0;
        this.userRetryInterval = 0;
        this.userRetryMax = 0;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JsonWorkflowAction jsonWorkflowAction = new JsonWorkflowAction();
        if (bl) {
            jsonWorkflowAction.pcClearFields();
        }
        jsonWorkflowAction.pcStateManager = stateManager;
        jsonWorkflowAction.pcCopyKeyFieldsFromObjectId(object);
        return jsonWorkflowAction;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JsonWorkflowAction jsonWorkflowAction = new JsonWorkflowAction();
        if (bl) {
            jsonWorkflowAction.pcClearFields();
        }
        jsonWorkflowAction.pcStateManager = stateManager;
        return jsonWorkflowAction;
    }

    protected static int pcGetManagedFieldCount() {
        return 19;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.conf = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.consoleUrl = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.cred = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.data = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.errorCode = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.errorMessage = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.externalChildIDs = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.externalStatus = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.id = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.retries = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.stats = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.trackerUri = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.transition = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.type = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.userRetryCount = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.userRetryInterval = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.userRetryMax = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.conf);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.consoleUrl);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.cred);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.data);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.errorCode);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.errorMessage);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalChildIDs);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalStatus);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 10: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 11: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.retries);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.stats);
                return;
            }
            case 13: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.trackerUri);
                return;
            }
            case 14: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.transition);
                return;
            }
            case 15: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.type);
                return;
            }
            case 16: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.userRetryCount);
                return;
            }
            case 17: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.userRetryInterval);
                return;
            }
            case 18: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.userRetryMax);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JsonWorkflowAction jsonWorkflowAction, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.conf = jsonWorkflowAction.conf;
                return;
            }
            case 1: {
                this.consoleUrl = jsonWorkflowAction.consoleUrl;
                return;
            }
            case 2: {
                this.cred = jsonWorkflowAction.cred;
                return;
            }
            case 3: {
                this.data = jsonWorkflowAction.data;
                return;
            }
            case 4: {
                this.errorCode = jsonWorkflowAction.errorCode;
                return;
            }
            case 5: {
                this.errorMessage = jsonWorkflowAction.errorMessage;
                return;
            }
            case 6: {
                this.externalChildIDs = jsonWorkflowAction.externalChildIDs;
                return;
            }
            case 7: {
                this.externalId = jsonWorkflowAction.externalId;
                return;
            }
            case 8: {
                this.externalStatus = jsonWorkflowAction.externalStatus;
                return;
            }
            case 9: {
                this.id = jsonWorkflowAction.id;
                return;
            }
            case 10: {
                this.name = jsonWorkflowAction.name;
                return;
            }
            case 11: {
                this.retries = jsonWorkflowAction.retries;
                return;
            }
            case 12: {
                this.stats = jsonWorkflowAction.stats;
                return;
            }
            case 13: {
                this.trackerUri = jsonWorkflowAction.trackerUri;
                return;
            }
            case 14: {
                this.transition = jsonWorkflowAction.transition;
                return;
            }
            case 15: {
                this.type = jsonWorkflowAction.type;
                return;
            }
            case 16: {
                this.userRetryCount = jsonWorkflowAction.userRetryCount;
                return;
            }
            case 17: {
                this.userRetryInterval = jsonWorkflowAction.userRetryInterval;
                return;
            }
            case 18: {
                this.userRetryMax = jsonWorkflowAction.userRetryMax;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JsonWorkflowAction jsonWorkflowAction = (JsonWorkflowAction)object;
        if (jsonWorkflowAction.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jsonWorkflowAction, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(9 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.id = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonWorkflowAction != null ? class$Lorg$apache$oozie$client$rest$JsonWorkflowAction : (class$Lorg$apache$oozie$client$rest$JsonWorkflowAction = JsonWorkflowAction.class$("org.apache.oozie.client.rest.JsonWorkflowAction"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonWorkflowAction != null ? class$Lorg$apache$oozie$client$rest$JsonWorkflowAction : (class$Lorg$apache$oozie$client$rest$JsonWorkflowAction = JsonWorkflowAction.class$("org.apache.oozie.client.rest.JsonWorkflowAction"));
        return new StringId(clazz, this.id);
    }

    private static final String pcGetconf(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.conf;
        }
        int n = pcInheritedFieldCount + 0;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.conf;
    }

    private static final void pcSetconf(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.conf = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 0, jsonWorkflowAction.conf, string, 0);
    }

    private static final String pcGetconsoleUrl(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.consoleUrl;
        }
        int n = pcInheritedFieldCount + 1;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.consoleUrl;
    }

    private static final void pcSetconsoleUrl(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.consoleUrl = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 1, jsonWorkflowAction.consoleUrl, string, 0);
    }

    private static final String pcGetcred(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.cred;
        }
        int n = pcInheritedFieldCount + 2;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.cred;
    }

    private static final void pcSetcred(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.cred = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 2, jsonWorkflowAction.cred, string, 0);
    }

    private static final String pcGetdata(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.data;
        }
        int n = pcInheritedFieldCount + 3;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.data;
    }

    private static final void pcSetdata(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.data = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 3, jsonWorkflowAction.data, string, 0);
    }

    private static final String pcGeterrorCode(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.errorCode;
        }
        int n = pcInheritedFieldCount + 4;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.errorCode;
    }

    private static final void pcSeterrorCode(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.errorCode = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 4, jsonWorkflowAction.errorCode, string, 0);
    }

    private static final String pcGeterrorMessage(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.errorMessage;
        }
        int n = pcInheritedFieldCount + 5;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.errorMessage;
    }

    private static final void pcSeterrorMessage(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.errorMessage = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 5, jsonWorkflowAction.errorMessage, string, 0);
    }

    private static final String pcGetexternalChildIDs(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.externalChildIDs;
        }
        int n = pcInheritedFieldCount + 6;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.externalChildIDs;
    }

    private static final void pcSetexternalChildIDs(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.externalChildIDs = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 6, jsonWorkflowAction.externalChildIDs, string, 0);
    }

    private static final String pcGetexternalId(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.externalId;
        }
        int n = pcInheritedFieldCount + 7;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.externalId;
    }

    private static final void pcSetexternalId(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.externalId = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 7, jsonWorkflowAction.externalId, string, 0);
    }

    private static final String pcGetexternalStatus(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.externalStatus;
        }
        int n = pcInheritedFieldCount + 8;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.externalStatus;
    }

    private static final void pcSetexternalStatus(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.externalStatus = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 8, jsonWorkflowAction.externalStatus, string, 0);
    }

    private static final String pcGetid(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.id;
        }
        int n = pcInheritedFieldCount + 9;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.id;
    }

    private static final void pcSetid(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.id = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 9, jsonWorkflowAction.id, string, 0);
    }

    private static final String pcGetname(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.name;
        }
        int n = pcInheritedFieldCount + 10;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.name;
    }

    private static final void pcSetname(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.name = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 10, jsonWorkflowAction.name, string, 0);
    }

    private static final int pcGetretries(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.retries;
        }
        int n = pcInheritedFieldCount + 11;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.retries;
    }

    private static final void pcSetretries(JsonWorkflowAction jsonWorkflowAction, int n) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.retries = n;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingIntField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 11, jsonWorkflowAction.retries, n, 0);
    }

    private static final String pcGetstats(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.stats;
        }
        int n = pcInheritedFieldCount + 12;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.stats;
    }

    private static final void pcSetstats(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.stats = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 12, jsonWorkflowAction.stats, string, 0);
    }

    private static final String pcGettrackerUri(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.trackerUri;
        }
        int n = pcInheritedFieldCount + 13;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.trackerUri;
    }

    private static final void pcSettrackerUri(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.trackerUri = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 13, jsonWorkflowAction.trackerUri, string, 0);
    }

    private static final String pcGettransition(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.transition;
        }
        int n = pcInheritedFieldCount + 14;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.transition;
    }

    private static final void pcSettransition(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.transition = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 14, jsonWorkflowAction.transition, string, 0);
    }

    private static final String pcGettype(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.type;
        }
        int n = pcInheritedFieldCount + 15;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.type;
    }

    private static final void pcSettype(JsonWorkflowAction jsonWorkflowAction, String string) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.type = string;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 15, jsonWorkflowAction.type, string, 0);
    }

    private static final int pcGetuserRetryCount(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.userRetryCount;
        }
        int n = pcInheritedFieldCount + 16;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.userRetryCount;
    }

    private static final void pcSetuserRetryCount(JsonWorkflowAction jsonWorkflowAction, int n) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.userRetryCount = n;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingIntField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 16, jsonWorkflowAction.userRetryCount, n, 0);
    }

    private static final int pcGetuserRetryInterval(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.userRetryInterval;
        }
        int n = pcInheritedFieldCount + 17;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.userRetryInterval;
    }

    private static final void pcSetuserRetryInterval(JsonWorkflowAction jsonWorkflowAction, int n) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.userRetryInterval = n;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingIntField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 17, jsonWorkflowAction.userRetryInterval, n, 0);
    }

    private static final int pcGetuserRetryMax(JsonWorkflowAction jsonWorkflowAction) {
        if (jsonWorkflowAction.pcStateManager == null) {
            return jsonWorkflowAction.userRetryMax;
        }
        int n = pcInheritedFieldCount + 18;
        jsonWorkflowAction.pcStateManager.accessingField(n);
        return jsonWorkflowAction.userRetryMax;
    }

    private static final void pcSetuserRetryMax(JsonWorkflowAction jsonWorkflowAction, int n) {
        if (jsonWorkflowAction.pcStateManager == null) {
            jsonWorkflowAction.userRetryMax = n;
            return;
        }
        jsonWorkflowAction.pcStateManager.settingIntField((PersistenceCapable)jsonWorkflowAction, pcInheritedFieldCount + 18, jsonWorkflowAction.userRetryMax, n, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

