/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.control.EndActionExecutor;
import org.apache.oozie.action.control.ForkActionExecutor;
import org.apache.oozie.action.control.JoinActionExecutor;
import org.apache.oozie.action.control.KillActionExecutor;
import org.apache.oozie.action.control.StartActionExecutor;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public class ActionService
implements Service {
    public static final String CONF_ACTION_EXECUTOR_CLASSES = "oozie.service.ActionService.executor.classes";
    public static final String CONF_ACTION_EXECUTOR_EXT_CLASSES = "oozie.service.ActionService.executor.ext.classes";
    private Services services;
    private Map<String, Class<? extends ActionExecutor>> executors;

    @Override
    public void init(Services services) throws ServiceException {
        this.services = services;
        ActionExecutor.enableInit();
        ActionExecutor.resetInitInfo();
        ActionExecutor.disableInit();
        this.executors = new HashMap<String, Class<? extends ActionExecutor>>();
        Class[] classes = new Class[]{StartActionExecutor.class, EndActionExecutor.class, KillActionExecutor.class, ForkActionExecutor.class, JoinActionExecutor.class};
        this.registerExecutors(classes);
        classes = services.getConf().getClasses(CONF_ACTION_EXECUTOR_CLASSES, new Class[0]);
        this.registerExecutors(classes);
        classes = services.getConf().getClasses(CONF_ACTION_EXECUTOR_EXT_CLASSES, new Class[0]);
        this.registerExecutors(classes);
    }

    private void registerExecutors(Class<? extends ActionExecutor>[] classes) throws ServiceException {
        if (classes != null) {
            for (Class<? extends ActionExecutor> executorClass : classes) {
                this.register(executorClass);
            }
        }
    }

    @Override
    public void destroy() {
        ActionExecutor.enableInit();
        ActionExecutor.resetInitInfo();
        ActionExecutor.disableInit();
        this.executors = null;
    }

    @Override
    public Class<? extends Service> getInterface() {
        return ActionService.class;
    }

    public void register(Class<? extends ActionExecutor> klass) throws ServiceException {
        XLog log = XLog.getLog(this.getClass());
        ActionExecutor executor = (ActionExecutor)ReflectionUtils.newInstance(klass, (Configuration)this.services.getConf());
        log.trace("Registering action type [{0}] class [{1}]", executor.getType(), klass);
        if (this.executors.containsKey(executor.getType())) {
            throw new ServiceException(ErrorCode.E0150, executor.getType());
        }
        ActionExecutor.enableInit();
        executor.initActionType();
        ActionExecutor.disableInit();
        this.executors.put(executor.getType(), klass);
        log.trace("Registered Action executor for action type [{0}] class [{1}]", executor.getType(), klass);
    }

    public ActionExecutor getExecutor(String actionType) {
        ParamChecker.notEmpty(actionType, "actionType");
        Class<? extends ActionExecutor> executorClass = this.executors.get(actionType);
        return executorClass != null ? (ActionExecutor)ReflectionUtils.newInstance(executorClass, null) : null;
    }
}

