/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.command.PurgeXCommand;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.Services;

public class PurgeService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.PurgeService.";
    public static final String CONF_OLDER_THAN = "oozie.service.PurgeService.older.than";
    public static final String COORD_CONF_OLDER_THAN = "oozie.service.PurgeService.coord.older.than";
    public static final String BUNDLE_CONF_OLDER_THAN = "oozie.service.PurgeService.bundle.older.than";
    public static final String CONF_PURGE_INTERVAL = "oozie.service.PurgeService.purge.interval";
    public static final String PURGE_LIMIT = "oozie.service.PurgeService.purge.limit";

    @Override
    public void init(Services services) {
        Configuration conf = services.getConf();
        PurgeRunnable purgeJobsRunnable = new PurgeRunnable(conf.getInt(CONF_OLDER_THAN, 30), conf.getInt(COORD_CONF_OLDER_THAN, 7), conf.getInt(BUNDLE_CONF_OLDER_THAN, 7), conf.getInt(PURGE_LIMIT, 100));
        services.get(SchedulerService.class).schedule(purgeJobsRunnable, 10L, (long)conf.getInt(CONF_PURGE_INTERVAL, 3600), SchedulerService.Unit.SEC);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return PurgeService.class;
    }

    static class PurgeRunnable
    implements Runnable {
        private int wfOlderThan;
        private int coordOlderThan;
        private int bundleOlderThan;
        private int limit;

        public PurgeRunnable(int wfOlderThan, int coordOlderThan, int bundleOlderThan, int limit) {
            this.wfOlderThan = wfOlderThan;
            this.coordOlderThan = coordOlderThan;
            this.bundleOlderThan = bundleOlderThan;
            this.limit = limit;
        }

        @Override
        public void run() {
            if (Services.get().get(JobsConcurrencyService.class).isFirstServer()) {
                Services.get().get(CallableQueueService.class).queue(new PurgeXCommand(this.wfOlderThan, this.coordOlderThan, this.bundleOlderThan, this.limit));
            }
        }
    }
}

