/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oozie.BuildInfo;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.service.AuthorizationException;
import org.apache.oozie.service.AuthorizationService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.Instrumentation;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public abstract class BaseAdminServlet
extends JsonRestServlet {
    private static final long serialVersionUID = 1L;
    protected String modeTag;
    private static final JSONArray GMTOffsetTimeZones = new JSONArray();

    public BaseAdminServlet(String instrumentationName, JsonRestServlet.ResourceInfo[] RESOURCES_INFO) {
        super(instrumentationName, RESOURCES_INFO);
        this.setAllowSafeModeChanges(true);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resourceName = this.getResourceName(request);
        request.setAttribute("audit.operation", (Object)resourceName);
        request.setAttribute("audit.param", (Object)request.getParameter(this.modeTag));
        try {
            AuthorizationService auth = Services.get().get(AuthorizationService.class);
            auth.authorizeForAdmin(this.getUser(request), true);
        }
        catch (AuthorizationException ex) {
            throw new XServletException(401, ex);
        }
        this.setOozieMode(request, response, resourceName);
    }

    abstract JsonBean getJMSConnectionInfo(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resource = this.getResourceName(request);
        Instrumentation instr = Services.get().get(InstrumentationService.class).get();
        if (resource.equals("status")) {
            JSONObject json = new JSONObject();
            this.populateOozieMode(json);
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        } else if (resource.equals("os-env")) {
            JSONObject json = new JSONObject();
            json.putAll(instr.getOSEnv());
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        } else if (resource.equals("java-sys-properties")) {
            JSONObject json = new JSONObject();
            json.putAll(instr.getJavaSystemProperties());
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        } else if (resource.equals("configuration")) {
            JSONObject json = new JSONObject();
            json.putAll(instr.getConfiguration());
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        } else if (resource.equals("instrumentation")) {
            this.sendJsonResponse(response, 200, (JSONStreamAware)this.instrToJson(instr));
        } else if (resource.equals("build-version")) {
            JSONObject json = new JSONObject();
            json.put((Object)"buildVersion", (Object)BuildInfo.getBuildInfo().getProperty("build.version"));
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        } else if (resource.equals("queue-dump")) {
            JSONObject json = new JSONObject();
            this.getQueueDump(json);
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        } else if (resource.equals("available-timezones")) {
            JSONObject json = new JSONObject();
            json.put((Object)"available-timezones", (Object)this.availableTimeZonesToJsonArray());
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        } else if (resource.equals("jmsinfo")) {
            String timeZoneId = request.getParameter("timezone") == null ? "GMT" : request.getParameter("timezone");
            JsonBean jmsBean = this.getJMSConnectionInfo(request, response);
            this.sendJsonResponse(response, 200, jmsBean, timeZoneId);
        } else if (resource.equals("available-oozie-servers")) {
            JSONObject json = new JSONObject();
            json.putAll(this.getOozieURLs());
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    private <T> JSONArray instrElementsToJson(Map<String, Map<String, Instrumentation.Element<T>>> instrElements) {
        JSONArray array = new JSONArray();
        for (Map.Entry<String, Map<String, Instrumentation.Element<T>>> group : instrElements.entrySet()) {
            JSONObject json = new JSONObject();
            String groupName = group.getKey();
            json.put((Object)"group", (Object)groupName);
            JSONArray dataArray = new JSONArray();
            for (Map.Entry<String, Instrumentation.Element<T>> elementEntry : group.getValue().entrySet()) {
                String samplerName = elementEntry.getKey();
                JSONObject dataJson = new JSONObject();
                dataJson.put((Object)"name", (Object)samplerName);
                T value = elementEntry.getValue().getValue();
                if (value instanceof Instrumentation.Timer) {
                    Instrumentation.Timer timer = (Instrumentation.Timer)value;
                    dataJson.put((Object)"ticks", (Object)timer.getTicks());
                    dataJson.put((Object)"ownTimeAvg", (Object)timer.getOwnAvg());
                    dataJson.put((Object)"totalTimeAvg", (Object)timer.getTotalAvg());
                    dataJson.put((Object)"ownTimeStdDev", (Object)timer.getOwnStdDev());
                    dataJson.put((Object)"totalTimeStdDev", (Object)timer.getTotalStdDev());
                    dataJson.put((Object)"ownMinTime", (Object)timer.getOwnMin());
                    dataJson.put((Object)"ownMaxTime", (Object)timer.getOwnMax());
                    dataJson.put((Object)"totalMinTime", (Object)timer.getTotalMin());
                    dataJson.put((Object)"totalMaxTime", (Object)timer.getTotalMax());
                } else {
                    dataJson.put((Object)"value", value);
                }
                dataArray.add((Object)dataJson);
            }
            json.put((Object)"data", (Object)dataArray);
            array.add((Object)json);
        }
        return array;
    }

    private JSONObject instrToJson(Instrumentation instr) {
        JSONObject json = new JSONObject();
        json.put((Object)"variables", (Object)this.instrElementsToJson(instr.getVariables()));
        json.put((Object)"samplers", (Object)this.instrElementsToJson(instr.getSamplers()));
        json.put((Object)"counters", (Object)this.instrElementsToJson(instr.getCounters()));
        json.put((Object)"timers", (Object)this.instrElementsToJson(instr.getTimers()));
        return json;
    }

    protected abstract void populateOozieMode(JSONObject var1);

    protected abstract void setOozieMode(HttpServletRequest var1, HttpServletResponse var2, String var3) throws XServletException;

    protected abstract void getQueueDump(JSONObject var1) throws XServletException;

    private static void prepareGMTOffsetTimeZones() {
        for (String tzId : new String[]{"GMT-12:00", "GMT-11:00", "GMT-10:00", "GMT-09:00", "GMT-08:00", "GMT-07:00", "GMT-06:00", "GMT-05:00", "GMT-04:00", "GMT-03:00", "GMT-02:00", "GMT-01:00", "GMT+01:00", "GMT+02:00", "GMT+03:00", "GMT+04:00", "GMT+05:00", "GMT+06:00", "GMT+07:00", "GMT+08:00", "GMT+09:00", "GMT+10:00", "GMT+11:00", "GMT+12:00"}) {
            TimeZone tz = TimeZone.getTimeZone(tzId);
            JSONObject json = new JSONObject();
            json.put((Object)"timezoneDisplayName", (Object)(tz.getDisplayName(false, 0) + " (" + tzId + ")"));
            json.put((Object)"timezoneId", (Object)tzId);
            GMTOffsetTimeZones.add((Object)json);
        }
    }

    private JSONArray availableTimeZonesToJsonArray() {
        JSONArray array = new JSONArray();
        for (String tzId : TimeZone.getAvailableIDs()) {
            if (tzId.startsWith("Etc/GMT")) continue;
            JSONObject json = new JSONObject();
            TimeZone tZone = TimeZone.getTimeZone(tzId);
            json.put((Object)"timezoneDisplayName", (Object)(tZone.getDisplayName(false, 0) + " (" + tzId + ")"));
            json.put((Object)"timezoneId", (Object)tzId);
            array.add((Object)json);
        }
        array.addAll((Collection)GMTOffsetTimeZones);
        return array;
    }

    protected abstract Map<String, String> getOozieURLs() throws XServletException;

    static {
        BaseAdminServlet.prepareGMTOffsetTimeZones();
    }
}

