/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.SLAEventsXCommand;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Content;
import org.jdom.Element;

public class SLAServlet
extends JsonRestServlet {
    private static final Set<String> SLA_FILTER_NAMES = new HashSet<String>();
    private static final String INSTRUMENTATION_NAME = "sla";
    private static final JsonRestServlet.ResourceInfo[] RESOURCES_INFO;

    public SLAServlet() {
        super(INSTRUMENTATION_NAME, RESOURCES_INFO);
    }

    public SLAServlet(String instrumentationName, JsonRestServlet.ResourceInfo ... resourcesInfo) {
        super(instrumentationName, resourcesInfo);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Element eResponse = new Element("sla-message");
        List slaEvntList = null;
        try {
            long lastSeqId;
            this.stopCron();
            String gtSequenceNum = request.getParameter("gt-sequence-id");
            String strMaxEvents = request.getParameter("max-events");
            String filter = request.getParameter("filter");
            Map<String, List<String>> filterList = this.parseFilter(filter, SLA_FILTER_NAMES);
            int maxNoEvents = 100;
            XLog.getLog(((Object)((Object)this)).getClass()).debug("Got SLA GET request for :" + gtSequenceNum + " and max-events :" + strMaxEvents);
            if (strMaxEvents != null && strMaxEvents.length() > 0) {
                maxNoEvents = Integer.parseInt(strMaxEvents);
            }
            if (gtSequenceNum != null) {
                long seqId = Long.parseLong(gtSequenceNum);
                this.stopCron();
                SLAEventsXCommand seCommand = new SLAEventsXCommand(seqId, maxNoEvents, filterList);
                slaEvntList = (List)seCommand.call();
                lastSeqId = seCommand.getLastSeqId();
                eResponse = new Element("sla-message");
                for (SLAEventBean event : slaEvntList) {
                    eResponse.addContent((Content)event.toXml());
                }
            } else {
                XLog.getLog(((Object)((Object)this)).getClass()).error("gt-sequence-id parameter is not specified in the http request");
                throw new XServletException(400, ErrorCode.E0401, "gt-sequence-id parameter is not specified in the http request");
            }
            Element eLastSeq = new Element("last-sequence-id");
            eLastSeq.addContent(String.valueOf(lastSeqId));
            eResponse.addContent((Content)eLastSeq);
            XLog.getLog(((Object)((Object)this)).getClass()).debug("Writing back SLA Servlet  Caller with last-seq-id " + lastSeqId);
            this.startCron();
            this.startCron();
            response.setContentType("application/xml; charset=\"UTF-8\"");
            response.setStatus(200);
            response.getWriter().write(XmlUtils.prettyPrint(eResponse) + "\n");
        }
        catch (CommandException ce) {
            ce.printStackTrace();
            XLog.getLog(((Object)((Object)this)).getClass()).error((Object)"Command exception ", ce);
            throw new XServletException(400, ce);
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            XLog.getLog(((Object)((Object)this)).getClass()).error((Object)"Runtime error ", re);
            throw new XServletException(400, ErrorCode.E0307, re.getMessage());
        }
    }

    protected Map<String, List<String>> parseFilter(String filterString, Set<String> allowedFilters) throws ServletException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (filterString != null) {
            StringTokenizer st = new StringTokenizer(filterString, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.contains("=")) {
                    String[] pair = token.split("=");
                    if (pair.length != 2) {
                        throw new XServletException(400, ErrorCode.E0401, "elements must be name=value pairs");
                    }
                    if (!allowedFilters.contains(pair[0])) {
                        throw new XServletException(400, ErrorCode.E0401, "invalid/unsupported names in filter");
                    }
                    ArrayList<String> list = (ArrayList<String>)map.get(pair[0]);
                    if (list == null) {
                        list = new ArrayList<String>();
                        map.put(pair[0], list);
                    }
                    list.add(pair[1]);
                    continue;
                }
                throw new XServletException(400, ErrorCode.E0401, "elements must be name=value pairs");
            }
        }
        return map;
    }

    static {
        SLA_FILTER_NAMES.add("jobid");
        SLA_FILTER_NAMES.add("appname");
        RESOURCES_INFO = new JsonRestServlet.ResourceInfo[1];
        SLAServlet.RESOURCES_INFO[0] = new JsonRestServlet.ResourceInfo("", Arrays.asList("GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("gt-sequence-id", String.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("max-events", String.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("filter", String.class, false, Arrays.asList("GET"))));
    }
}

