/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.util.db.SimplePasswordProvider;

public class ShellPasswordProvider
extends SimplePasswordProvider {
    public static final String CONF_PASSWORDPROVIDERSCRIPT = "jdbc.password.provider.script";

    @Override
    public String getPassword(Configuration conf, String confPrefix) throws ServiceException {
        String envelope = super.getPassword(conf, confPrefix);
        String command = conf.get(confPrefix + CONF_PASSWORDPROVIDERSCRIPT);
        if (command == null) {
            throw new ServiceException(ErrorCode.E0608, "Script path is not specified via " + confPrefix + CONF_PASSWORDPROVIDERSCRIPT);
        }
        String[] cmd = command.split(" ");
        String[] cmdWithEnvelope = Arrays.copyOf(cmd, cmd.length + 1);
        cmdWithEnvelope[cmdWithEnvelope.length - 1] = envelope;
        String decryptedPassword = null;
        try {
            decryptedPassword = Shell.execCommand((String[])cmdWithEnvelope);
        }
        catch (IOException ex) {
            throw new ServiceException(ErrorCode.E0608, ex);
        }
        return decryptedPassword;
    }
}

