/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;

public class StructureUtil {
    public static List getTargets(IProgramElement node, IRelationship.Kind kind) {
        return StructureUtil.getTargets(node, kind, null);
    }

    public static List getTargets(IProgramElement node, IRelationship.Kind kind, String relName) {
        ArrayList<IRelationship> relations = new ArrayList<IRelationship>();
        List rels = node.getModel().getRelationshipMap().get(node);
        if (rels != null) {
            relations.addAll(rels);
        }
        Iterator iter = node.getChildren().iterator();
        while (iter.hasNext()) {
            List childRelations;
            IProgramElement child = (IProgramElement)iter.next();
            if (node.getKind().isType() && !child.getKind().equals(IProgramElement.Kind.CODE) || (childRelations = node.getModel().getRelationshipMap().get(child)) == null) continue;
            Iterator iterator = childRelations.iterator();
            while (iterator.hasNext()) {
                IRelationship rel = (IRelationship)iterator.next();
                if (relations.contains(rel)) continue;
                relations.add(rel);
            }
        }
        if (relations == null || relations.isEmpty()) {
            return null;
        }
        ArrayList<String> targets = new ArrayList<String>();
        Iterator it = relations.iterator();
        while (it.hasNext()) {
            IRelationship rtn = (IRelationship)it.next();
            if (!rtn.getKind().equals(kind) || (relName == null || !relName.equals(rtn.getName())) && relName != null) continue;
            List targs = rtn.getTargets();
            Iterator iter2 = targs.iterator();
            while (iter2.hasNext()) {
                String element = (String)iter2.next();
                if (targets.contains(element)) continue;
                targets.add(element);
            }
        }
        return targets;
    }

    static List getDeclareInterTypeTargets(IProgramElement node, IProgramElement.Kind kind) {
        ArrayList<IProgramElement> targets = new ArrayList<IProgramElement>();
        List stringTargets = StructureUtil.getTargets(node, IRelationship.Kind.DECLARE_INTER_TYPE);
        if (stringTargets == null) {
            return null;
        }
        Iterator iter = stringTargets.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            IProgramElement ipe = node.getModel().getHierarchy().findElementForHandle(element);
            if (ipe == null || !ipe.getKind().equals(kind)) continue;
            targets.add(ipe);
        }
        return targets;
    }

    public static List getDeclareTargets(IProgramElement node) {
        List relations = node.getModel().getRelationshipMap().get(node);
        List targets = null;
        if (relations == null) {
            return null;
        }
        Iterator it = relations.iterator();
        while (it.hasNext()) {
            IRelationship rtn = (IRelationship)it.next();
            if (!rtn.getKind().isDeclareKind()) continue;
            targets = rtn.getTargets();
        }
        return targets;
    }

    public static String getPackageDeclarationFromFile(AsmManager model, File file) {
        IProgramElement fileNode = model.getHierarchy().findElementForSourceFile(file.getAbsolutePath());
        String packageName = ((IProgramElement)fileNode.getChildren().get(0)).getPackageName();
        return packageName;
    }

    public static String genSignature(IProgramElement node) {
        StringBuffer sb = new StringBuffer();
        String accessibility = node.getAccessibility().toString();
        if (!accessibility.equals("package")) {
            sb.append(accessibility);
            sb.append(' ');
        }
        String modifiers = "";
        Iterator modIt = node.getModifiers().iterator();
        while (modIt.hasNext()) {
            modifiers = modifiers + modIt.next() + " ";
        }
        if (node.getKind().equals(IProgramElement.Kind.METHOD) || node.getKind().equals(IProgramElement.Kind.FIELD)) {
            sb.append(node.getCorrespondingType());
            sb.append(' ');
        }
        if (node.getKind().equals(IProgramElement.Kind.CLASS)) {
            sb.append("class ");
        } else if (node.getKind().equals(IProgramElement.Kind.INTERFACE)) {
            sb.append("interface ");
        }
        sb.append(node.getName());
        if (node.getParameterTypes() != null) {
            sb.append('(');
            for (int i = 0; i < node.getParameterTypes().size(); ++i) {
                sb.append((String)node.getParameterTypes().get(i));
                sb.append(' ');
                sb.append((String)node.getParameterNames().get(i));
                if (i >= node.getParameterTypes().size() - 1) continue;
                sb.append(", ");
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static boolean isAnonymous(IProgramElement node) {
        boolean isIntName = true;
        try {
            Integer.valueOf(node.getName());
        }
        catch (NumberFormatException nfe) {
            isIntName = false;
        }
        return isIntName || node.getName().startsWith("new ");
    }

    public static String translateAjPathName(String path) {
        if (path.endsWith(".aj")) {
            path = path.substring(0, path.lastIndexOf(".aj")) + ".java";
        }
        return path;
    }
}

