/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.io.Writable;

public class FilterList
implements Filter {
    private static final Configuration conf = HBaseConfiguration.create();
    private static final int MAX_LOG_FILTERS = 5;
    private Operator operator = Operator.MUST_PASS_ALL;
    private List<Filter> filters = new ArrayList<Filter>();
    private Filter seekHintFilter = null;
    private KeyValue referenceKV = null;
    private KeyValue transformedKV = null;

    public FilterList() {
    }

    public FilterList(List<Filter> rowFilters) {
        this.filters = rowFilters;
    }

    public FilterList(Filter ... rowFilters) {
        this.filters = Arrays.asList(rowFilters);
    }

    public FilterList(Operator operator) {
        this.operator = operator;
    }

    public FilterList(Operator operator, List<Filter> rowFilters) {
        this.filters = rowFilters;
        this.operator = operator;
    }

    public FilterList(Operator operator, Filter ... rowFilters) {
        this.filters = Arrays.asList(rowFilters);
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    @Override
    public void reset() {
        for (Filter filter : this.filters) {
            filter.reset();
        }
        this.seekHintFilter = null;
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) {
        boolean flag = this.operator == Operator.MUST_PASS_ONE;
        for (Filter filter : this.filters) {
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterAllRemaining() && !filter.filterRowKey(rowKey, offset, length)) continue;
                flag = true;
                continue;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining() || filter.filterRowKey(rowKey, offset, length)) continue;
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean filterAllRemaining() {
        for (Filter filter : this.filters) {
            if (filter.filterAllRemaining()) {
                if (this.operator != Operator.MUST_PASS_ALL) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    @Override
    public KeyValue transform(KeyValue v) {
        if (!v.equals(this.referenceKV)) {
            throw new IllegalStateException("Reference KeyValue: " + this.referenceKV + " does not match: " + v);
        }
        return this.transformedKV;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        this.referenceKV = v;
        KeyValue transformed = v;
        Filter.ReturnCode rc = this.operator == Operator.MUST_PASS_ONE ? Filter.ReturnCode.SKIP : Filter.ReturnCode.INCLUDE;
        block13: for (Filter filter : this.filters) {
            Filter.ReturnCode code;
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (filter.filterAllRemaining()) {
                    return Filter.ReturnCode.NEXT_ROW;
                }
                code = filter.filterKeyValue(v);
                switch (code) {
                    case INCLUDE_AND_NEXT_COL: {
                        rc = Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                    }
                    case INCLUDE: {
                        transformed = filter.transform(transformed);
                        continue block13;
                    }
                    case SEEK_NEXT_USING_HINT: {
                        this.seekHintFilter = filter;
                        return code;
                    }
                }
                return code;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining()) continue;
            code = filter.filterKeyValue(v);
            switch (code) {
                case INCLUDE: {
                    if (rc != Filter.ReturnCode.INCLUDE_AND_NEXT_COL) {
                        rc = Filter.ReturnCode.INCLUDE;
                    }
                    transformed = filter.transform(transformed);
                    continue block13;
                }
                case INCLUDE_AND_NEXT_COL: {
                    rc = Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                    transformed = filter.transform(transformed);
                    continue block13;
                }
                case NEXT_ROW: {
                    continue block13;
                }
                case SKIP: {
                    continue block13;
                }
                case NEXT_COL: {
                    continue block13;
                }
                case SEEK_NEXT_USING_HINT: {
                    continue block13;
                }
            }
            throw new IllegalStateException("Received code is not valid.");
        }
        this.transformedKV = transformed;
        return rc;
    }

    @Override
    public void filterRow(List<KeyValue> kvs) {
        for (Filter filter : this.filters) {
            filter.filterRow(kvs);
        }
    }

    @Override
    public boolean hasFilterRow() {
        for (Filter filter : this.filters) {
            if (!filter.hasFilterRow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filterRow() {
        for (Filter filter : this.filters) {
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterRow()) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterRow()) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    public void readFields(DataInput in) throws IOException {
        byte opByte = in.readByte();
        this.operator = Operator.values()[opByte];
        int size = in.readInt();
        if (size > 0) {
            this.filters = new ArrayList<Filter>(size);
            for (int i = 0; i < size; ++i) {
                Filter filter = HbaseObjectWritable.readFilter(in, conf);
                this.filters.add(filter);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.operator.ordinal());
        out.writeInt(this.filters.size());
        for (Filter filter : this.filters) {
            HbaseObjectWritable.writeObject(out, filter, Writable.class, conf);
        }
    }

    @Override
    public KeyValue getNextKeyHint(KeyValue currentKV) {
        KeyValue keyHint = null;
        if (this.operator == Operator.MUST_PASS_ALL) {
            keyHint = this.seekHintFilter.getNextKeyHint(currentKV);
            return keyHint;
        }
        for (Filter filter : this.filters) {
            KeyValue curKeyHint = filter.getNextKeyHint(currentKV);
            if (curKeyHint == null) {
                return null;
            }
            if (curKeyHint == null) continue;
            if (keyHint == null) {
                keyHint = curKeyHint;
                continue;
            }
            if (KeyValue.COMPARATOR.compare(keyHint, curKeyHint) <= 0) continue;
            keyHint = curKeyHint;
        }
        return keyHint;
    }

    public boolean isFamilyEssential(byte[] name) {
        for (Filter filter : this.filters) {
            if (!FilterBase.isFamilyEssential(filter, name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toString(5);
    }

    protected String toString(int maxFilters) {
        int endIndex = this.filters.size() < maxFilters ? this.filters.size() : maxFilters;
        return String.format("%s %s (%d/%d): %s", this.getClass().getSimpleName(), this.operator == Operator.MUST_PASS_ALL ? "AND" : "OR", endIndex, this.filters.size(), this.filters.subList(0, endIndex).toString());
    }

    public static enum Operator {
        MUST_PASS_ALL,
        MUST_PASS_ONE;

    }
}

