/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.UserProvider;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.ProtocolSignature;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessControllerProtocol;
import org.apache.hadoop.hbase.security.access.AuthResult;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class AccessController
extends BaseRegionObserver
implements MasterObserver,
RegionServerObserver,
AccessControllerProtocol {
    public static final Log LOG = LogFactory.getLog(AccessController.class);
    private static final Log AUDITLOG = LogFactory.getLog((String)("SecurityLogger." + AccessController.class.getName()));
    private static final long PROTOCOL_VERSION = 1L;
    TableAuthManager authManager = null;
    boolean aclRegion = false;
    private RegionCoprocessorEnvironment regionEnv;
    private Map<InternalScanner, String> scannerOwners = new MapMaker().weakKeys().makeMap();
    private UserProvider userProvider;

    void initialize(RegionCoprocessorEnvironment e) throws IOException {
        HRegion region = e.getRegion();
        Map<byte[], ListMultimap<String, TablePermission>> tables = AccessControlLists.loadAll(region);
        for (Map.Entry<byte[], ListMultimap<String, TablePermission>> t : tables.entrySet()) {
            byte[] table = t.getKey();
            ListMultimap<String, TablePermission> perms = t.getValue();
            byte[] serialized = AccessControlLists.writePermissionsAsBytes(perms, this.regionEnv.getConfiguration());
            this.authManager.getZKPermissionWatcher().writeToZookeeper(table, serialized);
        }
    }

    void updateACL(RegionCoprocessorEnvironment e, Map<byte[], List<KeyValue>> familyMap) {
        TreeSet<byte[]> tableSet = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], List<KeyValue>> f : familyMap.entrySet()) {
            List<KeyValue> kvs = f.getValue();
            for (KeyValue kv : kvs) {
                if (!Bytes.equals(kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength(), AccessControlLists.ACL_LIST_FAMILY, 0, AccessControlLists.ACL_LIST_FAMILY.length)) continue;
                tableSet.add(kv.getRow());
            }
        }
        ZKPermissionWatcher zkw = this.authManager.getZKPermissionWatcher();
        Configuration conf = this.regionEnv.getConfiguration();
        for (byte[] tableName : tableSet) {
            try {
                ListMultimap<String, TablePermission> perms = AccessControlLists.getTablePermissions(conf, tableName);
                byte[] serialized = AccessControlLists.writePermissionsAsBytes(perms, conf);
                zkw.writeToZookeeper(tableName, serialized);
            }
            catch (IOException ex) {
                LOG.error((Object)("Failed updating permissions mirror for '" + tableName + "'"), (Throwable)ex);
            }
        }
    }

    AuthResult permissionGranted(String request, User user, Permission.Action permRequest, RegionCoprocessorEnvironment e, Map<byte[], ? extends Collection<?>> families) {
        HRegionInfo hri = e.getRegion().getRegionInfo();
        byte[] tableName = hri.getTableName();
        if ((hri.isRootRegion() || hri.isMetaRegion()) && permRequest == Permission.Action.READ) {
            return AuthResult.allow(request, "All users allowed", user, permRequest, tableName, families);
        }
        if (user == null) {
            return AuthResult.deny(request, "No user associated with request!", null, permRequest, tableName, families);
        }
        if (permRequest == Permission.Action.WRITE && (hri.isRootRegion() || hri.isMetaRegion() || Bytes.equals(tableName, AccessControlLists.ACL_GLOBAL_NAME)) && (this.authManager.authorize(user, Permission.Action.CREATE) || this.authManager.authorize(user, Permission.Action.ADMIN))) {
            return AuthResult.allow(request, "Table permission granted", user, permRequest, tableName, families);
        }
        if (this.authManager.authorize(user, tableName, (byte[])null, permRequest)) {
            return AuthResult.allow(request, "Table permission granted", user, permRequest, tableName, families);
        }
        if (families != null && families.size() > 0) {
            for (Map.Entry<byte[], Collection<?>> family : families.entrySet()) {
                if (this.authManager.authorize(user, tableName, family.getKey(), permRequest)) continue;
                if (family.getValue() != null && family.getValue().size() > 0) {
                    if (family.getValue() instanceof Set) {
                        Set familySet = (Set)family.getValue();
                        for (byte[] qualifier : familySet) {
                            if (this.authManager.authorize(user, tableName, family.getKey(), qualifier, permRequest)) continue;
                            return AuthResult.deny(request, "Failed qualifier check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), qualifier));
                        }
                        continue;
                    }
                    if (!(family.getValue() instanceof List)) continue;
                    List kvList = (List)family.getValue();
                    for (KeyValue kv : kvList) {
                        if (this.authManager.authorize(user, tableName, family.getKey(), kv.getQualifier(), permRequest)) continue;
                        return AuthResult.deny(request, "Failed qualifier check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), kv.getQualifier()));
                    }
                    continue;
                }
                return AuthResult.deny(request, "Failed family check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), null));
            }
            return AuthResult.allow(request, "All family checks passed", user, permRequest, tableName, families);
        }
        return AuthResult.deny(request, "No families to check and table permission failed", user, permRequest, tableName, families);
    }

    private void logResult(AuthResult result) {
        if (AUDITLOG.isTraceEnabled()) {
            RequestContext ctx = RequestContext.get();
            InetAddress remoteAddr = null;
            if (ctx != null) {
                remoteAddr = ctx.getRemoteAddress();
            }
            AUDITLOG.trace((Object)("Access " + (result.isAllowed() ? "allowed" : "denied") + " for user " + (result.getUser() != null ? result.getUser().getShortName() : "UNKNOWN") + "; reason: " + result.getReason() + "; remote address: " + (remoteAddr != null ? remoteAddr : "") + "; request: " + result.getRequest() + "; context: " + result.toContextString()));
        }
    }

    private User getActiveUser() throws IOException {
        User user = RequestContext.getRequestUser();
        if (!RequestContext.isInRequestContext()) {
            user = this.userProvider.getCurrent();
        }
        return user;
    }

    private void requirePermission(String request, byte[] tableName, byte[] family, byte[] qualifier, Permission.Action ... permissions) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, tableName, family, qualifier, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, family, qualifier);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, family, qualifier);
        }
        this.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    private void requirePermission(String request, Permission.Action perm) throws IOException {
        this.requireGlobalPermission(request, perm, null, null);
    }

    public void requirePermission(String request, Permission.Action perm, RegionCoprocessorEnvironment env, Map<byte[], ? extends Collection<?>> families) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = this.permissionGranted(request, user, perm, env, families);
        this.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions (table=" + env.getRegion().getTableDesc().getNameAsString() + (families != null && families.size() > 0 ? ", family: " + result.toFamilyString() : "") + ", action=" + perm.toString() + ")");
        }
    }

    private void requireGlobalPermission(String request, Permission.Action perm, byte[] tableName, Map<byte[], ? extends Collection<byte[]>> familyMap) throws IOException {
        User user = this.getActiveUser();
        if (!this.authManager.authorize(user, perm)) {
            this.logResult(AuthResult.deny(request, "Global check failed", user, perm, tableName, familyMap));
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
        }
        this.logResult(AuthResult.allow(request, "Global check allowed", user, perm, tableName, familyMap));
    }

    private boolean hasFamilyQualifierPermission(User user, Permission.Action perm, RegionCoprocessorEnvironment env, Map<byte[], ? extends Set<byte[]>> familyMap) throws IOException {
        HRegionInfo hri = env.getRegion().getRegionInfo();
        byte[] tableName = hri.getTableName();
        if (user == null) {
            return false;
        }
        if (familyMap != null && familyMap.size() > 0) {
            for (Map.Entry<byte[], ? extends Set<byte[]>> family : familyMap.entrySet()) {
                if (family.getValue() != null && !family.getValue().isEmpty()) {
                    for (byte[] qualifier : family.getValue()) {
                        if (!this.authManager.matchPermission(user, tableName, family.getKey(), qualifier, perm)) continue;
                        return true;
                    }
                    continue;
                }
                if (!this.authManager.matchPermission(user, tableName, family.getKey(), perm)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Empty family map passed for permission check");
        }
        return false;
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        ZooKeeperWatcher zk = null;
        if (env instanceof MasterCoprocessorEnvironment) {
            MasterCoprocessorEnvironment mEnv = (MasterCoprocessorEnvironment)env;
            zk = mEnv.getMasterServices().getZooKeeper();
        } else if (env instanceof RegionServerCoprocessorEnvironment) {
            RegionServerCoprocessorEnvironment rsEnv = (RegionServerCoprocessorEnvironment)env;
            zk = rsEnv.getRegionServerServices().getZooKeeper();
        } else if (env instanceof RegionCoprocessorEnvironment) {
            this.regionEnv = (RegionCoprocessorEnvironment)env;
            zk = this.regionEnv.getRegionServerServices().getZooKeeper();
        }
        this.userProvider = UserProvider.instantiate(env.getConfiguration());
        if (zk != null) {
            try {
                this.authManager = TableAuthManager.get(zk, env.getConfiguration());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error obtaining TableAuthManager", ioe);
            }
        } else {
            throw new RuntimeException("Error obtaining TableAuthManager, zk found null.");
        }
    }

    @Override
    public void stop(CoprocessorEnvironment env) {
    }

    @Override
    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        Set<byte[]> families = desc.getFamiliesKeys();
        HashMap familyMap = Maps.newHashMapWithExpectedSize((int)families.size());
        for (byte[] family : families) {
            familyMap.put(family, null);
        }
        this.requireGlobalPermission("createTable", Permission.Action.CREATE, desc.getName(), familyMap);
    }

    @Override
    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        if (!AccessControlLists.isAclTable(desc)) {
            String owner = desc.getOwnerString();
            if (owner == null) {
                owner = this.getActiveUser().getShortName();
            }
            UserPermission userperm = new UserPermission(Bytes.toBytes(owner), desc.getName(), null, Permission.Action.values());
            AccessControlLists.addUserPermission(c.getEnvironment().getConfiguration(), userperm);
        }
    }

    @Override
    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName) throws IOException {
        this.requirePermission("deleteTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName) throws IOException {
        AccessControlLists.removeTablePermissions(c.getEnvironment().getConfiguration(), tableName);
    }

    @Override
    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, HTableDescriptor htd) throws IOException {
        this.requirePermission("modifyTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, HTableDescriptor htd) throws IOException {
        String owner = htd.getOwnerString();
        if (owner == null) {
            owner = this.getActiveUser().getShortName();
        }
        UserPermission userperm = new UserPermission(Bytes.toBytes(owner), htd.getName(), null, Permission.Action.values());
        AccessControlLists.addUserPermission(c.getEnvironment().getConfiguration(), userperm);
    }

    @Override
    public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, HColumnDescriptor column) throws IOException {
        this.requirePermission("addColumn", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void postAddColumn(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        this.requirePermission("modifyColumn", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void postModifyColumn(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, byte[] col) throws IOException {
        this.requirePermission("deleteColumn", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void postDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, byte[] col) throws IOException {
        AccessControlLists.removeTablePermissions(c.getEnvironment().getConfiguration(), tableName, col);
    }

    @Override
    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName) throws IOException {
        this.requirePermission("enableTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName) throws IOException {
    }

    @Override
    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName) throws IOException {
        if (Bytes.equals(tableName, AccessControlLists.ACL_GLOBAL_NAME)) {
            throw new AccessDeniedException("Not allowed to disable _acl_ table.");
        }
        this.requirePermission("disableTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName) throws IOException {
    }

    @Override
    public void preMove(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        this.requirePermission("move", region.getTableName(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postMove(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
    }

    @Override
    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        this.requirePermission("assign", regionInfo.getTableName(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postAssign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
    }

    @Override
    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo, boolean force) throws IOException {
        this.requirePermission("unassign", regionInfo.getTableName(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo, boolean force) throws IOException {
    }

    @Override
    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("balance", Permission.Action.ADMIN);
    }

    @Override
    public void postBalance(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
    }

    @Override
    public boolean preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean newValue) throws IOException {
        this.requirePermission("balanceSwitch", Permission.Action.ADMIN);
        return newValue;
    }

    @Override
    public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean oldValue, boolean newValue) throws IOException {
    }

    @Override
    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("shutdown", Permission.Action.ADMIN);
    }

    @Override
    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("stopMaster", Permission.Action.ADMIN);
    }

    @Override
    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        AccessControlLists.init(ctx.getEnvironment().getMasterServices());
    }

    @Override
    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission("snapshot", Permission.Action.ADMIN);
    }

    @Override
    public void postSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission("cloneSnapshot", Permission.Action.ADMIN);
    }

    @Override
    public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission("restoreSnapshot", Permission.Action.ADMIN);
    }

    @Override
    public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        this.requirePermission("deleteSnapshot", Permission.Action.ADMIN);
    }

    @Override
    public void postDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
    }

    @Override
    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        RegionCoprocessorEnvironment env = e.getEnvironment();
        HRegion region = env.getRegion();
        if (region == null) {
            LOG.error((Object)"NULL region from RegionCoprocessorEnvironment in preOpen()");
            return;
        }
        HRegionInfo regionInfo = region.getRegionInfo();
        if (this.isSpecialTable(regionInfo)) {
            this.isSystemOrSuperUser(this.regionEnv.getConfiguration());
        } else {
            this.requirePermission("open", Permission.Action.ADMIN);
        }
    }

    @Override
    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        RegionCoprocessorEnvironment env = c.getEnvironment();
        HRegion region = env.getRegion();
        if (region == null) {
            LOG.error((Object)"NULL region from RegionCoprocessorEnvironment in postOpen()");
            return;
        }
        if (AccessControlLists.isAclRegion(region)) {
            this.aclRegion = true;
            try {
                this.initialize(env);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to initialize permissions cache", ex);
            }
        }
    }

    @Override
    public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        this.requirePermission("flush", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        this.requirePermission("split", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner) throws IOException {
        this.requirePermission("compact", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
        return scanner;
    }

    @Override
    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> e, Store store, List<StoreFile> candidates) throws IOException {
        this.requirePermission("compactSelection", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        this.requirePermission("getClosestRowBefore", Permission.Action.READ, c.getEnvironment(), this.makeFamilyMap(family, null));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void preGet(ObserverContext<RegionCoprocessorEnvironment> c, Get get2, List<KeyValue> result) throws IOException {
        RegionCoprocessorEnvironment e = c.getEnvironment();
        User requestUser = this.getActiveUser();
        AuthResult authResult = this.permissionGranted("get", requestUser, Permission.Action.READ, e, get2.getFamilyMap());
        if (authResult.isAllowed()) {
            this.logResult(authResult);
            return;
        }
        if (!this.hasFamilyQualifierPermission(requestUser, Permission.Action.READ, e, get2.getFamilyMap())) {
            this.logResult(authResult);
            throw new AccessDeniedException("Insufficient permissions (table=" + e.getRegion().getTableDesc().getNameAsString() + ", action=READ)");
        }
        byte[] table = this.getTableName(e);
        AccessControlFilter filter = new AccessControlFilter(this.authManager, requestUser, table);
        if (get2.getFilter() != null) {
            FilterList wrapper = new FilterList(FilterList.Operator.MUST_PASS_ALL, Lists.newArrayList((Object[])new Filter[]{filter, get2.getFilter()}));
            get2.setFilter(wrapper);
        } else {
            get2.setFilter(filter);
        }
        this.logResult(AuthResult.allow("get", "Access allowed with filter", requestUser, Permission.Action.READ, authResult.getTable(), get2.getFamilyMap()));
    }

    @Override
    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get2, boolean exists2) throws IOException {
        this.requirePermission("exists", Permission.Action.READ, c.getEnvironment(), get2.getFamilyMap());
        return exists2;
    }

    @Override
    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put2, WALEdit edit, boolean writeToWAL) throws IOException {
        this.requirePermission("put", Permission.Action.WRITE, c.getEnvironment(), put2.getFamilyMap());
    }

    @Override
    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put2, WALEdit edit, boolean writeToWAL) {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), put2.getFamilyMap());
        }
    }

    @Override
    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, boolean writeToWAL) throws IOException {
        this.requirePermission("delete", Permission.Action.WRITE, c.getEnvironment(), delete.getFamilyMap());
    }

    @Override
    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, boolean writeToWAL) throws IOException {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), delete.getFamilyMap());
        }
    }

    @Override
    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Put put2, boolean result) throws IOException {
        Map<byte[], ? extends Collection<byte[]>> familyMap = this.makeFamilyMap(family, qualifier);
        this.requirePermission("checkAndPut", Permission.Action.READ, c.getEnvironment(), familyMap);
        this.requirePermission("checkAndPut", Permission.Action.WRITE, c.getEnvironment(), familyMap);
        return result;
    }

    @Override
    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        Map<byte[], ? extends Collection<byte[]>> familyMap = this.makeFamilyMap(family, qualifier);
        this.requirePermission("checkAndDelete", Permission.Action.READ, c.getEnvironment(), familyMap);
        this.requirePermission("checkAndDelete", Permission.Action.WRITE, c.getEnvironment(), familyMap);
        return result;
    }

    @Override
    public long preIncrementColumnValue(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        Map<byte[], ? extends Collection<byte[]>> familyMap = this.makeFamilyMap(family, qualifier);
        this.requirePermission("incrementColumnValue", Permission.Action.WRITE, c.getEnvironment(), familyMap);
        return -1L;
    }

    @Override
    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        this.requirePermission("append", Permission.Action.WRITE, c.getEnvironment(), append.getFamilyMap());
        return null;
    }

    @Override
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment2) throws IOException {
        HashMap familyMap = Maps.newHashMap();
        for (Map.Entry<byte[], NavigableMap<byte[], Long>> entry : increment2.getFamilyMap().entrySet()) {
            familyMap.put(entry.getKey(), ((Map)entry.getValue()).keySet());
        }
        this.requirePermission("increment", Permission.Action.WRITE, c.getEnvironment(), familyMap);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        String string;
        RegionCoprocessorEnvironment e = c.getEnvironment();
        User user = this.getActiveUser();
        AuthResult authResult = this.permissionGranted("scannerOpen", user, Permission.Action.READ, e, scan.getFamilyMap());
        if (authResult.isAllowed()) {
            this.logResult(authResult);
            return s;
        }
        if (this.hasFamilyQualifierPermission(user, Permission.Action.READ, e, scan.getFamilyMap())) {
            byte[] table = this.getTableName(e);
            AccessControlFilter filter = new AccessControlFilter(this.authManager, user, table);
            if (scan.hasFilter()) {
                FilterList wrapper = new FilterList(FilterList.Operator.MUST_PASS_ALL, Lists.newArrayList((Object[])new Filter[]{filter, scan.getFilter()}));
                scan.setFilter(wrapper);
            } else {
                scan.setFilter(filter);
            }
            this.logResult(AuthResult.allow("scannerOpen", "Access allowed with filter", user, Permission.Action.READ, authResult.getTable(), scan.getFamilyMap()));
            return s;
        }
        this.logResult(authResult);
        StringBuilder stringBuilder = new StringBuilder().append("Insufficient permissions for user '");
        if (user != null) {
            string = user.getShortName();
            throw new AccessDeniedException(stringBuilder.append(string).append("' ").append("for scanner open on table ").append(Bytes.toString(this.getTableName(e))).toString());
        }
        string = "null";
        throw new AccessDeniedException(stringBuilder.append(string).append("' ").append("for scanner open on table ").append(Bytes.toString(this.getTableName(e))).toString());
    }

    @Override
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        User user = this.getActiveUser();
        if (user != null && user.getShortName() != null) {
            this.scannerOwners.put(s, user.getShortName());
        }
        return s;
    }

    @Override
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        this.requireScannerOwner(s);
        return hasNext;
    }

    @Override
    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.requireScannerOwner(s);
    }

    @Override
    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.scannerOwners.remove(s);
    }

    private void requireScannerOwner(InternalScanner s) throws AccessDeniedException {
        if (RequestContext.isInRequestContext()) {
            String requestUserName = RequestContext.getRequestUserName();
            String owner = this.scannerOwners.get(s);
            if (owner != null && !owner.equals(requestUserName)) {
                throw new AccessDeniedException("User '" + requestUserName + "' is not the scanner owner!");
            }
        }
    }

    @Override
    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        LinkedList cfs = new LinkedList();
        for (Pair<byte[], String> el : familyPaths) {
            this.requirePermission("preBulkLoadHFile", ctx.getEnvironment().getRegion().getTableDesc().getName(), el.getFirst(), null, Permission.Action.WRITE);
        }
    }

    private AuthResult hasSomeAccess(RegionCoprocessorEnvironment e, String request, Permission.Action action) throws IOException {
        User requestUser = this.getActiveUser();
        byte[] tableName = e.getRegion().getTableDesc().getName();
        AuthResult authResult = this.permissionGranted(request, requestUser, action, e, Collections.EMPTY_MAP);
        if (!authResult.isAllowed()) {
            for (UserPermission userPerm : AccessControlLists.getUserPermissions(this.regionEnv.getConfiguration(), tableName)) {
                for (Permission.Action userAction : userPerm.getActions()) {
                    if (!userAction.equals((Object)action)) continue;
                    return AuthResult.allow(request, "Access allowed", requestUser, action, tableName, null, null);
                }
            }
        }
        return authResult;
    }

    public void prePrepareBulkLoad(RegionCoprocessorEnvironment e) throws IOException {
        AuthResult authResult = this.hasSomeAccess(e, "prepareBulkLoad", Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions (table=" + e.getRegion().getTableDesc().getNameAsString() + ", action=WRITE)");
        }
    }

    public void preCleanupBulkLoad(RegionCoprocessorEnvironment e) throws IOException {
        AuthResult authResult = this.hasSomeAccess(e, "cleanupBulkLoad", Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions (table=" + e.getRegion().getTableDesc().getNameAsString() + ", action=WRITE)");
        }
    }

    @Override
    public void grant(UserPermission perm) throws IOException {
        if (this.aclRegion) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received request to grant access permission " + perm.toString()));
            }
            this.requirePermission("grant", perm.getTable(), perm.getFamily(), perm.getQualifier(), Permission.Action.ADMIN);
            AccessControlLists.addUserPermission(this.regionEnv.getConfiguration(), perm);
            if (AUDITLOG.isTraceEnabled()) {
                AUDITLOG.trace((Object)("Granted permission " + perm.toString()));
            }
        } else {
            throw new CoprocessorException(AccessController.class, "This method can only execute at " + Bytes.toString(AccessControlLists.ACL_TABLE_NAME) + " table.");
        }
    }

    @Override
    @Deprecated
    public void grant(byte[] user, TablePermission permission) throws IOException {
        this.grant(new UserPermission(user, permission.getTable(), permission.getFamily(), permission.getQualifier(), permission.getActions()));
    }

    @Override
    public void revoke(UserPermission perm) throws IOException {
        if (this.aclRegion) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received request to revoke access permission " + perm.toString()));
            }
            this.requirePermission("revoke", perm.getTable(), perm.getFamily(), perm.getQualifier(), Permission.Action.ADMIN);
            AccessControlLists.removeUserPermission(this.regionEnv.getConfiguration(), perm);
            if (AUDITLOG.isTraceEnabled()) {
                AUDITLOG.trace((Object)("Revoked permission " + perm.toString()));
            }
        } else {
            throw new CoprocessorException(AccessController.class, "This method can only execute at " + Bytes.toString(AccessControlLists.ACL_TABLE_NAME) + " table.");
        }
    }

    @Override
    @Deprecated
    public void revoke(byte[] user, TablePermission permission) throws IOException {
        this.revoke(new UserPermission(user, permission.getTable(), permission.getFamily(), permission.getQualifier(), permission.getActions()));
    }

    @Override
    public List<UserPermission> getUserPermissions(byte[] tableName) throws IOException {
        if (this.aclRegion) {
            this.requirePermission("userPermissions", tableName, null, null, Permission.Action.ADMIN);
            List<UserPermission> perms = AccessControlLists.getUserPermissions(this.regionEnv.getConfiguration(), tableName);
            return perms;
        }
        throw new CoprocessorException(AccessController.class, "This method can only execute at " + Bytes.toString(AccessControlLists.ACL_TABLE_NAME) + " table.");
    }

    @Override
    public void checkPermissions(Permission[] permissions) throws IOException {
        byte[] tableName = this.regionEnv.getRegion().getTableDesc().getName();
        for (Permission permission : permissions) {
            if (permission instanceof TablePermission) {
                TablePermission tperm = (TablePermission)permission;
                for (Permission.Action action : permission.getActions()) {
                    if (!Arrays.equals(tperm.getTable(), tableName)) {
                        throw new CoprocessorException(AccessController.class, String.format("This method can only execute at the table specified in TablePermission. Table of the region:%s , requested table:%s", Bytes.toString(tableName), Bytes.toString(tperm.getTable())));
                    }
                    HashMap familyMap = Maps.newHashMapWithExpectedSize((int)1);
                    if (tperm.getFamily() != null) {
                        if (tperm.getQualifier() != null) {
                            familyMap.put(tperm.getFamily(), Sets.newHashSet((Object[])new byte[][]{tperm.getQualifier()}));
                        } else {
                            familyMap.put(tperm.getFamily(), null);
                        }
                    }
                    this.requirePermission("checkPermissions", action, this.regionEnv, familyMap);
                }
                continue;
            }
            for (Permission.Action action : permission.getActions()) {
                this.requirePermission("checkPermissions", action);
            }
        }
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        return 1L;
    }

    @Override
    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        if (AccessControllerProtocol.class.getName().equals(protocol)) {
            return new ProtocolSignature(1L, null);
        }
        throw new HBaseRPC.UnknownProtocolException("Unexpected protocol requested: " + protocol);
    }

    private byte[] getTableName(RegionCoprocessorEnvironment e) {
        HRegionInfo regionInfo;
        HRegion region = e.getRegion();
        byte[] tableName = null;
        if (region != null && (regionInfo = region.getRegionInfo()) != null) {
            tableName = regionInfo.getTableName();
        }
        return tableName;
    }

    private Map<byte[], ? extends Collection<byte[]>> makeFamilyMap(byte[] family, byte[] qualifier) {
        if (family == null) {
            return null;
        }
        HashMap familyMap = Maps.newHashMapWithExpectedSize((int)1);
        familyMap.put(family, qualifier != null ? ImmutableSet.of((Object)qualifier) : null);
        return familyMap;
    }

    @Override
    public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) throws IOException {
        this.requirePermission("close", Permission.Action.ADMIN);
    }

    @Override
    public void preLockRow(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] regionName, byte[] row) throws IOException {
        this.requirePermission("lockRow", this.getTableName(ctx.getEnvironment()), null, null, Permission.Action.WRITE, Permission.Action.CREATE);
    }

    @Override
    public void preUnlockRow(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] regionName, long lockId) throws IOException {
        this.requirePermission("unlockRow", this.getTableName(ctx.getEnvironment()), null, null, Permission.Action.WRITE, Permission.Action.CREATE);
    }

    private void isSystemOrSuperUser(Configuration conf) throws IOException {
        User activeUser;
        User user = this.userProvider.getCurrent();
        if (user == null) {
            throw new IOException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        String currentUser = user.getShortName();
        List superusers = Lists.asList((Object)currentUser, (Object[])conf.getStrings("hbase.superuser", new String[0]));
        if (!superusers.contains((activeUser = this.getActiveUser()).getShortName())) {
            throw new AccessDeniedException("User '" + (user != null ? user.getShortName() : "null") + "is not system or super user.");
        }
    }

    private boolean isSpecialTable(HRegionInfo regionInfo) {
        byte[] tableName = regionInfo.getTableName();
        return tableName.equals(AccessControlLists.ACL_TABLE_NAME) || tableName.equals(Bytes.toBytes("-ROOT-")) || tableName.equals(Bytes.toBytes(".META."));
    }

    @Override
    public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> env) throws IOException {
        this.requirePermission("stop", Permission.Action.ADMIN);
    }

    @Override
    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<String> tableNamesList, List<HTableDescriptor> descriptors) throws IOException {
        if (tableNamesList == null || tableNamesList.isEmpty()) {
            this.requirePermission("getTableDescriptors", Permission.Action.ADMIN);
        } else {
            MasterServices masterServices = ctx.getEnvironment().getMasterServices();
            for (String tableName : tableNamesList) {
                byte[] nameAsBytes = Bytes.toBytes(tableName);
                try {
                    masterServices.checkTableModifiable(nameAsBytes);
                }
                catch (TableNotFoundException ex) {
                    continue;
                }
                catch (TableNotDisabledException ex) {
                    // empty catch block
                }
                this.requirePermission("getTableDescriptors", nameAsBytes, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
            }
        }
    }

    @Override
    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors) throws IOException {
    }
}

