/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.ClientSideRegionScanner;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableRecordReaderImpl;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MapReduceProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TableSnapshotInputFormat
extends InputFormat<ImmutableBytesWritable, Result> {
    private static final Log LOG = LogFactory.getLog(TableSnapshotInputFormat.class);
    private static final String LOCALITY_CUTOFF_MULTIPLIER = "hbase.tablesnapshotinputformat.locality.cutoff.multiplier";
    private static final float DEFAULT_LOCALITY_CUTOFF_MULTIPLIER = 0.8f;
    private static final String SNAPSHOT_NAME_KEY = "hbase.TableSnapshotInputFormat.snapshot.name";
    private static final String TABLE_DIR_KEY = "hbase.TableSnapshotInputFormat.table.dir";

    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new TableSnapshotRegionRecordReader();
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
        HBaseProtos.SnapshotDescription snapshotDesc;
        Path snapshotDir;
        Configuration conf = job.getConfiguration();
        String snapshotName = TableSnapshotInputFormat.getSnapshotName(conf);
        Path rootDir = FSUtils.getRootDir(conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        SnapshotManifest manifest = SnapshotManifest.open(conf, fs, snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, rootDir), snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir));
        List<SnapshotProtos.SnapshotRegionManifest> regionManifests = manifest.getRegionManifests();
        if (regionManifests == null) {
            throw new IllegalArgumentException("Snapshot seems empty");
        }
        HTableDescriptor htd = manifest.getTableDescriptor();
        Scan scan = TableMapReduceUtil.convertStringToScan(conf.get("hbase.mapreduce.scan"));
        Path tableDir = new Path(conf.get(TABLE_DIR_KEY));
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (SnapshotProtos.SnapshotRegionManifest regionManifest : regionManifests) {
            HRegionInfo hri = HRegionInfo.convert((HBaseProtos.RegionInfo)regionManifest.getRegionInfo());
            if (!CellUtil.overlappingKeys((byte[])scan.getStartRow(), (byte[])scan.getStopRow(), (byte[])hri.getStartKey(), (byte[])hri.getEndKey())) continue;
            List<String> hosts = this.getBestLocations(conf, HRegion.computeHDFSBlocksDistribution(conf, htd, hri, tableDir));
            int len = Math.min(3, hosts.size());
            hosts = hosts.subList(0, len);
            splits.add(new TableSnapshotRegionSplit(htd, hri, hosts));
        }
        return splits;
    }

    @VisibleForTesting
    List<String> getBestLocations(Configuration conf, HDFSBlocksDistribution blockDistribution) {
        ArrayList<String> locations = new ArrayList<String>(3);
        HDFSBlocksDistribution.HostAndWeight[] hostAndWeights = blockDistribution.getTopHostsWithWeights();
        if (hostAndWeights.length == 0) {
            return locations;
        }
        HDFSBlocksDistribution.HostAndWeight topHost = hostAndWeights[0];
        locations.add(topHost.getHost());
        double cutoffMultiplier = conf.getFloat(LOCALITY_CUTOFF_MULTIPLIER, 0.8f);
        double filterWeight = (double)topHost.getWeight() * cutoffMultiplier;
        for (int i = 1; i < hostAndWeights.length && (double)hostAndWeights[i].getWeight() >= filterWeight; ++i) {
            locations.add(hostAndWeights[i].getHost());
        }
        return locations;
    }

    public static void setInput(Job job, String snapshotName, Path restoreDir) throws IOException {
        Configuration conf = job.getConfiguration();
        conf.set(SNAPSHOT_NAME_KEY, snapshotName);
        Path rootDir = FSUtils.getRootDir(conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        restoreDir = new Path(restoreDir, UUID.randomUUID().toString());
        RestoreSnapshotHelper.copySnapshotForScanner(conf, fs, rootDir, restoreDir, snapshotName);
        conf.set(TABLE_DIR_KEY, restoreDir.toString());
    }

    private static String getSnapshotName(Configuration conf) {
        String snapshotName = conf.get(SNAPSHOT_NAME_KEY);
        if (snapshotName == null) {
            throw new IllegalArgumentException("Snapshot name must be provided");
        }
        return snapshotName;
    }

    @VisibleForTesting
    static class TableSnapshotRegionRecordReader
    extends RecordReader<ImmutableBytesWritable, Result> {
        private TableSnapshotRegionSplit split;
        private Scan scan;
        private Result result = null;
        private ImmutableBytesWritable row = null;
        private ClientSideRegionScanner scanner;
        private TaskAttemptContext context;
        private Method getCounter;

        TableSnapshotRegionRecordReader() {
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            this.split = (TableSnapshotRegionSplit)split;
            HTableDescriptor htd = this.split.htd;
            HRegionInfo hri = this.split.regionInfo;
            FileSystem fs = FSUtils.getCurrentFileSystem(conf);
            Path tmpRootDir = new Path(conf.get(TableSnapshotInputFormat.TABLE_DIR_KEY));
            String scanStr = conf.get("hbase.mapreduce.scan");
            if (scanStr == null) {
                throw new IllegalArgumentException("A Scan is not configured for this job");
            }
            this.scan = TableMapReduceUtil.convertStringToScan(scanStr);
            this.scan.setIsolationLevel(IsolationLevel.READ_UNCOMMITTED);
            this.scan.setCacheBlocks(false);
            this.scanner = new ClientSideRegionScanner(conf, fs, tmpRootDir, htd, hri, this.scan, null);
            this.context = context;
            this.getCounter = TableRecordReaderImpl.retrieveGetCounterWithStringsParams(context);
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            this.result = this.scanner.next();
            if (this.result == null) {
                return false;
            }
            if (this.row == null) {
                this.row = new ImmutableBytesWritable();
            }
            this.row.set(this.result.getRow());
            ScanMetrics scanMetrics = this.scanner.getScanMetrics();
            if (scanMetrics != null && this.context != null) {
                TableRecordReaderImpl.updateCounters(scanMetrics, 0L, this.getCounter, this.context);
            }
            return true;
        }

        public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
            return this.row;
        }

        public Result getCurrentValue() throws IOException, InterruptedException {
            return this.result;
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public void close() throws IOException {
            if (this.scanner != null) {
                this.scanner.close();
            }
        }
    }

    @VisibleForTesting
    static class TableSnapshotRegionSplit
    extends InputSplit
    implements Writable {
        private HTableDescriptor htd;
        private HRegionInfo regionInfo;
        private String[] locations;

        public TableSnapshotRegionSplit() {
        }

        TableSnapshotRegionSplit(HTableDescriptor htd, HRegionInfo regionInfo, List<String> locations) {
            this.htd = htd;
            this.regionInfo = regionInfo;
            this.locations = locations == null || locations.isEmpty() ? new String[0] : locations.toArray(new String[locations.size()]);
        }

        public long getLength() throws IOException, InterruptedException {
            return 0L;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return this.locations;
        }

        public void write(DataOutput out) throws IOException {
            MapReduceProtos.TableSnapshotRegionSplit.Builder builder = MapReduceProtos.TableSnapshotRegionSplit.newBuilder().setTable(this.htd.convert()).setRegion(HRegionInfo.convert((HRegionInfo)this.regionInfo));
            for (String location : this.locations) {
                builder.addLocations(location);
            }
            MapReduceProtos.TableSnapshotRegionSplit split = builder.build();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            split.writeTo((OutputStream)baos);
            baos.close();
            byte[] buf = baos.toByteArray();
            out.writeInt(buf.length);
            out.write(buf);
        }

        public void readFields(DataInput in) throws IOException {
            int len = in.readInt();
            byte[] buf = new byte[len];
            in.readFully(buf);
            MapReduceProtos.TableSnapshotRegionSplit split = (MapReduceProtos.TableSnapshotRegionSplit)MapReduceProtos.TableSnapshotRegionSplit.PARSER.parseFrom(buf);
            this.htd = HTableDescriptor.convert((HBaseProtos.TableSchema)split.getTable());
            this.regionInfo = HRegionInfo.convert((HBaseProtos.RegionInfo)split.getRegion());
            List locationsList = split.getLocationsList();
            this.locations = locationsList.toArray(new String[locationsList.size()]);
        }
    }
}

