/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.karaf.util.DeployerUtils;
import org.apache.karaf.util.maven.Parser;
import org.pentaho.osgi.platform.plugin.deployer.ExceptionPipedInputStream;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginFileHandler;
import org.pentaho.osgi.platform.plugin.deployer.impl.PluginZipFileProcessor;

public class PlatformPluginBundlingURLConnection
extends URLConnection {
    public static final int TEN_MEGABYTES = 0xA00000;
    private static final Pattern maxSizePattern = Pattern.compile("maxSize=([0-9]+)");
    private final List<PluginFileHandler> pluginFileHandlers;
    private static ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            thread.setName("PlatformPluginBundlingURLConnection pool");
            return thread;
        }
    });

    public PlatformPluginBundlingURLConnection(URL u, List<PluginFileHandler> pluginFileHandlers) {
        super(u);
        this.pluginFileHandlers = pluginFileHandlers;
    }

    public static int getMaxSize(String query) {
        Matcher matcher;
        if (query != null && (matcher = maxSizePattern.matcher(query)).matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 0xA00000;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        String[] nameVersion;
        ExceptionPipedInputStream pipedInputStream = new ExceptionPipedInputStream(PlatformPluginBundlingURLConnection.getMaxSize(this.getURL().getQuery()));
        String path = this.getURL().toString();
        if (path.startsWith("file:")) {
            String artifactName = path.substring(path.lastIndexOf("/") + 1);
            nameVersion = new String[]{artifactName.substring(0, artifactName.lastIndexOf(".") == -1 ? artifactName.length() : artifactName.lastIndexOf(".")), "0.0.0"};
        } else {
            Parser parser = new Parser(path);
            String mvnPath = parser.getArtifactPath();
            int lastSlash = mvnPath.lastIndexOf(47);
            if (lastSlash >= 0) {
                mvnPath = mvnPath.substring(lastSlash + 1);
            }
            nameVersion = DeployerUtils.extractNameVersionType(mvnPath);
        }
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream(pipedOutputStream);
        URLConnection connection = this.getURL().openConnection();
        InputStream connectionInputStream = connection.getInputStream();
        ZipInputStream zipInputStream = new ZipInputStream(connectionInputStream);
        PluginZipFileProcessor pluginZipFileProcessor = new PluginZipFileProcessor(this.pluginFileHandlers, nameVersion[0], nameVersion[0], nameVersion[1]);
        pluginZipFileProcessor.processBackground(executorService, zipInputStream, zipOutputStream, pipedInputStream);
        return pipedInputStream;
    }
}

