/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.hibernate.usertypes;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;
import org.pentaho.platform.repository.messages.Messages;

public class LongStringUserType
implements UserType {
    private static final Log log = LogFactory.getLog(LongStringUserType.class);
    private static final boolean debug = true;
    private static final int[] SQLTYPE = new int[]{2005};

    public int[] sqlTypes() {
        return SQLTYPE;
    }

    public Class returnedClass() {
        return StringBuffer.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null || !(x instanceof StringBuffer) || !(y instanceof StringBuffer)) {
            return false;
        }
        return x.toString().equals(y.toString());
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        log.debug((Object)Messages.getInstance().getString("LONGSTRTYPE.DEBUG_NULL_SAFE_GET"));
        String longStr = rs.getString(names[0]);
        return longStr != null ? new StringBuffer(longStr) : null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        log.debug((Object)Messages.getInstance().getString("LONGSTRTYPE.DEBUG_NULL_SAFE_SET"));
        if (value != null) {
            StringReader rdr = new StringReader(value.toString());
            int sLen = ((StringBuffer)value).length();
            st.setCharacterStream(index, (Reader)rdr, sLen);
        } else {
            st.setNull(index, SQLTYPE[0]);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return new StringBuffer(value.toString());
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

