/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.userroledao.ws;

import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.core.mt.Tenant;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.security.userroledao.PentahoRole;
import org.pentaho.platform.security.userroledao.PentahoUser;
import org.pentaho.platform.security.userroledao.ws.ProxyPentahoRole;
import org.pentaho.platform.security.userroledao.ws.ProxyPentahoUser;
import org.springframework.security.authentication.encoding.PasswordEncoder;

public class ProxyPentahoUserRoleHelper {
    public static ProxyPentahoUser toProxyUser(IPentahoUser user) {
        ProxyPentahoUser proxyPentahoUser = new ProxyPentahoUser();
        proxyPentahoUser.setName(user.getUsername());
        proxyPentahoUser.setDescription(user.getDescription());
        proxyPentahoUser.setEnabled(user.isEnabled());
        proxyPentahoUser.setPassword("");
        ITenant tenant = user.getTenant();
        proxyPentahoUser.setTenant(new Tenant(tenant.getId(), Boolean.valueOf(tenant.isEnabled())));
        return proxyPentahoUser;
    }

    public static IPentahoUser syncUsers(IPentahoUser user, ProxyPentahoUser proxyUser) {
        IPentahoUser syncedUser = user;
        if (syncedUser == null) {
            syncedUser = new PentahoUser(proxyUser.getName());
        }
        syncedUser.setDescription(proxyUser.getDescription());
        if (!StringUtils.isBlank((String)proxyUser.getPassword())) {
            PasswordEncoder encoder = (PasswordEncoder)PentahoSystem.get(PasswordEncoder.class, (String)"passwordEncoder", (IPentahoSession)PentahoSessionHolder.getSession());
            syncedUser.setPassword(encoder.encodePassword(proxyUser.getPassword(), null));
        }
        syncedUser.setEnabled(proxyUser.getEnabled());
        return syncedUser;
    }

    public static IPentahoRole syncRoles(IPentahoRole role, ProxyPentahoRole proxyRole) {
        IPentahoRole syncedRole = role;
        if (syncedRole == null) {
            syncedRole = new PentahoRole(proxyRole.getName());
        }
        syncedRole.setDescription(proxyRole.getDescription());
        return syncedRole;
    }

    public static ProxyPentahoRole toProxyRole(IPentahoRole role) {
        ProxyPentahoRole proxyRole = new ProxyPentahoRole(role.getName());
        proxyRole.setDescription(role.getDescription());
        ITenant tenant = role.getTenant();
        proxyRole.setTenant(new Tenant(tenant.getId(), Boolean.valueOf(tenant.isEnabled())));
        return proxyRole;
    }
}

