/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.queue;

import com.microsoft.windowsazure.storage.DoesServiceRequest;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.RequestOptions;
import com.microsoft.windowsazure.storage.ResultContinuation;
import com.microsoft.windowsazure.storage.ResultContinuationType;
import com.microsoft.windowsazure.storage.ResultSegment;
import com.microsoft.windowsazure.storage.ServiceClient;
import com.microsoft.windowsazure.storage.ServiceProperties;
import com.microsoft.windowsazure.storage.ServiceStats;
import com.microsoft.windowsazure.storage.StorageCredentials;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.core.ExecutionEngine;
import com.microsoft.windowsazure.storage.core.LazySegmentedIterable;
import com.microsoft.windowsazure.storage.core.ListResponse;
import com.microsoft.windowsazure.storage.core.ListingContext;
import com.microsoft.windowsazure.storage.core.SegmentedStorageRequest;
import com.microsoft.windowsazure.storage.core.StorageRequest;
import com.microsoft.windowsazure.storage.core.Utility;
import com.microsoft.windowsazure.storage.queue.CloudQueue;
import com.microsoft.windowsazure.storage.queue.QueueDeserializer;
import com.microsoft.windowsazure.storage.queue.QueueListingDetails;
import com.microsoft.windowsazure.storage.queue.QueueRequest;
import com.microsoft.windowsazure.storage.queue.QueueRequestOptions;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;

public final class CloudQueueClient
extends ServiceClient {
    public CloudQueueClient(URI baseUri, StorageCredentials credentials) {
        this(new StorageUri(baseUri, null), credentials);
    }

    public CloudQueueClient(StorageUri baseUri, StorageCredentials credentials) {
        super(baseUri, credentials);
        this.setTimeoutInMs(30000);
        if (credentials == null) {
            throw new IllegalArgumentException("StorageCredentials cannot be null for the queue service.");
        }
    }

    public CloudQueue getQueueReference(String queueName) throws URISyntaxException, StorageException {
        return new CloudQueue(queueName, this);
    }

    @DoesServiceRequest
    public Iterable<CloudQueue> listQueues() throws StorageException {
        return this.listQueues(null, QueueListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudQueue> listQueues(String prefix) throws StorageException {
        return this.listQueues(prefix, QueueListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudQueue> listQueues(String prefix, QueueListingDetails detailsIncluded, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        return new LazySegmentedIterable<CloudQueueClient, Object, CloudQueue>(this.listQueuesSegmentedImpl(prefix, detailsIncluded, -1, options, segmentedRequest), this, null, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public ResultSegment<CloudQueue> listQueuesSegmented() throws StorageException {
        return this.listQueuesSegmented(null, QueueListingDetails.NONE, 0, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudQueue> listQueuesSegmented(String prefix) throws StorageException {
        return this.listQueuesSegmented(prefix, QueueListingDetails.NONE, 0, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudQueue> listQueuesSegmented(String prefix, QueueListingDetails detailsIncluded, int maxResults, ResultContinuation continuationToken, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        segmentedRequest.setToken(continuationToken);
        return ExecutionEngine.executeWithRetry(this, null, this.listQueuesSegmentedImpl(prefix, detailsIncluded, maxResults, options, segmentedRequest), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, Void, ResultSegment<CloudQueue>> listQueuesSegmentedImpl(String prefix, final QueueListingDetails detailsIncluded, final int maxResults, final QueueRequestOptions options, final SegmentedStorageRequest segmentedRequest) throws StorageException {
        Utility.assertContinuationType(segmentedRequest.getToken(), ResultContinuationType.QUEUE);
        final ListingContext listingContext = new ListingContext(prefix, maxResults);
        StorageRequest<CloudQueueClient, Void, ResultSegment<CloudQueue>> getRequest = new StorageRequest<CloudQueueClient, Void, ResultSegment<CloudQueue>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudQueueClient client, Void parentObject, OperationContext context) throws Exception {
                listingContext.setMarker(segmentedRequest.getToken() != null ? segmentedRequest.getToken().getNextMarker() : null);
                return QueueRequest.list(client.getStorageUri().getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), listingContext, detailsIncluded, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, -1L, null);
            }

            @Override
            public ResultSegment<CloudQueue> preProcessResponse(Void parentObject, CloudQueueClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ResultSegment<CloudQueue> postProcessResponse(HttpURLConnection connection, Void queue, CloudQueueClient client, OperationContext context, ResultSegment<CloudQueue> storageObject) throws Exception {
                ListResponse<CloudQueue> response = QueueDeserializer.getQueues(connection.getInputStream(), client);
                ResultContinuation newToken = null;
                if (response.getNextMarker() != null) {
                    newToken = new ResultContinuation();
                    newToken.setNextMarker(response.getNextMarker());
                    newToken.setContinuationType(ResultContinuationType.QUEUE);
                    newToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                ResultSegment<CloudQueue> resSegment = new ResultSegment<CloudQueue>(response.getResults(), maxResults, newToken);
                segmentedRequest.setToken(resSegment.getContinuationToken());
                return resSegment;
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public ServiceStats getServiceStats() throws StorageException {
        return this.getServiceStats(null, null);
    }

    @DoesServiceRequest
    public ServiceStats getServiceStats(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this);
        return ExecutionEngine.executeWithRetry(this, null, this.getServiceStatsImpl(options, false), this.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final ServiceProperties downloadServiceProperties() throws StorageException {
        return this.downloadServiceProperties(null, null);
    }

    @DoesServiceRequest
    public final ServiceProperties downloadServiceProperties(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this);
        return ExecutionEngine.executeWithRetry(this, null, this.downloadServicePropertiesImpl(options, false), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties) throws StorageException {
        this.uploadServiceProperties(properties, null, null);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (!Utility.isNullOrEmpty(properties.getDefaultServiceVersion())) {
            throw new IllegalArgumentException("DefaultServiceVersion can only be set for the Blob service.");
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this);
        Utility.assertNotNull("properties", properties);
        ExecutionEngine.executeWithRetry(this, null, this.uploadServicePropertiesImpl(properties, options, opContext, false), options.getRetryPolicyFactory(), opContext);
    }
}

