/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.queue;

import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.core.DeserializationHelper;
import com.microsoft.windowsazure.storage.core.ListResponse;
import com.microsoft.windowsazure.storage.core.PathUtility;
import com.microsoft.windowsazure.storage.core.Utility;
import com.microsoft.windowsazure.storage.queue.CloudQueue;
import com.microsoft.windowsazure.storage.queue.CloudQueueClient;
import com.microsoft.windowsazure.storage.queue.CloudQueueMessage;
import com.microsoft.windowsazure.storage.queue.QueueMessageType;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class QueueDeserializer {
    QueueDeserializer() {
    }

    public static ListResponse<CloudQueue> getQueues(InputStream stream, CloudQueueClient serviceClient) throws XMLStreamException, StorageException {
        XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromStream(stream);
        ListResponse<CloudQueue> queues = new ListResponse<CloudQueue>();
        String tempParseString = null;
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "EnumerationResults");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("MaxResults")) {
                tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "MaxResults");
                queues.setMaxResults(Integer.parseInt(tempParseString));
                continue;
            }
            if (eventType == 1 && name.equals("Marker")) {
                queues.setMarker(DeserializationHelper.readElementFromXMLReader(xmlr, "Marker"));
                continue;
            }
            if (eventType == 1 && name.equals("NextMarker")) {
                queues.setNextMarker(DeserializationHelper.readElementFromXMLReader(xmlr, "NextMarker"));
                continue;
            }
            if (eventType == 1 && name.equals("Prefix")) {
                queues.setPrefix(DeserializationHelper.readElementFromXMLReader(xmlr, "Prefix"));
                continue;
            }
            if (eventType == 1 && name.equals("Queues")) {
                try {
                    queues.setResults(QueueDeserializer.readQueues(xmlr, serviceClient));
                }
                catch (URISyntaxException e) {
                    throw new XMLStreamException(e);
                }
                catch (ParseException e) {
                    throw new XMLStreamException(e);
                }
                xmlr.require(2, null, "Queues");
                continue;
            }
            if (eventType != 2 || !"EnumerationResults".equals(name)) continue;
            break;
        }
        return queues;
    }

    private static CloudQueue readQueue(XMLStreamReader xmlr, CloudQueueClient serviceClient) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "Queue");
        String queueName = null;
        HashMap<String, String> queueMetadata = null;
        int eventType = xmlr.getEventType();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("Name")) {
                    queueName = DeserializationHelper.readElementFromXMLReader(xmlr, "Name");
                    continue;
                }
                if (!name.equals("Metadata")) continue;
                queueMetadata = DeserializationHelper.parseMetadateFromXML(xmlr);
                xmlr.require(2, null, "Metadata");
                continue;
            }
            if (eventType != 2 || !name.equals("Queue")) continue;
            break;
        }
        StorageUri queueUri = serviceClient.getStorageUri();
        queueUri = PathUtility.appendPathToUri(queueUri, queueName);
        CloudQueue queue = new CloudQueue(queueUri, serviceClient);
        queue.setMetadata(queueMetadata);
        queue.setName(queueName);
        xmlr.require(2, null, "Queue");
        return queue;
    }

    private static ArrayList<CloudQueue> readQueues(XMLStreamReader xmlr, CloudQueueClient serviceClient) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "Queues");
        ArrayList<CloudQueue> queues = new ArrayList<CloudQueue>();
        eventType = xmlr.next();
        while (eventType == 1 && xmlr.hasName() && "Queue".equals(xmlr.getName().toString())) {
            queues.add(QueueDeserializer.readQueue(xmlr, serviceClient));
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "Queues");
        return queues;
    }

    protected static ArrayList<CloudQueueMessage> readMessages(InputStream stream, boolean shouldEncodeMessage) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromStream(stream);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "QueueMessagesList");
        ArrayList<CloudQueueMessage> messages = new ArrayList<CloudQueueMessage>();
        eventType = xmlr.next();
        while (eventType == 1 && xmlr.hasName() && "QueueMessage".equals(xmlr.getName().toString())) {
            messages.add(QueueDeserializer.readMessage(xmlr, shouldEncodeMessage));
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "QueueMessagesList");
        return messages;
    }

    private static CloudQueueMessage readMessage(XMLStreamReader xmlr, boolean shouldEncodeMessage) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "QueueMessage");
        CloudQueueMessage message = new CloudQueueMessage();
        message.setMessageType(shouldEncodeMessage ? QueueMessageType.BASE_64_ENCODED : QueueMessageType.RAW_STRING);
        int eventType = xmlr.getEventType();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("MessageId")) {
                    message.setMessageId(DeserializationHelper.readElementFromXMLReader(xmlr, "MessageId"));
                    continue;
                }
                if (name.equals("InsertionTime")) {
                    message.setInsertionTime(Utility.parseRFC1123DateFromStringInGMT(DeserializationHelper.readElementFromXMLReader(xmlr, "InsertionTime")));
                    continue;
                }
                if (name.equals("ExpirationTime")) {
                    message.setExpirationTime(Utility.parseRFC1123DateFromStringInGMT(DeserializationHelper.readElementFromXMLReader(xmlr, "ExpirationTime")));
                    continue;
                }
                if (name.equals("PopReceipt")) {
                    message.setPopReceipt(DeserializationHelper.readElementFromXMLReader(xmlr, "PopReceipt"));
                    continue;
                }
                if (name.equals("TimeNextVisible")) {
                    message.setNextVisibleTime(Utility.parseRFC1123DateFromStringInGMT(DeserializationHelper.readElementFromXMLReader(xmlr, "TimeNextVisible")));
                    continue;
                }
                if (name.equals("DequeueCount")) {
                    message.setDequeueCount(Integer.parseInt(DeserializationHelper.readElementFromXMLReader(xmlr, "DequeueCount")));
                    continue;
                }
                if (!name.equals("MessageText")) continue;
                message.messageContent = DeserializationHelper.readElementFromXMLReader(xmlr, "MessageText");
                continue;
            }
            if (eventType != 2 || !name.equals("QueueMessage")) continue;
            break;
        }
        xmlr.require(2, null, "QueueMessage");
        return message;
    }
}

