/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.AclEntryStatusFormat;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.QuotaByStorageTypeEntry;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.SaveNamespaceContext;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.apache.hadoop.hdfs.util.ReadOnlyList;

@InterfaceAudience.Private
public final class FSImageFormatPBINode {
    private static final long USER_GROUP_STRID_MASK = 0xFFFFFFL;
    private static final int USER_STRID_OFFSET = 40;
    private static final int GROUP_STRID_OFFSET = 16;
    private static final Log LOG = LogFactory.getLog(FSImageFormatPBINode.class);
    private static final int ACL_ENTRY_NAME_MASK = 0xFFFFFF;
    private static final int ACL_ENTRY_NAME_OFFSET = 6;
    private static final int ACL_ENTRY_TYPE_OFFSET = 3;
    private static final int ACL_ENTRY_SCOPE_OFFSET = 5;
    private static final int ACL_ENTRY_PERM_MASK = 7;
    private static final int ACL_ENTRY_TYPE_MASK = 3;
    private static final int ACL_ENTRY_SCOPE_MASK = 1;
    private static final FsAction[] FSACTION_VALUES = FsAction.values();
    private static final AclEntryScope[] ACL_ENTRY_SCOPE_VALUES = AclEntryScope.values();
    private static final AclEntryType[] ACL_ENTRY_TYPE_VALUES = AclEntryType.values();
    private static final int XATTR_NAMESPACE_MASK = 3;
    private static final int XATTR_NAMESPACE_OFFSET = 30;
    private static final int XATTR_NAME_MASK = 0xFFFFFF;
    private static final int XATTR_NAME_OFFSET = 6;
    private static final int XATTR_NAMESPACE_EXT_OFFSET = 5;
    private static final int XATTR_NAMESPACE_EXT_MASK = 1;
    private static final XAttr.NameSpace[] XATTR_NAMESPACE_VALUES = XAttr.NameSpace.values();

    private FSImageFormatPBINode() {
    }

    public static final class Saver {
        private final FSNamesystem fsn;
        private final FsImageProto.FileSummary.Builder summary;
        private final SaveNamespaceContext context;
        private final FSImageFormatProtobuf.Saver parent;

        private static long buildPermissionStatus(INodeAttributes n, FSImageFormatProtobuf.SaverContext.DeduplicationMap<String> stringMap) {
            long userId = stringMap.getId(n.getUserName());
            long groupId = stringMap.getId(n.getGroupName());
            return (userId & 0xFFFFFFL) << 40 | (groupId & 0xFFFFFFL) << 16 | (long)n.getFsPermissionShort();
        }

        private static FsImageProto.INodeSection.AclFeatureProto.Builder buildAclEntries(AclFeature f, FSImageFormatProtobuf.SaverContext.DeduplicationMap<String> map) {
            FsImageProto.INodeSection.AclFeatureProto.Builder b = FsImageProto.INodeSection.AclFeatureProto.newBuilder();
            for (int pos = 0; pos < f.getEntriesSize(); ++pos) {
                int e = f.getEntryAt(pos);
                int nameId = map.getId(AclEntryStatusFormat.getName(e));
                int v = (nameId & 0xFFFFFF) << 6 | AclEntryStatusFormat.getType(e).ordinal() << 3 | AclEntryStatusFormat.getScope(e).ordinal() << 5 | AclEntryStatusFormat.getPermission(e).ordinal();
                b.addEntries(v);
            }
            return b;
        }

        private static FsImageProto.INodeSection.XAttrFeatureProto.Builder buildXAttrs(XAttrFeature f, FSImageFormatProtobuf.SaverContext.DeduplicationMap<String> stringMap) {
            FsImageProto.INodeSection.XAttrFeatureProto.Builder b = FsImageProto.INodeSection.XAttrFeatureProto.newBuilder();
            for (XAttr a : f.getXAttrs()) {
                FsImageProto.INodeSection.XAttrCompactProto.Builder xAttrCompactBuilder = FsImageProto.INodeSection.XAttrCompactProto.newBuilder();
                int nsOrd = a.getNameSpace().ordinal();
                Preconditions.checkArgument((nsOrd < 8 ? 1 : 0) != 0, (Object)"Too many namespaces.");
                int v = (nsOrd & 3) << 30 | (stringMap.getId(a.getName()) & 0xFFFFFF) << 6;
                xAttrCompactBuilder.setName(v |= (nsOrd >> 2 & 1) << 5);
                if (a.getValue() != null) {
                    xAttrCompactBuilder.setValue(PBHelper.getByteString(a.getValue()));
                }
                b.addXAttrs(xAttrCompactBuilder.build());
            }
            return b;
        }

        private static FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto.Builder buildQuotaByStorageTypeEntries(QuotaCounts q) {
            FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto.Builder b = FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto.newBuilder();
            for (StorageType t : StorageType.getTypesSupportingQuota()) {
                if (q.getTypeSpace(t) < 0L) continue;
                FsImageProto.INodeSection.QuotaByStorageTypeEntryProto.Builder eb = FsImageProto.INodeSection.QuotaByStorageTypeEntryProto.newBuilder().setStorageType(PBHelper.convertStorageType(t)).setQuota(q.getTypeSpace(t));
                b.addQuotas(eb);
            }
            return b;
        }

        public static FsImageProto.INodeSection.INodeFile.Builder buildINodeFile(INodeFileAttributes file, FSImageFormatProtobuf.SaverContext state) {
            XAttrFeature xAttrFeature;
            FsImageProto.INodeSection.INodeFile.Builder b = FsImageProto.INodeSection.INodeFile.newBuilder().setAccessTime(file.getAccessTime()).setModificationTime(file.getModificationTime()).setPermission(Saver.buildPermissionStatus(file, state.getStringMap())).setPreferredBlockSize(file.getPreferredBlockSize()).setReplication(file.getFileReplication()).setStoragePolicyID(file.getLocalStoragePolicyID());
            AclFeature f = file.getAclFeature();
            if (f != null) {
                b.setAcl(Saver.buildAclEntries(f, state.getStringMap()));
            }
            if ((xAttrFeature = file.getXAttrFeature()) != null) {
                b.setXAttrs(Saver.buildXAttrs(xAttrFeature, state.getStringMap()));
            }
            return b;
        }

        public static FsImageProto.INodeSection.INodeDirectory.Builder buildINodeDirectory(INodeDirectoryAttributes dir, FSImageFormatProtobuf.SaverContext state) {
            XAttrFeature xAttrFeature;
            AclFeature f;
            QuotaCounts quota = dir.getQuotaCounts();
            FsImageProto.INodeSection.INodeDirectory.Builder b = FsImageProto.INodeSection.INodeDirectory.newBuilder().setModificationTime(dir.getModificationTime()).setNsQuota(quota.getNameSpace()).setDsQuota(quota.getStorageSpace()).setPermission(Saver.buildPermissionStatus(dir, state.getStringMap()));
            if (quota.getTypeSpaces().anyGreaterOrEqual(0L)) {
                b.setTypeQuotas(Saver.buildQuotaByStorageTypeEntries(quota));
            }
            if ((f = dir.getAclFeature()) != null) {
                b.setAcl(Saver.buildAclEntries(f, state.getStringMap()));
            }
            if ((xAttrFeature = dir.getXAttrFeature()) != null) {
                b.setXAttrs(Saver.buildXAttrs(xAttrFeature, state.getStringMap()));
            }
            return b;
        }

        Saver(FSImageFormatProtobuf.Saver parent, FsImageProto.FileSummary.Builder summary) {
            this.parent = parent;
            this.summary = summary;
            this.context = parent.getContext();
            this.fsn = this.context.getSourceNamesystem();
        }

        void serializeINodeDirectorySection(OutputStream out) throws IOException {
            Iterator<INodeWithAdditionalFields> iter = this.fsn.getFSDirectory().getINodeMap().getMapIterator();
            ArrayList<INodeReference> refList = this.parent.getSaverContext().getRefList();
            int i = 0;
            while (iter.hasNext()) {
                INodeWithAdditionalFields n = iter.next();
                if (!n.isDirectory()) continue;
                ReadOnlyList<INode> children = n.asDirectory().getChildrenList(0x7FFFFFFE);
                if (children.size() > 0) {
                    FsImageProto.INodeDirectorySection.DirEntry.Builder b = FsImageProto.INodeDirectorySection.DirEntry.newBuilder().setParent(n.getId());
                    for (INode inode : children) {
                        if (!inode.isReference()) {
                            b.addChildren(inode.getId());
                            continue;
                        }
                        refList.add(inode.asReference());
                        b.addRefChildren(refList.size() - 1);
                    }
                    FsImageProto.INodeDirectorySection.DirEntry e = b.build();
                    e.writeDelimitedTo(out);
                }
                if (++i % 4096 != 0) continue;
                this.context.checkCancelled();
            }
            this.parent.commitSection(this.summary, FSImageFormatProtobuf.SectionName.INODE_DIR);
        }

        void serializeINodeSection(OutputStream out) throws IOException {
            INodeMap inodesMap = this.fsn.dir.getINodeMap();
            FsImageProto.INodeSection.Builder b = FsImageProto.INodeSection.newBuilder().setLastInodeId(this.fsn.dir.getLastInodeId()).setNumInodes(inodesMap.size());
            FsImageProto.INodeSection s = b.build();
            s.writeDelimitedTo(out);
            int i = 0;
            Iterator<INodeWithAdditionalFields> iter = inodesMap.getMapIterator();
            while (iter.hasNext()) {
                INodeWithAdditionalFields n = iter.next();
                this.save(out, n);
                if (++i % 4096 != 0) continue;
                this.context.checkCancelled();
            }
            this.parent.commitSection(this.summary, FSImageFormatProtobuf.SectionName.INODE);
        }

        void serializeFilesUCSection(OutputStream out) throws IOException {
            Map<String, INodeFile> ucMap = this.fsn.getFilesUnderConstruction();
            for (Map.Entry<String, INodeFile> entry : ucMap.entrySet()) {
                String path = entry.getKey();
                INodeFile file = entry.getValue();
                FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.Builder b = FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.newBuilder().setInodeId(file.getId()).setFullPath(path);
                FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry e = b.build();
                e.writeDelimitedTo(out);
            }
            this.parent.commitSection(this.summary, FSImageFormatProtobuf.SectionName.FILES_UNDERCONSTRUCTION);
        }

        private void save(OutputStream out, INode n) throws IOException {
            if (n.isDirectory()) {
                this.save(out, n.asDirectory());
            } else if (n.isFile()) {
                this.save(out, n.asFile());
            } else if (n.isSymlink()) {
                this.save(out, n.asSymlink());
            }
        }

        private void save(OutputStream out, INodeDirectory n) throws IOException {
            FsImageProto.INodeSection.INodeDirectory.Builder b = Saver.buildINodeDirectory(n, this.parent.getSaverContext());
            FsImageProto.INodeSection.INode r = this.buildINodeCommon(n).setType(FsImageProto.INodeSection.INode.Type.DIRECTORY).setDirectory(b).build();
            r.writeDelimitedTo(out);
        }

        private void save(OutputStream out, INodeFile n) throws IOException {
            FileUnderConstructionFeature uc;
            FsImageProto.INodeSection.INodeFile.Builder b = Saver.buildINodeFile(n, this.parent.getSaverContext());
            if (n.getBlocks() != null) {
                for (BlockInfoContiguous block : n.getBlocks()) {
                    b.addBlocks(PBHelper.convert(block));
                }
            }
            if ((uc = n.getFileUnderConstructionFeature()) != null) {
                FsImageProto.INodeSection.FileUnderConstructionFeature f = FsImageProto.INodeSection.FileUnderConstructionFeature.newBuilder().setClientName(uc.getClientName()).setClientMachine(uc.getClientMachine()).build();
                b.setFileUC(f);
            }
            FsImageProto.INodeSection.INode r = this.buildINodeCommon(n).setType(FsImageProto.INodeSection.INode.Type.FILE).setFile(b).build();
            r.writeDelimitedTo(out);
        }

        private void save(OutputStream out, INodeSymlink n) throws IOException {
            FSImageFormatProtobuf.SaverContext state = this.parent.getSaverContext();
            FsImageProto.INodeSection.INodeSymlink.Builder b = FsImageProto.INodeSection.INodeSymlink.newBuilder().setPermission(Saver.buildPermissionStatus(n, state.getStringMap())).setTarget(ByteString.copyFrom((byte[])n.getSymlink())).setModificationTime(n.getModificationTime()).setAccessTime(n.getAccessTime());
            FsImageProto.INodeSection.INode r = this.buildINodeCommon(n).setType(FsImageProto.INodeSection.INode.Type.SYMLINK).setSymlink(b).build();
            r.writeDelimitedTo(out);
        }

        private final FsImageProto.INodeSection.INode.Builder buildINodeCommon(INode n) {
            return FsImageProto.INodeSection.INode.newBuilder().setId(n.getId()).setName(ByteString.copyFrom((byte[])n.getLocalNameBytes()));
        }
    }

    public static final class Loader {
        private final FSDirectory dir;
        private final FSNamesystem fsn;
        private final FSImageFormatProtobuf.Loader parent;

        public static PermissionStatus loadPermission(long id, String[] stringTable) {
            short perm = (short)(id & 0xFFFFL);
            int gsid = (int)(id >> 16 & 0xFFFFFFL);
            int usid = (int)(id >> 40 & 0xFFFFFFL);
            return new PermissionStatus(stringTable[usid], stringTable[gsid], new FsPermission(perm));
        }

        public static ImmutableList<AclEntry> loadAclEntries(FsImageProto.INodeSection.AclFeatureProto proto, String[] stringTable) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (int v : proto.getEntriesList()) {
                int p = v & 7;
                int t = v >> 3 & 3;
                int s = v >> 5 & 1;
                int nid = v >> 6 & 0xFFFFFF;
                String name = stringTable[nid];
                b.add((Object)new AclEntry.Builder().setName(name).setPermission(FSACTION_VALUES[p]).setScope(ACL_ENTRY_SCOPE_VALUES[s]).setType(ACL_ENTRY_TYPE_VALUES[t]).build());
            }
            return b.build();
        }

        public static ImmutableList<XAttr> loadXAttrs(FsImageProto.INodeSection.XAttrFeatureProto proto, String[] stringTable) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (FsImageProto.INodeSection.XAttrCompactProto xAttrCompactProto : proto.getXAttrsList()) {
                int v = xAttrCompactProto.getName();
                int nid = v >> 6 & 0xFFFFFF;
                int ns = v >> 30 & 3;
                ns |= (v >> 5 & 1) << 2;
                String name = stringTable[nid];
                byte[] value = null;
                if (xAttrCompactProto.getValue() != null) {
                    value = xAttrCompactProto.getValue().toByteArray();
                }
                b.add((Object)new XAttr.Builder().setNameSpace(XATTR_NAMESPACE_VALUES[ns]).setName(name).setValue(value).build());
            }
            return b.build();
        }

        public static ImmutableList<QuotaByStorageTypeEntry> loadQuotaByStorageTypeEntries(FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto proto) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (FsImageProto.INodeSection.QuotaByStorageTypeEntryProto quotaEntry : proto.getQuotasList()) {
                StorageType type = PBHelper.convertStorageType(quotaEntry.getStorageType());
                long quota = quotaEntry.getQuota();
                b.add((Object)new QuotaByStorageTypeEntry.Builder().setStorageType(type).setQuota(quota).build());
            }
            return b.build();
        }

        public static INodeDirectory loadINodeDirectory(FsImageProto.INodeSection.INode n, FSImageFormatProtobuf.LoaderContext state) {
            assert (n.getType() == FsImageProto.INodeSection.INode.Type.DIRECTORY);
            FsImageProto.INodeSection.INodeDirectory d = n.getDirectory();
            PermissionStatus permissions = Loader.loadPermission(d.getPermission(), state.getStringTable());
            INodeDirectory dir = new INodeDirectory(n.getId(), n.getName().toByteArray(), permissions, d.getModificationTime());
            long nsQuota = d.getNsQuota();
            long dsQuota = d.getDsQuota();
            if (nsQuota >= 0L || dsQuota >= 0L) {
                dir.addDirectoryWithQuotaFeature(new DirectoryWithQuotaFeature.Builder().nameSpaceQuota(nsQuota).storageSpaceQuota(dsQuota).build());
            }
            EnumCounters<StorageType> typeQuotas = null;
            if (d.hasTypeQuotas()) {
                ImmutableList<QuotaByStorageTypeEntry> qes = Loader.loadQuotaByStorageTypeEntries(d.getTypeQuotas());
                typeQuotas = new EnumCounters<StorageType>(StorageType.class, -1L);
                for (QuotaByStorageTypeEntry qe : qes) {
                    if (qe.getQuota() < 0L || qe.getStorageType() == null || !qe.getStorageType().supportTypeQuota()) continue;
                    typeQuotas.set(qe.getStorageType(), qe.getQuota());
                }
                if (typeQuotas.anyGreaterOrEqual(0L)) {
                    DirectoryWithQuotaFeature q = dir.getDirectoryWithQuotaFeature();
                    if (q == null) {
                        dir.addDirectoryWithQuotaFeature(new DirectoryWithQuotaFeature.Builder().typeQuotas(typeQuotas).build());
                    } else {
                        q.setQuota(typeQuotas);
                    }
                }
            }
            if (d.hasAcl()) {
                int[] entries = AclEntryStatusFormat.toInt(Loader.loadAclEntries(d.getAcl(), state.getStringTable()));
                dir.addAclFeature(new AclFeature(entries));
            }
            if (d.hasXAttrs()) {
                dir.addXAttrFeature(new XAttrFeature(Loader.loadXAttrs(d.getXAttrs(), state.getStringTable())));
            }
            return dir;
        }

        public static void updateBlocksMap(INodeFile file, BlockManager bm) {
            BlockInfoContiguous[] blocks = file.getBlocks();
            if (blocks != null) {
                for (int i = 0; i < blocks.length; ++i) {
                    file.setBlock(i, bm.addBlockCollection(blocks[i], file));
                }
            }
        }

        Loader(FSNamesystem fsn, FSImageFormatProtobuf.Loader parent) {
            this.fsn = fsn;
            this.dir = fsn.dir;
            this.parent = parent;
        }

        void loadINodeDirectorySection(InputStream in) throws IOException {
            FsImageProto.INodeDirectorySection.DirEntry e;
            ArrayList<INodeReference> refList = this.parent.getLoaderContext().getRefList();
            while ((e = FsImageProto.INodeDirectorySection.DirEntry.parseDelimitedFrom(in)) != null) {
                INodeDirectory p = this.dir.getInode(e.getParent()).asDirectory();
                Iterator<Number> i$ = e.getChildrenList().iterator();
                while (i$.hasNext()) {
                    long id = i$.next();
                    INode child = this.dir.getInode(id);
                    this.addToParent(p, child);
                }
                i$ = e.getRefChildrenList().iterator();
                while (i$.hasNext()) {
                    int refId = (Integer)i$.next();
                    INodeReference ref = (INodeReference)refList.get(refId);
                    this.addToParent(p, ref);
                }
            }
        }

        void loadINodeSection(InputStream in) throws IOException {
            FsImageProto.INodeSection s = FsImageProto.INodeSection.parseDelimitedFrom(in);
            this.fsn.dir.resetLastInodeId(s.getLastInodeId());
            LOG.info((Object)("Loading " + s.getNumInodes() + " INodes."));
            int i = 0;
            while ((long)i < s.getNumInodes()) {
                FsImageProto.INodeSection.INode p = FsImageProto.INodeSection.INode.parseDelimitedFrom(in);
                if (p.getId() == 16385L) {
                    this.loadRootINode(p);
                } else {
                    INode n = this.loadINode(p);
                    this.dir.addToInodeMap(n);
                }
                ++i;
            }
        }

        void loadFilesUnderConstructionSection(InputStream in) throws IOException {
            FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry entry;
            while ((entry = FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.parseDelimitedFrom(in)) != null) {
                INodeFile file = this.dir.getInode(entry.getInodeId()).asFile();
                FileUnderConstructionFeature uc = file.getFileUnderConstructionFeature();
                Preconditions.checkState((uc != null ? 1 : 0) != 0);
                this.fsn.leaseManager.addLease(uc.getClientName(), entry.getFullPath());
            }
        }

        private void addToParent(INodeDirectory parent, INode child) {
            if (parent == this.dir.rootDir && FSDirectory.isReservedName(child)) {
                throw new HadoopIllegalArgumentException("File name \"" + child.getLocalName() + "\" is reserved. Please " + " change the name of the existing file or directory to another " + "name before upgrading to this release.");
            }
            if (!parent.addChild(child)) {
                return;
            }
            this.dir.cacheName(child);
            if (child.isFile()) {
                Loader.updateBlocksMap(child.asFile(), this.fsn.getBlockManager());
            }
        }

        private INode loadINode(FsImageProto.INodeSection.INode n) {
            switch (n.getType()) {
                case FILE: {
                    return this.loadINodeFile(n);
                }
                case DIRECTORY: {
                    return Loader.loadINodeDirectory(n, this.parent.getLoaderContext());
                }
                case SYMLINK: {
                    return this.loadINodeSymlink(n);
                }
            }
            return null;
        }

        private INodeFile loadINodeFile(FsImageProto.INodeSection.INode n) {
            assert (n.getType() == FsImageProto.INodeSection.INode.Type.FILE);
            FsImageProto.INodeSection.INodeFile f = n.getFile();
            List<HdfsProtos.BlockProto> bp = f.getBlocksList();
            short replication = (short)f.getReplication();
            FSImageFormatProtobuf.LoaderContext state = this.parent.getLoaderContext();
            BlockInfoContiguous[] blocks = new BlockInfoContiguous[bp.size()];
            int e = bp.size();
            for (int i = 0; i < e; ++i) {
                blocks[i] = new BlockInfoContiguous(PBHelper.convert(bp.get(i)), replication);
            }
            PermissionStatus permissions = Loader.loadPermission(f.getPermission(), this.parent.getLoaderContext().getStringTable());
            INodeFile file = new INodeFile(n.getId(), n.getName().toByteArray(), permissions, f.getModificationTime(), f.getAccessTime(), blocks, replication, f.getPreferredBlockSize(), (byte)f.getStoragePolicyID());
            if (f.hasAcl()) {
                int[] entries = AclEntryStatusFormat.toInt(Loader.loadAclEntries(f.getAcl(), state.getStringTable()));
                file.addAclFeature(new AclFeature(entries));
            }
            if (f.hasXAttrs()) {
                file.addXAttrFeature(new XAttrFeature(Loader.loadXAttrs(f.getXAttrs(), state.getStringTable())));
            }
            if (f.hasFileUC()) {
                FsImageProto.INodeSection.FileUnderConstructionFeature uc = f.getFileUC();
                file.toUnderConstruction(uc.getClientName(), uc.getClientMachine());
                if (blocks.length > 0) {
                    BlockInfoContiguous lastBlk = file.getLastBlock();
                    file.setBlock(file.numBlocks() - 1, new BlockInfoContiguousUnderConstruction(lastBlk, replication));
                }
            }
            return file;
        }

        private INodeSymlink loadINodeSymlink(FsImageProto.INodeSection.INode n) {
            assert (n.getType() == FsImageProto.INodeSection.INode.Type.SYMLINK);
            FsImageProto.INodeSection.INodeSymlink s = n.getSymlink();
            PermissionStatus permissions = Loader.loadPermission(s.getPermission(), this.parent.getLoaderContext().getStringTable());
            INodeSymlink sym = new INodeSymlink(n.getId(), n.getName().toByteArray(), permissions, s.getModificationTime(), s.getAccessTime(), s.getTarget().toStringUtf8());
            return sym;
        }

        private void loadRootINode(FsImageProto.INodeSection.INode p) {
            XAttrFeature f;
            EnumCounters<StorageType> typeQuotas;
            INodeDirectory root = Loader.loadINodeDirectory(p, this.parent.getLoaderContext());
            QuotaCounts q = root.getQuotaCounts();
            long nsQuota = q.getNameSpace();
            long dsQuota = q.getStorageSpace();
            if (nsQuota != -1L || dsQuota != -1L) {
                this.dir.rootDir.getDirectoryWithQuotaFeature().setQuota(nsQuota, dsQuota);
            }
            if ((typeQuotas = q.getTypeSpaces()).anyGreaterOrEqual(0L)) {
                this.dir.rootDir.getDirectoryWithQuotaFeature().setQuota(typeQuotas);
            }
            this.dir.rootDir.cloneModificationTime(root);
            this.dir.rootDir.clonePermissionStatus(root);
            AclFeature af = (AclFeature)root.getFeature(AclFeature.class);
            if (af != null) {
                this.dir.rootDir.addAclFeature(af);
            }
            if ((f = root.getXAttrFeature()) != null) {
                this.dir.rootDir.addXAttrFeature(f);
            }
        }
    }
}

