/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.resolvers;

import com.google.common.base.Function;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.cache.ServiceCacheFactory;
import org.pentaho.di.trans.dataservice.resolvers.DataServiceResolver;
import org.pentaho.osgi.kettle.repository.locator.api.KettleRepositoryLocator;

public class TransientResolver
implements DataServiceResolver {
    public static final String DELIMITER = ":";
    public static final String PREFIX = "transient:";
    private KettleRepositoryLocator repositoryLocator;
    private DataServiceContext context;
    private ServiceCacheFactory cacheFactory;

    public TransientResolver(KettleRepositoryLocator repositoryLocator, DataServiceContext context, ServiceCacheFactory cacheFactory) {
        this.repositoryLocator = repositoryLocator;
        this.context = context;
        this.cacheFactory = cacheFactory;
    }

    @Override
    public DataServiceMeta getDataService(String dataServiceName) {
        if (!TransientResolver.isTransient(dataServiceName)) {
            return null;
        }
        return this.createDataServiceMeta(dataServiceName);
    }

    @Override
    public List<String> getDataServiceNames(String dataServiceName) {
        ArrayList<String> dataServiceNames = new ArrayList<String>();
        if (TransientResolver.isTransient(dataServiceName)) {
            dataServiceNames.add(dataServiceName);
        }
        return dataServiceNames;
    }

    @Override
    public List<DataServiceMeta> getDataServices(String dataServiceName, Function<Exception, Void> logger) {
        ArrayList<DataServiceMeta> dataServiceMetas = new ArrayList<DataServiceMeta>();
        if (TransientResolver.isTransient(dataServiceName)) {
            dataServiceMetas.add(this.createDataServiceMeta(dataServiceName));
        }
        return dataServiceMetas;
    }

    @Override
    public DataServiceExecutor.Builder createBuilder(SQL sql) {
        DataServiceMeta dataServiceMeta = this.getDataService(sql.getServiceName());
        if (dataServiceMeta != null) {
            return new DataServiceExecutor.Builder(sql, dataServiceMeta, this.context);
        }
        return null;
    }

    private DataServiceMeta createDataServiceMeta(String dataServiceName) {
        String stepName;
        String fileAndPath;
        try {
            String[] parts = this.splitTransient(dataServiceName);
            fileAndPath = TransientResolver.decode(parts[0].trim());
            stepName = TransientResolver.decode(parts[1].trim());
        }
        catch (Exception ignored) {
            return null;
        }
        Optional<TransMeta> transMeta = Stream.of(this.loadFromRepository(), TransMeta::new).map(loader -> loader.tryLoad(fileAndPath).orElse(null)).filter(Objects::nonNull).findFirst();
        Optional<DataServiceMeta> dataServiceMeta = transMeta.map(DataServiceMeta::new);
        dataServiceMeta.ifPresent(this.configure(dataServiceName, stepName));
        return dataServiceMeta.orElse(null);
    }

    private Consumer<DataServiceMeta> configure(String name, String step) {
        return dataServiceMeta -> {
            dataServiceMeta.setStepname(step);
            dataServiceMeta.setName(name);
            PushDownOptimizationMeta pushDownMeta = new PushDownOptimizationMeta();
            pushDownMeta.setStepName(step);
            pushDownMeta.setType(this.cacheFactory.createPushDown());
            dataServiceMeta.setPushDownOptimizationMeta(Collections.singletonList(pushDownMeta));
            dataServiceMeta.setUserDefined(false);
        };
    }

    private TransMetaLoader loadFromRepository() {
        return Optional.ofNullable(this.repositoryLocator).map(KettleRepositoryLocator::getRepository).flatMap(Optional::ofNullable).map(repository -> fileAndPath -> TransientResolver.loadFromRepository(repository, fileAndPath)).orElse(fileAndPath -> null);
    }

    private static TransMeta loadFromRepository(Repository repository, String filePath) throws KettleException {
        String name = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.length());
        String path = filePath.substring(0, filePath.lastIndexOf("/"));
        RepositoryDirectoryInterface root = repository.loadRepositoryDirectoryTree();
        RepositoryDirectoryInterface rd = root.findDirectory(path);
        if (rd == null) {
            rd = root;
        }
        return repository.loadTransformation(repository.getTransformationID(name, rd), null);
    }

    public static boolean isTransient(String dataServiceName) {
        return dataServiceName.startsWith(PREFIX);
    }

    public static String buildTransient(String filePath, String stepName) {
        return PREFIX + TransientResolver.encode(filePath) + DELIMITER + TransientResolver.encode(stepName);
    }

    private static String encode(String value) {
        return Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
    }

    private static String decode(String value) {
        return new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
    }

    public String[] splitTransient(String dataServiceName) {
        return dataServiceName.replace(PREFIX, "").split(DELIMITER);
    }

    @Override
    public List<String> getDataServiceNames() {
        return new ArrayList<String>();
    }

    @Override
    public List<DataServiceMeta> getDataServices(Function<Exception, Void> logger) {
        return new ArrayList<DataServiceMeta>();
    }

    private static interface TransMetaLoader {
        public TransMeta load(String var1) throws KettleException;

        default public Optional<TransMeta> tryLoad(String pathAndName) {
            try {
                return Optional.ofNullable(this.load(pathAndName));
            }
            catch (KettleException e) {
                return Optional.empty();
            }
        }
    }
}

