/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi;

import com.google.common.annotations.VisibleForTesting;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.pentaho.di.core.util.ExecutorUtil;
import org.pentaho.di.osgi.KettleLifecycleEvent;
import org.pentaho.di.osgi.OSGIPluginTracker;
import org.pentaho.di.osgi.service.lifecycle.LifecycleEvent;
import org.pentaho.di.osgi.service.notifier.DelayedServiceNotifierListener;
import org.pentaho.osgi.api.IKarafBlueprintWatcher;
import org.pentaho.osgi.api.IKarafFeatureWatcher;
import org.pentaho.platform.servicecoordination.api.IPhasedLifecycleEvent;
import org.pentaho.platform.servicecoordination.api.IPhasedLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafLifecycleListener
implements IPhasedLifecycleListener<KettleLifecycleEvent> {
    private static KarafLifecycleListener INSTANCE = new KarafLifecycleListener();
    private static Logger logger = LoggerFactory.getLogger(KarafLifecycleListener.class);
    private final long timeout;
    private final OSGIPluginTracker osgiPluginTracker;
    private AtomicBoolean listenerActive = new AtomicBoolean(false);
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private BundleContext bundleContext;
    private IPhasedLifecycleEvent<KettleLifecycleEvent> event;

    @VisibleForTesting
    KarafLifecycleListener() {
        this(KarafLifecycleListener.calculateTimeout());
    }

    @VisibleForTesting
    KarafLifecycleListener(long timeout) {
        this(timeout, OSGIPluginTracker.getInstance());
    }

    @VisibleForTesting
    KarafLifecycleListener(long timeout, OSGIPluginTracker osgiPluginTracker) {
        this.timeout = timeout;
        this.osgiPluginTracker = osgiPluginTracker;
    }

    private static long calculateTimeout() {
        long result = TimeUnit.SECONDS.toMillis(100L);
        String timeoutProp = System.getProperty(KarafLifecycleListener.class.getCanonicalName() + ".timeout");
        if (timeoutProp != null) {
            try {
                result = Long.parseLong(timeoutProp);
            }
            catch (Exception e) {
                logger.warn("Failed to parse custom timeout property of " + timeoutProp + ", returning default of 100,000");
            }
        }
        return result;
    }

    public static KarafLifecycleListener getInstance() {
        return INSTANCE;
    }

    public void onPhaseChange(IPhasedLifecycleEvent<KettleLifecycleEvent> event) {
        this.event = event;
        if (((KettleLifecycleEvent)((Object)event.getNotificationObject())).equals((Object)KettleLifecycleEvent.INIT)) {
            this.listenerActive.set(true);
            this.startTimeoutThread();
            this.maybeStartWatchers();
        } else {
            event.accept();
        }
    }

    private void startTimeoutThread() {
        Thread t = new Thread(new Runnable(){

            protected void finalize() throws Throwable {
                super.finalize();
            }

            @Override
            public void run() {
                long endWaitTime = System.currentTimeMillis() + KarafLifecycleListener.this.timeout;
                while (!KarafLifecycleListener.this.initialized.get() && endWaitTime - System.currentTimeMillis() > 0L) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                if (!KarafLifecycleListener.this.initialized.get()) {
                    logger.error("The Kettle Karaf Lifecycle Listener failed to execute properly after waiting for " + TimeUnit.MILLISECONDS.toSeconds(KarafLifecycleListener.this.timeout) + " seconds. Releasing lifecycle hold, but some services may be unavailable.");
                    KarafLifecycleListener.this.event.accept();
                }
            }
        });
        t.setDaemon(true);
        t.setName("KarafLifecycleListener Timeout Thread");
        t.start();
    }

    private void maybeStartWatchers() {
        if (this.bundleContext != null && this.listenerActive.get()) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ServiceReference featureWatcherServiceReference = KarafLifecycleListener.this.bundleContext.getServiceReference(IKarafFeatureWatcher.class);
                    try {
                        if (featureWatcherServiceReference == null) {
                            throw new IKarafFeatureWatcher.FeatureWatcherException("No IKarafFeatureWatcher service available");
                        }
                        IKarafFeatureWatcher karafFeatureWatcher = (IKarafFeatureWatcher)KarafLifecycleListener.this.bundleContext.getService(featureWatcherServiceReference);
                        karafFeatureWatcher.waitForFeatures();
                    }
                    catch (IKarafFeatureWatcher.FeatureWatcherException e) {
                        logger.error("Error in Feature Watcher", (Throwable)e);
                    }
                    ServiceReference blueprintWatcherServiceReference = KarafLifecycleListener.this.bundleContext.getServiceReference(IKarafBlueprintWatcher.class);
                    try {
                        if (blueprintWatcherServiceReference == null) {
                            throw new IKarafBlueprintWatcher.BlueprintWatcherException("No IKarafBlueprintWatcher service available");
                        }
                        IKarafBlueprintWatcher karafBlueprintWatcher = (IKarafBlueprintWatcher)KarafLifecycleListener.this.bundleContext.getService(blueprintWatcherServiceReference);
                        karafBlueprintWatcher.waitForBlueprint();
                    }
                    catch (IKarafBlueprintWatcher.BlueprintWatcherException e) {
                        logger.error("Error in Blueprint Watcher", (Throwable)e);
                    }
                    final AtomicBoolean accepted = new AtomicBoolean(false);
                    DelayedServiceNotifierListener delayedServiceNotifierListener = new DelayedServiceNotifierListener(){

                        @Override
                        public void onRun(LifecycleEvent lifecycleEvent, Object serviceObject) {
                            if (KarafLifecycleListener.this.osgiPluginTracker.getOutstandingServiceNotifierListeners() == 0 && !accepted.getAndSet(true)) {
                                logger.debug("Done waiting on delayed service notifiers");
                                KarafLifecycleListener.this.event.accept();
                                KarafLifecycleListener.this.osgiPluginTracker.removeDelayedServiceNotifierListener(this);
                            }
                        }
                    };
                    logger.debug("About to start waiting on delayed service notifiers");
                    KarafLifecycleListener.this.osgiPluginTracker.addDelayedServiceNotifierListener(delayedServiceNotifierListener);
                    delayedServiceNotifierListener.onRun(null, null);
                }
            });
            thread.setDaemon(true);
            thread.start();
            this.initialized.set(true);
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        bundleContext.registerService(ExecutorService.class, (Object)ExecutorUtil.getExecutor(), new Hashtable());
        this.maybeStartWatchers();
    }
}

