/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeListener;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.laf.BasePropertyHandler;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.ManagedColor;
import org.pentaho.di.ui.core.gui.ManagedFont;
import org.pentaho.di.ui.util.ImageUtil;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class GUIResource {
    private static LogChannelInterface log = new LogChannel((Object)"GUIResource");
    private static GUIResource guiResource;
    private Display display;
    private ManagedColor colorBackground;
    private ManagedColor colorGraph;
    private ManagedColor colorTab;
    private ManagedColor colorRed;
    private ManagedColor colorSuccessGreen;
    private ManagedColor colorBlueCustomGrid;
    private ManagedColor colorGreen;
    private ManagedColor colorBlue;
    private ManagedColor colorOrange;
    private ManagedColor colorYellow;
    private ManagedColor colorMagenta;
    private ManagedColor colorBlack;
    private ManagedColor colorGray;
    private ManagedColor colorDarkGray;
    private ManagedColor colorLightGray;
    private ManagedColor colorDemoGray;
    private ManagedColor colorWhite;
    private ManagedColor colorDirectory;
    private ManagedColor colorPentaho;
    private ManagedColor colorLightPentaho;
    private ManagedColor colorCreamPentaho;
    private ManagedColor colorLightBlue;
    private ManagedColor colorCrystalTextPentaho;
    private ManagedColor colorHopDefault;
    private ManagedColor colorHopOK;
    private ManagedFont fontGraph;
    private ManagedFont fontNote;
    private ManagedFont fontFixed;
    private ManagedFont fontMedium;
    private ManagedFont fontMediumBold;
    private ManagedFont fontLarge;
    private ManagedFont fontTiny;
    private ManagedFont fontSmall;
    private ManagedFont fontBold;
    private Map<String, SwtUniversalImage> imagesSteps = new Hashtable<String, SwtUniversalImage>();
    private Map<String, Image> imagesStepsSmall = new Hashtable<String, Image>();
    private Map<String, SwtUniversalImage> imagesJobentries;
    private Map<String, Image> imagesJobentriesSmall;
    private SwtUniversalImage imageHop;
    private SwtUniversalImage imageDisabledHop;
    private SwtUniversalImage imageConnection;
    private SwtUniversalImage imageConnectionTree;
    private Image imageAdd;
    private Image imageTable;
    private SwtUniversalImage imagePreview;
    private Image imageKeySmall;
    private Image imageColumnSmall;
    private Image imageSchema;
    private Image imageSynonym;
    private Image imageProcedure;
    private Image imageExploreDbSmall;
    private Image imageView;
    private Image imageKettleLogo;
    private SwtUniversalImage imageLogoSmall;
    private Image imageBanner;
    private SwtUniversalImage imageBol;
    private Image imageCalendar;
    private SwtUniversalImage imageCluster;
    private SwtUniversalImage imageSlave;
    private SwtUniversalImage imageArrow;
    private SwtUniversalImage imageFolder;
    private SwtUniversalImage imageTransRepo;
    private SwtUniversalImage imageJobRepo;
    private Image imageWizard;
    private Image imageCredits;
    private SwtUniversalImage imageStart;
    private SwtUniversalImage imageDummy;
    private SwtUniversalImage imageMissing;
    private Image imageSpoon;
    private Image imageJob;
    private Image imagePentaho;
    private Image imagePentahoSwirl;
    private SwtUniversalImage imageVariable;
    private SwtUniversalImage imageTransGraph;
    private SwtUniversalImage imagePartitionSchema;
    private SwtUniversalImage imageJobGraph;
    private SwtUniversalImage imageTransTree;
    private SwtUniversalImage imageJobTree;
    private SwtUniversalImage defaultArrow;
    private SwtUniversalImage okArrow;
    private SwtUniversalImage errorArrow;
    private SwtUniversalImage disabledArrow;
    private SwtUniversalImage candidateArrow;
    private Image imageUser;
    private Image imageProfil;
    private SwtUniversalImage imageFolderConnections;
    private Image imageEditOptionButton;
    private Image imageEditSmall;
    private Image imageExploreSolutionSmall;
    private Image imageColor;
    private Image imageNoteSmall;
    private Image imageResetOptionButton;
    private Image imageShowLog;
    private Image imageShowGrid;
    private Image imageShowHistory;
    private Image imageShowPerf;
    private Image imageShowInactive;
    private Image imageHideInactive;
    private Image imageShowSelected;
    private Image imageShowAll;
    private Image imageClosePanel;
    private Image imageMaximizePanel;
    private Image imageMinimizePanel;
    private Image imageShowErrorLines;
    private Image imageShowResults;
    private Image imageHideResults;
    private Image imageDesignPanel;
    private Image imageViewPanel;
    private SwtUniversalImage imageExpandAll;
    private Image imageSearchSmall;
    private Image imageRegExSmall;
    private SwtUniversalImage imageCollapseAll;
    private SwtUniversalImage imageStepError;
    private SwtUniversalImage imageCopyHop;
    private SwtUniversalImage imageErrorHop;
    private SwtUniversalImage imageInfoHop;
    private SwtUniversalImage imageWarning;
    private Image imageVersionBrowser;
    private Image imageNew;
    private SwtUniversalImage imageEdit;
    private Image imageDelete;
    private Image imageShowDeleted;
    private Image imagePauseLog;
    private Image imageContinueLog;
    private Image imageImport;
    private Image imageExport;
    private SwtUniversalImage imageHopInput;
    private SwtUniversalImage imageHopOutput;
    private SwtUniversalImage imageHopTarget;
    private SwtUniversalImage imageLocked;
    private SwtUniversalImage imageTrue;
    private SwtUniversalImage imageFalse;
    private SwtUniversalImage imageContextMenu;
    private SwtUniversalImage imageUnconditionalHop;
    private SwtUniversalImage imageParallelHop;
    private SwtUniversalImage imageBusy;
    private SwtUniversalImage imageInject;
    private SwtUniversalImage imageBalance;
    private SwtUniversalImage imageCheckpoint;
    private Image imageGantt;
    private Image imageHelpWeb;
    private Image imageEmpty16x16;
    private Map<String, Image> imageMap;
    private Map<RGB, Color> colorMap;
    private Image imageSpoonHigh;
    private Image imageHadoop;
    private Image imageDropHere;
    private Image imageTransCanvas;
    private Image imageJobCanvas;
    private Image imageAddAll;
    private Image imageAddSingle;
    private Image imageRemoveAll;
    private Image imageRemoveSingle;
    private static Clipboard clipboard;

    private GUIResource(Display display) {
        this.display = display;
        this.getResources();
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                GUIResource.this.dispose(false);
            }
        });
        clipboard = null;
        PluginRegistry.getInstance().addPluginListener(StepPluginType.class, new PluginTypeListener(){

            public void pluginAdded(Object serviceObject) {
                GUIResource.this.loadStepImages();
            }

            public void pluginRemoved(Object serviceObject) {
                GUIResource.this.loadStepImages();
            }

            public void pluginChanged(Object serviceObject) {
            }
        });
        PluginRegistry.getInstance().addPluginListener(JobEntryPluginType.class, new PluginTypeListener(){

            public void pluginAdded(Object serviceObject) {
                GUIResource.this.loadJobEntryImages();
            }

            public void pluginRemoved(Object serviceObject) {
                GUIResource.this.loadJobEntryImages();
            }

            public void pluginChanged(Object serviceObject) {
            }
        });
    }

    public static final GUIResource getInstance() {
        if (guiResource != null) {
            return guiResource;
        }
        guiResource = new GUIResource(PropsUI.getDisplay());
        return guiResource;
    }

    public void reload() {
        this.dispose(true);
        this.getResources();
    }

    private void getResources() {
        PropsUI props = PropsUI.getInstance();
        this.imageMap = new HashMap<String, Image>();
        this.colorMap = new HashMap<RGB, Color>();
        this.colorBackground = new ManagedColor(this.display, props.getBackgroundRGB());
        this.colorGraph = new ManagedColor(this.display, props.getGraphColorRGB());
        this.colorTab = new ManagedColor(this.display, props.getTabColorRGB());
        this.colorSuccessGreen = new ManagedColor(this.display, 0, 139, 0);
        this.colorRed = new ManagedColor(this.display, 255, 0, 0);
        this.colorGreen = new ManagedColor(this.display, 0, 255, 0);
        this.colorBlue = new ManagedColor(this.display, 0, 0, 255);
        this.colorYellow = new ManagedColor(this.display, 255, 255, 0);
        this.colorMagenta = new ManagedColor(this.display, 255, 0, 255);
        this.colorOrange = new ManagedColor(this.display, 255, 165, 0);
        this.colorBlueCustomGrid = new ManagedColor(this.display, 240, 248, 255);
        this.colorWhite = new ManagedColor(this.display, 255, 255, 255);
        this.colorDemoGray = new ManagedColor(this.display, 240, 240, 240);
        this.colorLightGray = new ManagedColor(this.display, 225, 225, 225);
        this.colorGray = new ManagedColor(this.display, 215, 215, 215);
        this.colorDarkGray = new ManagedColor(this.display, 100, 100, 100);
        this.colorBlack = new ManagedColor(this.display, 0, 0, 0);
        this.colorLightBlue = new ManagedColor(this.display, 135, 206, 250);
        this.colorDirectory = new ManagedColor(this.display, 0, 0, 255);
        this.colorPentaho = new ManagedColor(this.display, 188, 198, 82);
        this.colorLightPentaho = new ManagedColor(this.display, 238, 248, 152);
        this.colorCreamPentaho = new ManagedColor(this.display, 248, 246, 231);
        this.colorCrystalTextPentaho = new ManagedColor(this.display, 61, 99, 128);
        this.colorHopDefault = new ManagedColor(this.display, 61, 99, 128);
        this.colorHopOK = new ManagedColor(this.display, 12, 178, 15);
        this.loadFonts();
        this.loadCommonImages();
        this.loadStepImages();
        this.loadJobEntryImages();
    }

    private void dispose(boolean reload) {
        this.colorBackground.dispose();
        this.colorGraph.dispose();
        this.colorTab.dispose();
        this.colorRed.dispose();
        this.colorSuccessGreen.dispose();
        this.colorGreen.dispose();
        this.colorBlue.dispose();
        this.colorGray.dispose();
        this.colorYellow.dispose();
        this.colorMagenta.dispose();
        this.colorOrange.dispose();
        this.colorBlueCustomGrid.dispose();
        this.colorWhite.dispose();
        this.colorDemoGray.dispose();
        this.colorLightGray.dispose();
        this.colorDarkGray.dispose();
        this.colorBlack.dispose();
        this.colorLightBlue.dispose();
        this.colorDirectory.dispose();
        this.colorPentaho.dispose();
        this.colorLightPentaho.dispose();
        this.colorCreamPentaho.dispose();
        this.disposeColors(this.colorMap.values());
        if (!reload) {
            this.fontGraph.dispose();
            this.fontNote.dispose();
            this.fontFixed.dispose();
            this.fontMedium.dispose();
            this.fontMediumBold.dispose();
            this.fontLarge.dispose();
            this.fontTiny.dispose();
            this.fontSmall.dispose();
            this.fontBold.dispose();
            this.imageHop.dispose();
            this.imageDisabledHop.dispose();
            this.imageConnection.dispose();
            this.imageConnectionTree.dispose();
            this.imageAdd.dispose();
            this.imageTable.dispose();
            this.imagePreview.dispose();
            this.imageSchema.dispose();
            this.imageSynonym.dispose();
            this.imageProcedure.dispose();
            this.imageExploreDbSmall.dispose();
            this.imageView.dispose();
            this.imageLogoSmall.dispose();
            this.imageKettleLogo.dispose();
            this.imageBanner.dispose();
            this.imageBol.dispose();
            this.imageCalendar.dispose();
            this.imageCluster.dispose();
            this.imageSlave.dispose();
            this.imageArrow.dispose();
            this.imageFolder.dispose();
            this.imageTransRepo.dispose();
            this.imageJobRepo.dispose();
            this.imageWizard.dispose();
            this.imageCredits.dispose();
            this.imageStart.dispose();
            this.imageDummy.dispose();
            this.imageMissing.dispose();
            this.imageSpoon.dispose();
            this.imageJob.dispose();
            this.imagePentaho.dispose();
            this.imagePentahoSwirl.dispose();
            this.imageVariable.dispose();
            this.imageTransGraph.dispose();
            this.imagePartitionSchema.dispose();
            this.imageJobGraph.dispose();
            this.imageTransTree.dispose();
            this.imageJobTree.dispose();
            this.imageUser.dispose();
            this.imageProfil.dispose();
            this.imageFolderConnections.dispose();
            this.imageShowResults.dispose();
            this.imageHideResults.dispose();
            this.imageCollapseAll.dispose();
            this.imageStepError.dispose();
            this.imageCopyHop.dispose();
            this.imageErrorHop.dispose();
            this.imageInfoHop.dispose();
            this.imageWarning.dispose();
            this.imageVersionBrowser.dispose();
            this.imageExpandAll.dispose();
            this.imageSearchSmall.dispose();
            this.imageRegExSmall.dispose();
            this.imageViewPanel.dispose();
            this.imageDesignPanel.dispose();
            this.imageNew.dispose();
            this.imageEdit.dispose();
            this.imageDelete.dispose();
            this.imageShowDeleted.dispose();
            this.imagePauseLog.dispose();
            this.imageContinueLog.dispose();
            this.imageLocked.dispose();
            this.imageImport.dispose();
            this.imageExport.dispose();
            this.imageHopInput.dispose();
            this.imageHopOutput.dispose();
            this.imageHopTarget.dispose();
            this.imageKeySmall.dispose();
            this.imageColumnSmall.dispose();
            this.imageTrue.dispose();
            this.imageFalse.dispose();
            this.imageContextMenu.dispose();
            this.imageParallelHop.dispose();
            this.imageUnconditionalHop.dispose();
            this.imageBusy.dispose();
            this.imageEmpty16x16.dispose();
            this.imageInject.dispose();
            this.imageBalance.dispose();
            this.imageCheckpoint.dispose();
            this.imageGantt.dispose();
            this.imageHelpWeb.dispose();
            this.imageHadoop.dispose();
            this.imageDropHere.dispose();
            this.imageTransCanvas.dispose();
            this.imageJobCanvas.dispose();
            this.imageAddAll.dispose();
            this.imageAddSingle.dispose();
            this.imageRemoveAll.dispose();
            this.imageRemoveSingle.dispose();
            this.defaultArrow.dispose();
            this.okArrow.dispose();
            this.errorArrow.dispose();
            this.disabledArrow.dispose();
            this.candidateArrow.dispose();
            this.disposeImage(this.imageNoteSmall);
            this.disposeImage(this.imageColor);
            this.disposeImage(this.imageEditOptionButton);
            this.disposeImage(this.imageResetOptionButton);
            this.disposeImage(this.imageEditSmall);
            this.disposeImage(this.imageExploreSolutionSmall);
            this.disposeImage(this.imageShowLog);
            this.disposeImage(this.imageShowGrid);
            this.disposeImage(this.imageShowHistory);
            this.disposeImage(this.imageShowPerf);
            this.disposeImage(this.imageShowInactive);
            this.disposeImage(this.imageHideInactive);
            this.disposeImage(this.imageShowSelected);
            this.disposeImage(this.imageShowAll);
            this.disposeImage(this.imageClosePanel);
            this.disposeImage(this.imageMaximizePanel);
            this.disposeImage(this.imageMinimizePanel);
            this.disposeImage(this.imageShowErrorLines);
            this.disposeUniversalImages(this.imagesSteps.values());
            this.disposeImages(this.imagesStepsSmall.values());
            this.disposeImages(this.imageMap.values());
        }
    }

    private void disposeImages(Collection<Image> c) {
        for (Image image : c) {
            this.disposeImage(image);
        }
    }

    private void disposeUniversalImages(Collection<SwtUniversalImage> c) {
        for (SwtUniversalImage image : c) {
            image.dispose();
        }
    }

    private void disposeColors(Collection<Color> colors) {
        for (Color color : colors) {
            color.dispose();
        }
    }

    private void disposeImage(Image image) {
        if (image != null && !image.isDisposed()) {
            image.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStepImages() {
        PluginRegistry registry = PluginRegistry.getInstance();
        List steps = registry.getPlugins(StepPluginType.class);
        for (int i = 0; i < steps.size(); ++i) {
            if (this.imagesSteps.get(((PluginInterface)steps.get(i)).getIds()[0]) != null) continue;
            SwtUniversalImage image = null;
            Image small_image = null;
            String filename = ((PluginInterface)steps.get(i)).getImageFile();
            try {
                ClassLoader classLoader = registry.getClassLoader((PluginInterface)steps.get(i));
                image = SwtSvgImageUtil.getUniversalImage(this.display, classLoader, filename);
            }
            catch (Throwable t) {
                log.logError("Error occurred loading image [" + filename + "] for plugin " + steps.get(i), t);
            }
            finally {
                if (image == null) {
                    log.logError("Unable to load image file [" + filename + "] for plugin " + steps.get(i));
                    image = SwtSvgImageUtil.getMissingImage(this.display);
                }
            }
            if (image != null) {
                small_image = image.getAsBitmapForSize((Device)this.display, 24, 24);
            }
            this.imagesSteps.put(((PluginInterface)steps.get(i)).getIds()[0], image);
            this.imagesStepsSmall.put(((PluginInterface)steps.get(i)).getIds()[0], small_image);
        }
    }

    private void loadFonts() {
        PropsUI props = PropsUI.getInstance();
        this.fontGraph = new ManagedFont(this.display, props.getGraphFont());
        this.fontNote = new ManagedFont(this.display, props.getNoteFont());
        this.fontFixed = new ManagedFont(this.display, props.getFixedFont());
        FontData mediumFontData = new FontData(props.getGraphFont().getName(), (int)Math.round((double)props.getGraphFont().getHeight() * 1.2), props.getGraphFont().getStyle());
        this.fontMedium = new ManagedFont(this.display, mediumFontData);
        FontData mediumFontBoldData = new FontData(props.getGraphFont().getName(), (int)Math.round((double)props.getGraphFont().getHeight() * 1.2), props.getGraphFont().getStyle() | 1);
        this.fontMediumBold = new ManagedFont(this.display, mediumFontBoldData);
        FontData largeFontData = new FontData(props.getGraphFont().getName(), props.getGraphFont().getHeight() * 3, props.getGraphFont().getStyle());
        this.fontLarge = new ManagedFont(this.display, largeFontData);
        FontData tinyFontData = new FontData(props.getGraphFont().getName(), props.getGraphFont().getHeight() - 2, props.getGraphFont().getStyle());
        this.fontTiny = new ManagedFont(this.display, tinyFontData);
        FontData smallFontData = new FontData(props.getGraphFont().getName(), props.getGraphFont().getHeight() - 1, props.getGraphFont().getStyle());
        this.fontSmall = new ManagedFont(this.display, smallFontData);
        FontData boldFontData = new FontData(props.getDefaultFontData().getName(), props.getDefaultFontData().getHeight(), props.getDefaultFontData().getStyle() | 1);
        this.fontBold = new ManagedFont(this.display, boldFontData);
    }

    private Image loadAsResource(Display display, String location, int size) {
        SwtUniversalImage img = SwtSvgImageUtil.getImageAsResource(display, location);
        Image image = size > 0 ? new Image((Device)display, img.getAsBitmapForSize((Device)display, size, size), 0) : new Image((Device)display, img.getAsBitmap((Device)display), 0);
        img.dispose();
        return image;
    }

    private void loadCommonImages() {
        this.imageHop = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"HOP_image"));
        this.imageDisabledHop = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Disabled_HOP_image"));
        this.imageConnection = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"CNC_image"));
        this.imageConnectionTree = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"CNC_tree_image"));
        this.imageAdd = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Add_image"), 16);
        this.imageTable = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Table_image"), 16);
        this.imagePreview = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Preview_image"));
        this.imageSchema = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Schema_image"), 16);
        this.imageSynonym = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Synonym_image"), 16);
        this.imageView = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"View_image"), 16);
        this.imageColor = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Color_image"), 12);
        this.imageNoteSmall = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Note_image"), 12);
        this.imageProcedure = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ProcedureSmall_image"), 16);
        this.imageExploreDbSmall = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ExploreDbSmall_image"), 16);
        this.imageCluster = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Cluster_image"));
        this.imageSlave = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Slave_image"));
        this.imageKettleLogo = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Logo_lrg_image"), 0);
        this.imageBanner = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Banner_bg_image"), 0);
        this.imageBol = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"BOL_image"));
        this.imageCalendar = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Calendar_image"), 16);
        this.imageCredits = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Credits_image"), 0);
        this.imageStart = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"STR_image"));
        this.imageDummy = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"DUM_image"));
        this.imageMissing = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"MIS_image"));
        this.imageSpoon = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"spoon_image"), 0);
        this.imageSpoonHigh = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"spoon_image_high"));
        this.imageJob = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Chef_image"), 32);
        this.imagePentaho = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"CorpLogo_image"), 0);
        this.imagePentahoSwirl = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"CorpSwirl_image"), 0);
        this.imageVariable = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Variable_image"));
        this.imageEditOptionButton = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"EditOption_image"), 16);
        this.imageResetOptionButton = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ResetOption_image"), 16);
        this.imageEditSmall = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"EditSmall_image"), 16);
        this.imageExploreSolutionSmall = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ExploreSolutionSmall_image"), 16);
        this.imageShowLog = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowLog_image"), 16);
        this.imageShowGrid = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowGrid_image"), 16);
        this.imageShowHistory = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowHistory_image"), 16);
        this.imageShowPerf = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowPerf_image"), 16);
        this.imageShowInactive = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowInactive_image"), 16);
        this.imageHideInactive = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"HideInactive_image"), 16);
        this.imageShowSelected = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowSelected_image"), 32);
        this.imageShowAll = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowAll_image"), 32);
        this.imageClosePanel = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ClosePanel_image"), 16);
        this.imageMaximizePanel = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"MaximizePanel_image"), 16);
        this.imageMinimizePanel = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"MinimizePanel_image"), 16);
        this.imageShowErrorLines = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowErrorLines_image"), 16);
        this.imageShowResults = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowResults_image"), 16);
        this.imageHideResults = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"HideResults_image"), 16);
        this.imageDesignPanel = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"DesignPanel_image"), 0);
        this.imageViewPanel = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ViewPanel_image"), 0);
        this.imageExpandAll = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ExpandAll_image"));
        this.imageCollapseAll = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"CollapseAll_image"));
        this.imageStepError = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"StepErrorLines_image"));
        this.imageCopyHop = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"CopyHop_image"));
        this.imageErrorHop = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ErrorHop_image"));
        this.imageInfoHop = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"InfoHop_image"));
        this.imageWarning = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Warning_image"));
        this.imageVersionBrowser = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"VersionBrowser_image"), 16);
        this.imageNew = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Add_image"), 16);
        this.imageEdit = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"EditSmall_image"));
        this.imageDelete = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"DeleteOriginal_image"), 16);
        this.imageShowDeleted = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowDeleted_image"), 16);
        this.imagePauseLog = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"PauseLog_image"), 16);
        this.imageContinueLog = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ContinueLog_image"), 16);
        this.imageImport = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Import_image"), 16);
        this.imageExport = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Export_image"), 16);
        this.imageHopInput = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"HopInput_image"));
        this.imageHopOutput = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"HopOutput_image"));
        this.imageHopTarget = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"HopTarget_image"));
        this.imageLocked = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Locked_image"));
        this.imageTrue = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"True_image"));
        this.imageFalse = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"False_image"));
        this.imageContextMenu = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ContextMenu_image"));
        this.imageParallelHop = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ParallelHop_image"));
        this.imageUnconditionalHop = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"UnconditionalHop_image"));
        this.imageBusy = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Busy_image"));
        this.imageInject = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Inject_image"));
        this.imageBalance = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"LoadBalance_image"));
        this.imageCheckpoint = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"CheckeredFlag_image"));
        this.imageGantt = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Gantt_image"), 16);
        this.imageHelpWeb = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"HelpWeb_image"), 16);
        this.imageHadoop = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Hadoop_image"), 16);
        this.imageDropHere = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"DropHere_image"), 0);
        this.imageTransCanvas = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"TransCanvas_image"), 400);
        this.imageJobCanvas = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"JobCanvas_image"), 400);
        this.imageAddAll = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"AddAll_image"), 12);
        this.imageAddSingle = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"AddSingle_image"), 12);
        this.imageRemoveAll = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"RemoveAll_image"), 12);
        this.imageRemoveSingle = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"RemoveSingle_image"), 12);
        this.imageEmpty16x16 = new Image((Device)this.display, 16, 16);
        this.imageTransGraph = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"SpoonIcon_image"));
        this.imagePartitionSchema = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"Image_Partition_Schema"));
        this.imageJobGraph = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"ChefIcon_image"));
        this.imageTransTree = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"Trans_tree_image"));
        this.imageJobTree = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"Job_tree_image"));
        this.imageLogoSmall = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"Logo_sml_image"));
        this.imageArrow = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"ArrowIcon_image"));
        this.imageFolder = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"Folder_image"));
        this.imageTransRepo = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"TransRepo_image"));
        this.imageJobRepo = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"JobRepo_image"));
        this.imageWizard = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Wizard_image"), 0);
        this.imageBanner = ImageUtil.makeImageTransparent(this.display, this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Banner_bg_image"), 0), new RGB(255, 255, 255));
        this.imageUser = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"User_image"), 16);
        this.imageProfil = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"Profil_image"), 16);
        this.imageFolderConnections = SwtSvgImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"FolderConnections_image"));
        this.imageRegExSmall = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"RegExSmall_image"), 16);
        this.imageSearchSmall = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"SearchSmall_image"), 16);
        this.imageKeySmall = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"KeySmall_image"), 16);
        this.imageColumnSmall = this.loadAsResource(this.display, BasePropertyHandler.getProperty((String)"ColumnSmall_image"), 16);
        this.defaultArrow = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"defaultArrow_image"));
        this.okArrow = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"okArrow_image"));
        this.errorArrow = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"errorArrow_image"));
        this.disabledArrow = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"disabledArrow_image"));
        this.candidateArrow = SwtSvgImageUtil.getUniversalImage(this.display, this.getClass().getClassLoader(), BasePropertyHandler.getProperty((String)"candidateArrow_image"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJobEntryImages() {
        this.imagesJobentries = new Hashtable<String, SwtUniversalImage>();
        this.imagesJobentriesSmall = new Hashtable<String, Image>();
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(JobEntryPluginType.class);
        for (int i = 0; i < plugins.size(); ++i) {
            PluginInterface plugin = (PluginInterface)plugins.get(i);
            if ("SPECIAL".equals(plugin.getIds()[0])) continue;
            SwtUniversalImage image = null;
            Image small_image = null;
            String filename = plugin.getImageFile();
            try {
                ClassLoader classLoader = registry.getClassLoader(plugin);
                image = SwtSvgImageUtil.getUniversalImage(this.display, classLoader, filename);
            }
            catch (Throwable t) {
                log.logError("Error occurred loading image [" + filename + "] for plugin " + plugin.getIds()[0], t);
            }
            finally {
                if (image == null) {
                    log.logError("Unable to load image [" + filename + "] for plugin " + plugin.getIds()[0]);
                    image = SwtSvgImageUtil.getMissingImage(this.display);
                }
            }
            if (image != null) {
                small_image = image.getAsBitmapForSize((Device)this.display, 24, 24);
            }
            this.imagesJobentries.put(plugin.getIds()[0], image);
            this.imagesJobentriesSmall.put(plugin.getIds()[0], small_image);
        }
    }

    public Color getColorBackground() {
        return this.colorBackground.getColor();
    }

    public Color getColorBlack() {
        return this.colorBlack.getColor();
    }

    public Color getColorBlue() {
        return this.colorBlue.getColor();
    }

    public Color getColorDarkGray() {
        return this.colorDarkGray.getColor();
    }

    public Color getColorDemoGray() {
        return this.colorDemoGray.getColor();
    }

    public Color getColorDirectory() {
        return this.colorDirectory.getColor();
    }

    public Color getColorGraph() {
        return this.colorGraph.getColor();
    }

    public Color getColorGray() {
        return this.colorGray.getColor();
    }

    public Color getColorGreen() {
        return this.colorGreen.getColor();
    }

    public Color getColorLightGray() {
        return this.colorLightGray.getColor();
    }

    public Color getColorLightBlue() {
        return this.colorLightBlue.getColor();
    }

    public Color getColorMagenta() {
        return this.colorMagenta.getColor();
    }

    public Color getColorOrange() {
        return this.colorOrange.getColor();
    }

    public Color getColorSuccessGreen() {
        return this.colorSuccessGreen.getColor();
    }

    public Color getColorRed() {
        return this.colorRed.getColor();
    }

    public Color getColorBlueCustomGrid() {
        return this.colorBlueCustomGrid.getColor();
    }

    public Color getColorTab() {
        return this.colorTab.getColor();
    }

    public Color getColorWhite() {
        return this.colorWhite.getColor();
    }

    public Color getColorYellow() {
        return this.colorYellow.getColor();
    }

    public Display getDisplay() {
        return this.display;
    }

    public Font getFontFixed() {
        return this.fontFixed.getFont();
    }

    public Font getFontGraph() {
        return this.fontGraph.getFont();
    }

    public Font getFontNote() {
        return this.fontNote.getFont();
    }

    public Image getImageBol() {
        return this.imageBol.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageCalendar() {
        return this.imageCalendar;
    }

    public Image getImageCluster() {
        return this.imageCluster.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageClusterMedium() {
        return this.imageCluster.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public Image getImageSlave() {
        return this.imageSlave.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageSlaveMedium() {
        return this.imageSlave.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public Image getImageConnection() {
        return this.imageConnection.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageConnectionTree() {
        return this.imageConnectionTree.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public SwtUniversalImage getSwtImageConnection() {
        return this.imageConnection;
    }

    public Image getImageAdd() {
        return this.imageAdd;
    }

    public Image getImageTable() {
        return this.imageTable;
    }

    public Image getImagePreview() {
        return this.imagePreview.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageKeySmall() {
        return this.imageKeySmall;
    }

    public Image getImageColumnSmall() {
        return this.imageColumnSmall;
    }

    public Image getImageSchema() {
        return this.imageSchema;
    }

    public Image getImageSynonym() {
        return this.imageSynonym;
    }

    public Image getImageProcedure() {
        return this.imageProcedure;
    }

    public Image getImageExploreDbSmall() {
        return this.imageExploreDbSmall;
    }

    public Image getImageView() {
        return this.imageView;
    }

    public Image getImageNoteSmall() {
        return this.imageNoteSmall;
    }

    public Image getImageColor() {
        return this.imageColor;
    }

    public Image getImageCredits() {
        return this.imageCredits;
    }

    public Image getImageDummy() {
        return this.imageDummy.getAsBitmapForSize((Device)this.display, 32, 32);
    }

    public SwtUniversalImage getSwtImageDummy() {
        return this.imageDummy;
    }

    public Image getImageMissing() {
        return this.imageMissing.getAsBitmapForSize((Device)this.display, 32, 32);
    }

    public SwtUniversalImage getSwtImageMissing() {
        return this.imageMissing;
    }

    public Image getImageHop() {
        return this.imageHop.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageDisabledHop() {
        return this.imageDisabledHop.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageHopTree() {
        return this.imageHop.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public Image getImageDisabledHopTree() {
        return this.imageDisabledHop.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public Image getImageSpoon() {
        return this.imageSpoon;
    }

    public Image getImagePentaho() {
        return this.imagePentaho;
    }

    public Image getImagePentahoSwirl() {
        return this.imagePentahoSwirl;
    }

    public Map<String, SwtUniversalImage> getImagesSteps() {
        return this.imagesSteps;
    }

    public Map<String, Image> getImagesStepsSmall() {
        return this.imagesStepsSmall;
    }

    public Image getImageStart() {
        return this.imageStart.getAsBitmapForSize((Device)this.display, 32, 32);
    }

    public SwtUniversalImage getSwtImageStart() {
        return this.imageStart;
    }

    public Map<String, SwtUniversalImage> getImagesJobentries() {
        return this.imagesJobentries;
    }

    public void setImagesJobentries(Hashtable<String, SwtUniversalImage> imagesJobentries) {
        this.imagesJobentries = imagesJobentries;
    }

    public Map<String, Image> getImagesJobentriesSmall() {
        return this.imagesJobentriesSmall;
    }

    public void setImagesJobentriesSmall(Hashtable<String, Image> imagesJobentriesSmall) {
        this.imagesJobentriesSmall = imagesJobentriesSmall;
    }

    public Image getImageChef() {
        return this.imageJob;
    }

    public void setImageChef(Image imageChef) {
        this.imageJob = imageChef;
    }

    public Font getFontLarge() {
        return this.fontLarge.getFont();
    }

    public Font getFontTiny() {
        return this.fontTiny.getFont();
    }

    public Font getFontSmall() {
        return this.fontSmall.getFont();
    }

    public Clipboard getNewClipboard() {
        if (clipboard != null) {
            clipboard.dispose();
            clipboard = null;
        }
        clipboard = new Clipboard(this.display);
        return clipboard;
    }

    public void toClipboard(String cliptext) {
        if (cliptext == null) {
            return;
        }
        this.getNewClipboard();
        TextTransfer tran = TextTransfer.getInstance();
        clipboard.setContents((Object[])new String[]{cliptext}, new Transfer[]{tran});
    }

    public String fromClipboard() {
        this.getNewClipboard();
        TextTransfer tran = TextTransfer.getInstance();
        return (String)clipboard.getContents((Transfer)tran);
    }

    public Font getFontBold() {
        return this.fontBold.getFont();
    }

    public Image getImageVariable() {
        return this.imageVariable.getAsBitmapForSize((Device)this.display, 13, 13);
    }

    public Image getImageTransGraph() {
        return this.imageTransGraph.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageTransTree() {
        return this.imageTransTree.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public Image getImageUser() {
        return this.imageUser;
    }

    public Image getImageProfil() {
        return this.imageProfil;
    }

    public Image getImageFolderConnections() {
        return this.imageTransGraph.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageFolderConnectionsMedium() {
        return this.imageTransGraph.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public Image getImagePartitionSchema() {
        return this.imagePartitionSchema.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public Image getImageJobGraph() {
        return this.imageJobGraph.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageJobTree() {
        return this.imageJobTree.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public Image getEditOptionButton() {
        return this.imageEditOptionButton;
    }

    public Image getResetOptionButton() {
        return this.imageResetOptionButton;
    }

    public Image getImageEditSmall() {
        return this.imageEditSmall;
    }

    public Image getImageExploreSolutionSmall() {
        return this.imageExploreSolutionSmall;
    }

    public Image getImageArrow() {
        return this.imageArrow.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageArrow() {
        return this.imageArrow;
    }

    public Image getImageFolder() {
        return this.imageFolder.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public Image getImageJobRepo() {
        return this.imageJobRepo.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public SwtUniversalImage getSwtImageJobRepo() {
        return this.imageJobRepo;
    }

    public Image getImageTransRepo() {
        return this.imageTransRepo.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public SwtUniversalImage getSwtImageTransRepo() {
        return this.imageTransRepo;
    }

    public Image getImageDummySmall() {
        return this.imageDummy.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageStartSmall() {
        return this.imageStart.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageDummyMedium() {
        return this.imageDummy.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public Image getImageStartMedium() {
        return this.imageStart.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public Image getImageBanner() {
        return this.imageBanner;
    }

    public Image getImageWizard() {
        return this.imageWizard;
    }

    public void setImageBanner(Image imageBanner) {
        this.imageBanner = imageBanner;
    }

    public Image getImageKettleLogo() {
        return this.imageKettleLogo;
    }

    public void setImageKettleLogo(Image imageKettleLogo) {
        this.imageKettleLogo = imageKettleLogo;
    }

    public Color getColorPentaho() {
        return this.colorPentaho.getColor();
    }

    public Image getImageLogoSmall() {
        return this.imageLogoSmall.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Color getColorLightPentaho() {
        return this.colorLightPentaho.getColor();
    }

    public Color getColorCreamPentaho() {
        return this.colorCreamPentaho.getColor();
    }

    public Color getColorCrystalTextPentaho() {
        return this.colorCrystalTextPentaho.getColor();
    }

    public Color getColorHopDefault() {
        return this.colorHopDefault.getColor();
    }

    public Color getColorHopOK() {
        return this.colorHopOK.getColor();
    }

    public void drawPentahoGradient(Display display, GC gc, Rectangle rect, boolean vertical) {
        if (!vertical) {
            gc.setForeground(display.getSystemColor(22));
            gc.setBackground(GUIResource.getInstance().getColorPentaho());
            gc.fillGradientRectangle(rect.x, rect.y, 2 * rect.width / 3, rect.height, vertical);
            gc.setForeground(GUIResource.getInstance().getColorPentaho());
            gc.setBackground(display.getSystemColor(22));
            gc.fillGradientRectangle(rect.x + 2 * rect.width / 3, rect.y, rect.width / 3 + 1, rect.height, vertical);
        } else {
            gc.setForeground(display.getSystemColor(22));
            gc.setBackground(GUIResource.getInstance().getColorPentaho());
            gc.fillGradientRectangle(rect.x, rect.y, rect.width, 2 * rect.height / 3, vertical);
            gc.setForeground(GUIResource.getInstance().getColorPentaho());
            gc.setBackground(display.getSystemColor(22));
            gc.fillGradientRectangle(rect.x, rect.y + 2 * rect.height / 3, rect.width, rect.height / 3 + 1, vertical);
        }
    }

    public Object[] messageDialogWithToggle(Shell shell, String dialogTitle, Image image, String message, int dialogImageType, String[] buttonLabels, int defaultIndex, String toggleMessage, boolean toggleState) {
        int imageType = 0;
        switch (dialogImageType) {
            case 1: {
                imageType = 4;
                break;
            }
        }
        MessageDialogWithToggle md = new MessageDialogWithToggle(shell, dialogTitle, image, message, imageType, buttonLabels, defaultIndex, toggleMessage, toggleState);
        int idx = md.open();
        return new Object[]{idx, md.getToggleState()};
    }

    public static Point calculateControlPosition(Control control) {
        Rectangle r = control.getBounds();
        Point p = control.getParent().toDisplay(r.x, r.y);
        return p;
    }

    public Font getFontMedium() {
        return this.fontMedium.getFont();
    }

    public Font getFontMediumBold() {
        return this.fontMediumBold.getFont();
    }

    public Image getImageShowLog() {
        return this.imageShowLog;
    }

    public Image getImageShowGrid() {
        return this.imageShowGrid;
    }

    public Image getImageShowHistory() {
        return this.imageShowHistory;
    }

    public Image getImageShowPerf() {
        return this.imageShowPerf;
    }

    public Image getImageHideInactive() {
        return this.imageHideInactive;
    }

    public Image getImageShowInactive() {
        return this.imageShowInactive;
    }

    public Image getImageShowSelected() {
        return this.imageShowSelected;
    }

    public Image getImageShowAll() {
        return this.imageShowAll;
    }

    public Image getImageClosePanel() {
        return this.imageClosePanel;
    }

    public Image getImageMaximizePanel() {
        return this.imageMaximizePanel;
    }

    public Image getImageMinimizePanel() {
        return this.imageMinimizePanel;
    }

    public Image getImageShowErrorLines() {
        return this.imageShowErrorLines;
    }

    public Image getImageShowResults() {
        return this.imageShowResults;
    }

    public Image getImageHideResults() {
        return this.imageHideResults;
    }

    public Image getImageDesignPanel() {
        return this.imageDesignPanel;
    }

    public Image getImageViewPanel() {
        return this.imageViewPanel;
    }

    public Image getImageExpandAll() {
        return this.imageExpandAll.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageExpandAllMedium() {
        return this.imageExpandAll.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public Image getImageSearchSmall() {
        return this.imageSearchSmall;
    }

    public Image getImageRegexSmall() {
        return this.imageRegExSmall;
    }

    public Image getImageCollapseAll() {
        return this.imageCollapseAll.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageCollapseAllMedium() {
        return this.imageCollapseAll.getAsBitmapForSize((Device)this.display, 24, 24);
    }

    public Image getImageStepError() {
        return this.imageStepError.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageStepError() {
        return this.imageStepError;
    }

    public Image getImageCopyHop() {
        return this.imageCopyHop.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageCopyHop() {
        return this.imageCopyHop;
    }

    public Image getImageErrorHop() {
        return this.imageErrorHop.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageErrorHop() {
        return this.imageErrorHop;
    }

    public Image getImageInfoHop() {
        return this.imageInfoHop.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageInfoHop() {
        return this.imageInfoHop;
    }

    public Image getImageWarning() {
        return this.imageWarning.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageWarning32() {
        return this.imageWarning.getAsBitmapForSize((Device)this.display, 32, 32);
    }

    public SwtUniversalImage getSwtImageWarning() {
        return this.imageWarning;
    }

    public Image getImageVersionBrowser() {
        return this.imageVersionBrowser;
    }

    public Image getImageNew() {
        return this.imageNew;
    }

    public Image getImageEdit() {
        return this.imageEdit.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageEdit() {
        return this.imageEdit;
    }

    public Image getImageDelete() {
        return this.imageDelete;
    }

    public Image getImageShowDeleted() {
        return this.imageShowDeleted;
    }

    public Image getImagePauseLog() {
        return this.imagePauseLog;
    }

    public Image getImageContinueLog() {
        return this.imageContinueLog;
    }

    public Image getImageImport() {
        return this.imageImport;
    }

    public Image getImageExport() {
        return this.imageExport;
    }

    public Image getImageHopInput() {
        return this.imageHopInput.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageHopInput() {
        return this.imageHopInput;
    }

    public Image getImageHopOutput() {
        return this.imageHopOutput.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageHopOutput() {
        return this.imageHopOutput;
    }

    public Image getImageHopTarget() {
        return this.imageHopTarget.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageHopTarget() {
        return this.imageHopTarget;
    }

    public Image getImageLocked() {
        return this.imageLocked.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageLocked() {
        return this.imageLocked;
    }

    public Image getImage(String location) {
        return this.getImage(location, 16, 16);
    }

    public Image getImage(String location, int width, int height) {
        Image image = this.imageMap.get(location);
        if (image == null) {
            SwtUniversalImage svg = SwtSvgImageUtil.getImage(this.display, location);
            image = new Image((Device)this.display, svg.getAsBitmapForSize((Device)this.display, width, height), 0);
            svg.dispose();
            this.imageMap.put(location, image);
        }
        return image;
    }

    public Image getImage(String location, ClassLoader classLoader, int width, int height) {
        Image image = this.imageMap.get(location);
        if (image == null) {
            SwtUniversalImage svg = SwtSvgImageUtil.getUniversalImage(this.display, classLoader, location);
            image = new Image((Device)this.display, svg.getAsBitmapForSize((Device)this.display, width, height), 0);
            svg.dispose();
            this.imageMap.put(location, image);
        }
        return image;
    }

    public Color getColor(int red, int green, int blue) {
        RGB rgb = new RGB(red, green, blue);
        Color color = this.colorMap.get(rgb);
        if (color == null) {
            color = new Color((Device)this.display, rgb);
            this.colorMap.put(rgb, color);
        }
        return color;
    }

    public Map<String, Image> getImageMap() {
        return this.imageMap;
    }

    public Image getImageTrue() {
        return this.imageTrue.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageTrue() {
        return this.imageTrue;
    }

    public Image getImageFalse() {
        return this.imageFalse.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageFalse() {
        return this.imageFalse;
    }

    public Image getImageContextMenu() {
        return this.imageContextMenu.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageContextMenu() {
        return this.imageContextMenu;
    }

    public Image getImageParallelHop() {
        return this.imageParallelHop.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageParallelHop() {
        return this.imageParallelHop;
    }

    public Image getImageUnconditionalHop() {
        return this.imageUnconditionalHop.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageUnconditionalHop() {
        return this.imageUnconditionalHop;
    }

    public Image getImageBusy() {
        return this.imageBusy.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageBusy() {
        return this.imageBusy;
    }

    public Image getImageEmpty16x16() {
        return this.imageEmpty16x16;
    }

    public Image getImageInject() {
        return this.imageInject.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageInject() {
        return this.imageInject;
    }

    public Image getImageBalance() {
        return this.imageBalance.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageBalance() {
        return this.imageBalance;
    }

    public Image getImageSpoonHigh() {
        return this.imageSpoonHigh;
    }

    public void setImageSpoonHigh(Image imageSpoonHigh) {
        this.imageSpoonHigh = imageSpoonHigh;
    }

    public Image getImageCheckpoint() {
        return this.imageCheckpoint.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageCheckpoint() {
        return this.imageCheckpoint;
    }

    public Image getImageGantt() {
        return this.imageGantt;
    }

    public Image getImageHelpWeb() {
        return this.imageHelpWeb;
    }

    public Image getHadoop() {
        return this.imageHadoop;
    }

    public void setImageDropHere(Image imageDropHere) {
        this.imageDropHere = imageDropHere;
    }

    public Image getImageDropHere() {
        return this.imageDropHere;
    }

    public Image getImageTransCanvas() {
        return this.imageTransCanvas;
    }

    public void setImageTransCanvas(Image imageTransCanvas) {
        this.imageTransCanvas = imageTransCanvas;
    }

    public Image getImageJobCanvas() {
        return this.imageJobCanvas;
    }

    public void setImageJobCanvas(Image imageJobCanvas) {
        this.imageJobCanvas = imageJobCanvas;
    }

    public void setImageAddAll(Image imageAddAll) {
        this.imageAddAll = imageAddAll;
    }

    public Image getImageAddAll() {
        return this.imageAddAll;
    }

    public void setImageAddSingle(Image imageAddSingle) {
        this.imageAddSingle = imageAddSingle;
    }

    public Image getImageAddSingle() {
        return this.imageAddSingle;
    }

    public void setImageRemoveAll(Image imageRemoveAll) {
        this.imageRemoveAll = imageRemoveAll;
    }

    public Image getImageRemoveAll() {
        return this.imageRemoveAll;
    }

    public void setImageRemoveSingle(Image imageRemoveSingle) {
        this.imageRemoveSingle = imageRemoveSingle;
    }

    public Image getImageRemoveSingle() {
        return this.imageRemoveSingle;
    }

    public SwtUniversalImage getDefaultArrow() {
        return this.defaultArrow;
    }

    public SwtUniversalImage getOkArrow() {
        return this.okArrow;
    }

    public SwtUniversalImage getErrorArrow() {
        return this.errorArrow;
    }

    public SwtUniversalImage getDisabledArrow() {
        return this.disabledArrow;
    }

    public SwtUniversalImage getCandidateArrow() {
        return this.candidateArrow;
    }
}

