/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class MultiSearchRequest
extends ActionRequest<MultiSearchRequest>
implements CompositeIndicesRequest {
    private List<SearchRequest> requests = new ArrayList<SearchRequest>();
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosed();

    public MultiSearchRequest add(SearchRequestBuilder request) {
        this.requests.add(request.request());
        return this;
    }

    public MultiSearchRequest add(SearchRequest request) {
        this.requests.add(request);
        return this;
    }

    public MultiSearchRequest add(byte[] data, int from, int length, boolean isTemplateRequest, @Nullable String[] indices, @Nullable String[] types, @Nullable String searchType) throws Exception {
        return this.add(new BytesArray(data, from, length), isTemplateRequest, indices, types, searchType, null, IndicesOptions.strictExpandOpenAndForbidClosed(), true);
    }

    public MultiSearchRequest add(BytesReference data, boolean isTemplateRequest, @Nullable String[] indices, @Nullable String[] types, @Nullable String searchType, IndicesOptions indicesOptions) throws Exception {
        return this.add(data, isTemplateRequest, indices, types, searchType, null, indicesOptions, true);
    }

    public MultiSearchRequest add(BytesReference data, boolean isTemplateRequest, @Nullable String[] indices, @Nullable String[] types, @Nullable String searchType, @Nullable String routing, IndicesOptions indicesOptions, boolean allowExplicitIndex) throws Exception {
        int nextMarker;
        XContent xContent = XContentFactory.xContent(data);
        int from = 0;
        int length = data.length();
        byte marker = xContent.streamSeparator();
        while ((nextMarker = this.findNextMarker(marker, from, data, length)) != -1) {
            if (nextMarker == 0) {
                from = nextMarker + 1;
                continue;
            }
            SearchRequest searchRequest = new SearchRequest();
            if (indices != null) {
                searchRequest.indices(indices);
            }
            if (indicesOptions != null) {
                searchRequest.indicesOptions(indicesOptions);
            }
            if (types != null && types.length > 0) {
                searchRequest.types(types);
            }
            if (routing != null) {
                searchRequest.routing(routing);
            }
            searchRequest.searchType(searchType);
            IndicesOptions defaultOptions = IndicesOptions.strictExpandOpenAndForbidClosed();
            if (nextMarker - from > 0) {
                try (XContentParser parser = xContent.createParser(data.slice(from, nextMarker - from));){
                    Map<String, Object> source = parser.map();
                    for (Map.Entry<String, Object> entry : source.entrySet()) {
                        Object value = entry.getValue();
                        if ("index".equals(entry.getKey()) || "indices".equals(entry.getKey())) {
                            if (!allowExplicitIndex) {
                                throw new IllegalArgumentException("explicit index in multi percolate is not allowed");
                            }
                            searchRequest.indices(XContentMapValues.nodeStringArrayValue(value));
                            continue;
                        }
                        if ("type".equals(entry.getKey()) || "types".equals(entry.getKey())) {
                            searchRequest.types(XContentMapValues.nodeStringArrayValue(value));
                            continue;
                        }
                        if ("search_type".equals(entry.getKey()) || "searchType".equals(entry.getKey())) {
                            searchRequest.searchType(XContentMapValues.nodeStringValue(value, null));
                            continue;
                        }
                        if ("request_cache".equals(entry.getKey()) || "requestCache".equals(entry.getKey())) {
                            searchRequest.requestCache(XContentMapValues.nodeBooleanValue(value));
                            continue;
                        }
                        if ("preference".equals(entry.getKey())) {
                            searchRequest.preference(XContentMapValues.nodeStringValue(value, null));
                            continue;
                        }
                        if (!"routing".equals(entry.getKey())) continue;
                        searchRequest.routing(XContentMapValues.nodeStringValue(value, null));
                    }
                    defaultOptions = IndicesOptions.fromMap(source, defaultOptions);
                }
            }
            searchRequest.indicesOptions(defaultOptions);
            from = nextMarker + 1;
            nextMarker = this.findNextMarker(marker, from, data, length);
            if (nextMarker == -1) break;
            if (isTemplateRequest) {
                searchRequest.templateSource(data.slice(from, nextMarker - from));
            } else {
                searchRequest.source(data.slice(from, nextMarker - from));
            }
            from = nextMarker + 1;
            this.add(searchRequest);
        }
        return this;
    }

    private int findNextMarker(byte marker, int from, BytesReference data, int length) {
        for (int i = from; i < length; ++i) {
            if (data.get(i) != marker) continue;
            return i;
        }
        return -1;
    }

    public List<SearchRequest> requests() {
        return this.requests;
    }

    @Override
    public List<? extends IndicesRequest> subRequests() {
        return this.requests;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            ActionRequestValidationException ex = this.requests.get(i).validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public MultiSearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            SearchRequest request = new SearchRequest();
            request.readFrom(in);
            this.requests.add(request);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.requests.size());
        for (SearchRequest request : this.requests) {
            request.writeTo(out);
        }
    }
}

