/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XmlUtils;
import org.json.JSONObject;

public class ELConstantsFunctions {
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final long PB = 0x4000000000000L;
    public static final int SUBMIT_MINUTES = 1;
    public static final int SUBMIT_HOURS = 60;
    public static final int SUBMIT_DAYS = 1440;

    public static Object firstNotNull(Object o1, Object o2) {
        return o1 != null ? o1 : o2;
    }

    public static String concat(String s1, String s2) {
        StringBuilder sb = new StringBuilder();
        if (s1 != null) {
            sb.append(s1);
        }
        if (s2 != null) {
            sb.append(s2);
        }
        return sb.toString();
    }

    public static String replaceAll(String src, String regex, String replacement) {
        if (src != null && regex != null) {
            if (replacement == null) {
                replacement = "";
            }
            return src.replaceAll(regex, replacement);
        }
        return src;
    }

    public static String appendAll(String src, String append, String delimeter) {
        if (src != null && delimeter != null) {
            if (append == null) {
                append = "";
            }
            String[] ret = src.split(delimeter);
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < ret.length; ++i) {
                result.append(ret[i]).append(append);
                if (i >= ret.length - 1) continue;
                result.append(delimeter);
            }
            if (src.startsWith(delimeter) && ret.length > 0 && !ret[0].equals("")) {
                result.insert(0, append);
            }
            return result.toString();
        }
        return src;
    }

    public static String trim(String input) {
        return input == null ? "" : input.trim();
    }

    public static String timestamp() {
        return DateUtils.formatDateOozieTZ(new Date());
    }

    public static String urlEncode(String input) {
        try {
            return input == null ? "" : URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("It should never happen");
        }
    }

    public static String toJsonStr(Map<String, String> map) {
        JSONObject json = new JSONObject(map);
        return XmlUtils.escapeCharsForXML(json.toString());
    }

    public static String toPropertiesStr(Map<String, String> map) {
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        return XmlUtils.escapeCharsForXML(PropertiesUtils.propertiesToString(props));
    }

    public static String toConfigurationStr(Map<String, String> map) {
        Configuration conf = new Configuration(false);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
        return XmlUtils.escapeCharsForXML(XmlUtils.prettyPrint(conf).toString());
    }
}

